/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.sqf;

import com.intersys.sqf.Utl;
import java.io.Serializable;
import java.net.URI;

public final class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String host;
    public final int port;
    public final String namespace;
    public final String user;
    public final String password;

    public Address(String url) throws Exception {
        this(url, "", "");
    }

    public Address(URI uri) throws Exception {
        this(uri, "", "");
    }

    public Address(String host, int port, String namespace) {
        this(host, port, namespace, "", "");
    }

    public Address(String url, String user, String password) throws Exception {
        this(new URI(url), user, password);
    }

    public Address(URI uri, String u, String z) throws Exception {
        assert (uri != null && u != null && z != null);
        String h = uri.getHost();
        int p = uri.getPort();
        String n = uri.getPath();
        if (h == null || h.isEmpty()) {
            Utl.fail("bad Cach\u00e9 instance host name", new Object[0]);
        }
        if (p < 0 || p > 65535) {
            Utl.fail("bad Cach\u00e9 instance port (%d)", p);
        }
        if (n == null || n.isEmpty() || n.compareTo("/") == 0) {
            Utl.fail("bad Cach\u00e9 instance namespace", new Object[0]);
        }
        if (n.charAt(0) == '/') {
            n = n.substring(1);
        }
        this.host = h;
        this.port = p;
        this.namespace = n;
        this.user = u;
        this.password = z;
    }

    public Address(String h, int p, String n, String u, String z) {
        assert (h != null && n != null && u != null && z != null);
        this.host = h;
        this.port = p;
        this.namespace = n;
        this.user = u;
        this.password = z;
    }

    public boolean hasCredentials() {
        return !this.user.isEmpty() && !this.password.isEmpty();
    }

    public String getJDBCString() {
        return String.format("jdbc:Cache://%s:%d/%s", this.host, this.port, this.namespace);
    }

    public String getURL() {
        return String.format("Cache://%s:%d/%s", this.host, this.port, this.namespace);
    }

    public String toString() {
        return this.getURL();
    }
}

