/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jgss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class GSSCallbackHandler
implements CallbackHandler {
    String username = null;
    String password = null;

    public GSSCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public GSSCallbackHandler() {
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println(toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                if (this.username != null && this.username.length() > 0) {
                    nc.setName(this.username);
                    continue;
                }
                System.err.print(nc.getPrompt());
                System.err.flush();
                nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                if (this.password != null && this.password.length() > 0) {
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                pc.setPassword(this.readPassword(System.in, pc.getPrompt()));
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private char[] readPassword(InputStream in, String prompt) throws IOException {
        char[] lineBuffer;
        MaskingThread maskingthread = new MaskingThread(prompt);
        if (!System.getProperty("os.name").equals("OpenVMS")) {
            Thread thread = new Thread(maskingthread);
            thread.start();
        }
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        maskingthread.stopMasking();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;
        private String prompt;

        public MaskingThread(String prompt) {
            int ind;
            if (!prompt.endsWith(" ")) {
                prompt = prompt + " ";
            }
            System.out.print(prompt);
            while ((ind = prompt.indexOf(10)) >= 0) {
                prompt = prompt.substring(ind + 1);
            }
            this.prompt = prompt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\r" + this.prompt + " \b");
                    System.out.flush();
                    try {
                        Thread.currentThread();
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

