/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import java.io.InputStreamReader;

public final class ConnectionInfo
implements Cloneable {
    int protocolVersion = 53;
    String serverLocale = "ISO8859_1";
    boolean isUnicodeServer = false;
    boolean useIEEEDouble = true;
    private static String defaultEncoding;
    int sqlEmptyString = 0;

    public ConnectionInfo() {
        this.isUnicodeServer = true;
    }

    public ConnectionInfo(boolean supprotIEEDouble, boolean unicode, String locale) {
        this.isUnicodeServer = unicode;
        this.useIEEEDouble = supprotIEEDouble;
        this.setupLocale(locale);
    }

    public ConnectionInfo(int protocol, String locale, boolean unicode) {
        if (protocol > 0) {
            this.protocolVersion = protocol;
        }
        if (protocol < 41) {
            this.useIEEEDouble = false;
        }
        this.isUnicodeServer = unicode;
        this.setupLocale(locale);
    }

    private void setupLocale(String locale) {
        this.serverLocale = !this.isUnicodeServer ? (locale == null ? defaultEncoding : locale) : "ISO8859_1";
    }

    public boolean isIEEEDoubleSupported() {
        return this.useIEEEDouble;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            defaultEncoding = new InputStreamReader(System.in).getEncoding();
            if (defaultEncoding.equals("Cp1252")) {
                defaultEncoding = "ISO8859_1";
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            if (defaultEncoding == null) {
                defaultEncoding = "ISO8859_1";
            }
        }
    }
}

