/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheList;
import com.intersys.jdbc.ListItem;
import com.intersys.jdbc.SysList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CacheListBuilder {
    private static int CHUNKSIZE = 256;
    public static final int LARGE_INITIAL_SIZE = 100000;
    private int m_BucketSize = 1024;
    protected byte[] m_aData;
    protected int m_iLength = 0;
    protected int m_iOffset = 0;
    protected int m_lastReadOffset = 0;
    private String m_locale = null;
    boolean m_isUnicodeServer = true;
    boolean m_IEEEDouble = true;

    public CacheListBuilder(String locale) {
        this.m_aData = new byte[CHUNKSIZE];
        this.m_iLength = 0;
        this.m_locale = locale;
    }

    public CacheListBuilder(int nLen, String locale) {
        this.m_aData = new byte[nLen];
        this.m_iLength = 0;
        this.m_locale = locale;
    }

    public byte[] getBuffer() {
        return this.m_aData;
    }

    public void clearList() {
        this.m_iLength = 0;
        this.m_iOffset = 0;
        this.m_lastReadOffset = 0;
    }

    public int getLength() {
        return this.m_iLength;
    }

    void setLocale(String locale) {
        this.m_locale = locale;
    }

    String getLocale() {
        return this.m_locale;
    }

    public CacheListBuilder trim() {
        byte[] b = CacheBufferUtils.copyByteArray(this.m_aData, 0, this.m_iLength);
        this.m_aData = b;
        return this;
    }

    void checkBufferSize(int additional) {
        if (this.m_iOffset + additional > this.m_aData.length) {
            this.growBuffer(this.m_iOffset + additional);
        }
    }

    public void append(SysList list) throws SQLException {
        int len = list.getLength();
        this.checkBufferSize(len);
        System.arraycopy(list.getm_aData(), 0, this.m_aData, this.m_iLength, len);
        this.m_iLength += len;
        this.m_iOffset += len;
    }

    public void append(CacheListBuilder list) throws SQLException {
        int len = list.m_iLength;
        this.checkBufferSize(len);
        System.arraycopy(list.m_aData, 0, this.m_aData, this.m_iLength, len);
        this.m_iLength += len;
        this.m_iOffset += len;
    }

    public void append(byte[] byteArray) throws SQLException {
        int len = byteArray.length;
        this.checkBufferSize(len);
        System.arraycopy(byteArray, 0, this.m_aData, this.m_iLength, len);
        this.m_iOffset += len;
        this.m_iLength += len;
    }

    private void growBuffer(int needed) {
        needed = needed + (needed >> 4) + this.m_BucketSize - 1 & ~(this.m_BucketSize - 1);
        this.m_BucketSize *= 2;
        if (needed < 0) {
            throw new RuntimeException("Exceeded maximum amount of memory that can be allocated for a given row.");
        }
        byte[] a = new byte[needed];
        System.arraycopy(this.m_aData, 0, a, 0, this.m_iLength);
        this.m_aData = a;
    }

    public void setList(byte[] byteArray) {
        if (null == byteArray) {
            this.setNull();
            return;
        }
        this.m_aData = byteArray;
        this.m_iLength = byteArray.length;
        this.m_iOffset = 0;
    }

    public byte[] getData() {
        byte[] b = new byte[this.m_iLength];
        System.arraycopy(this.m_aData, 0, b, 0, this.m_iLength);
        return b;
    }

    void reset() {
        this.m_iOffset = 0;
    }

    int getInt() throws SQLException {
        ListItem it = new ListItem(this.m_aData);
        this.m_iOffset = CacheList.getListElement(this.m_iOffset, it);
        return CacheList.getInt(it);
    }

    String getString() throws SQLException {
        ListItem it = new ListItem(this.m_aData);
        this.m_iOffset = CacheList.getListElement(this.m_iOffset, it);
        return CacheList.getString(it, this.m_locale);
    }

    public void setNull() {
        this.checkBufferSize(2);
        this.m_aData[this.m_iOffset++] = 2;
        this.m_aData[this.m_iOffset++] = 1;
        this.m_iLength += 2;
    }

    public void set(int i) throws SQLException {
        this.checkBufferSize(6);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setInt(this.m_aData, this.m_iOffset, i);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Integer value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((int)value);
        }
    }

    public void set(Short value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value.intValue());
        }
    }

    public void set(short i) throws SQLException {
        this.checkBufferSize(6);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setInt(this.m_aData, this.m_iOffset, i);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public final void set(Byte value) throws SQLException {
        if (null == value) {
            this.setNull();
        } else {
            this.set((short)value.byteValue());
        }
    }

    public void set(String s) throws SQLException {
        if (s == null) {
            this.setNull();
            return;
        }
        int length = s.length() * 2;
        if (0 == length) {
            length = 1;
        }
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setString(this.m_aData, this.m_iOffset, s, this.m_locale, this.m_isUnicodeServer);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(long l) throws SQLException {
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setLong(this.m_aData, this.m_iOffset, l);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Long l) throws SQLException {
        if (null == l) {
            this.setNull();
        } else {
            this.set((long)l);
        }
    }

    public void set(double d) throws SQLException {
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDouble(this.m_aData, this.m_iOffset, d, this.m_IEEEDouble);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Double d) throws SQLException {
        if (d == null) {
            this.setNull();
            return;
        }
        this.set((double)d);
    }

    public void set(float f) throws SQLException {
        double d = f;
        this.set(d);
    }

    public void set(byte[] b) throws SQLException {
        if (null == b) {
            this.setNull();
            return;
        }
        int length = b.length;
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = 0 == length ? CacheList.stuffEmptyString(this.m_aData, this.m_iOffset) : CacheList.setByteArray(this.m_aData, this.m_iOffset, b, length);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(CacheListBuilder list) {
        if (null == list) {
            this.setNull();
            return;
        }
        this.checkBufferSize(list.m_iLength + 4);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setByteArray(this.m_aData, this.m_iOffset, list.m_aData, list.m_iLength);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(SysList list) {
        if (null == list) {
            this.setNull();
            return;
        }
        this.checkBufferSize(list.getLength() + 4);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setByteArray(this.m_aData, this.m_iOffset, list.getm_aData(), list.getLength());
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(boolean booleanValue) throws SQLException {
        int oldOffset = this.m_iOffset;
        this.checkBufferSize(4);
        this.m_iOffset = CacheList.setBoolean(this.m_aData, this.m_iOffset, booleanValue);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(BigInteger value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(60);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setBigInteger(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(BigDecimal value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(36);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setBigDecimal(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Time value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTime(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTime(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(30);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDate(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(java.util.Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.set(new Timestamp(value.getTime()).toString());
    }

    public void set(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(30);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDate(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Timestamp value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(32);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimestamp(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void set(Timestamp value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(32);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimestamp(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Time value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimePosix(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimePosix(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDatePosix(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(java.util.Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDatePosix(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(java.util.Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDatePosix(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDatePosix(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Timestamp value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimestampPosix(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setPosix(Timestamp value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimestampPosix(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(Time value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimeH(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(Time value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimeH(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    void setH(Time value, String fractions, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setTimeH(this.m_aData, this.m_iOffset, value, fractions, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDateH(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(java.util.Date value) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDateH(this.m_aData, this.m_iOffset, value);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(java.util.Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDateH(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setH(Date value, Calendar calendar) throws SQLException {
        if (null == value) {
            this.setNull();
            return;
        }
        this.checkBufferSize(10);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setDateH(this.m_aData, this.m_iOffset, value, calendar);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setUndefined() {
        this.checkBufferSize(32);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.setUndefined(this.m_aData, this.m_iOffset);
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof String) {
            this.set((String)value);
        } else if (value instanceof Integer) {
            this.set((Integer)value);
        } else if (value instanceof Double) {
            this.set((Double)value);
        } else if (value instanceof Float) {
            this.set((Float)value);
        } else if (value instanceof byte[]) {
            this.set((byte[])value);
        } else if (value instanceof char[]) {
            this.set(new String((char[])value));
        } else if (value instanceof CacheListBuilder) {
            this.set((CacheListBuilder)value);
        } else if (value instanceof BigDecimal) {
            this.set((BigDecimal)value);
        } else if (value instanceof Date) {
            this.set((Date)value);
        } else if (value instanceof Time) {
            this.set((Time)value);
        } else if (value instanceof Timestamp) {
            this.set((Timestamp)value);
        } else if (value instanceof Long) {
            this.set((Long)value);
        } else if (value instanceof BigInteger) {
            this.set((BigInteger)value);
        } else if (value instanceof Byte) {
            this.set((short)((Byte)value).byteValue());
        } else if (value instanceof Short) {
            this.set((Short)value);
        } else if (value instanceof Character) {
            this.set(value.toString());
        } else if (value instanceof Boolean) {
            this.set((boolean)((Boolean)value));
        } else {
            throw new SQLException("Type out of range: " + value.getClass().getName(), "S1003");
        }
    }

    private void wrapArray(int originalOffset) {
        int byteLen = this.m_iLength - originalOffset;
        if (byteLen <= 255) {
            this.m_aData[originalOffset] = (byte)byteLen;
            this.m_aData[originalOffset + 1] = 1;
        } else if (--byteLen < 65536) {
            this.checkBufferSize(1);
            System.arraycopy(this.m_aData, originalOffset + 2, this.m_aData, originalOffset + 4, byteLen);
            this.m_aData[originalOffset] = 0;
            this.m_aData[originalOffset + 1] = (byte)byteLen;
            this.m_aData[originalOffset + 2] = (byte)(byteLen >> 8);
            this.m_aData[originalOffset + 3] = 1;
            this.m_iLength += 2;
        } else {
            this.checkBufferSize(5);
            System.arraycopy(this.m_aData, originalOffset + 2, this.m_aData, originalOffset + 8, byteLen);
            this.m_aData[originalOffset] = 0;
            this.m_aData[originalOffset + 1] = 0;
            this.m_aData[originalOffset + 2] = 0;
            this.m_aData[originalOffset + 3] = (byte)byteLen;
            this.m_aData[originalOffset + 4] = (byte)(byteLen >> 8);
            this.m_aData[originalOffset + 5] = (byte)(byteLen >> 16);
            this.m_aData[originalOffset + 6] = (byte)(byteLen >> 24);
            this.m_aData[originalOffset + 7] = 1;
            this.m_iLength += 6;
        }
    }

    public void set(String[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(int[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Integer[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(long[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Long[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(double[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Double[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Float value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value.floatValue());
        }
    }

    public void set(short[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Short[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Float[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(float[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(boolean[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Date[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Time[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Timestamp[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(java.util.Date[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Boolean value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((boolean)value);
        }
    }

    public void set(Boolean[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(BigDecimal[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Byte[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    public void set(Character value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set((int)value.charValue());
        }
    }

    public void set(Character[] array) throws SQLException {
        if (null == array) {
            this.setNull();
            return;
        }
        int originalOffset = this.m_iOffset;
        this.m_iOffset += 2;
        this.m_iLength += 2;
        for (int i = 0; i < array.length; ++i) {
            this.set(array[i]);
        }
        this.wrapArray(originalOffset);
    }

    void stuffLatin1(String s) {
        int length = s.length();
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        int oldOffset = this.m_iOffset;
        if (length == 0) {
            char[] c = new char[]{'\u0000'};
            this.m_iOffset = CacheList.stuff7BitAscii(this.m_aData, this.m_iOffset, new String(c), 1);
        } else {
            this.m_iOffset = CacheList.stuff7BitAscii(this.m_aData, this.m_iOffset, s, length);
        }
        if (-1 == this.m_iOffset) {
            this.m_iOffset = CacheList.stuffMultibyte(this.m_aData, oldOffset, s, this.m_locale);
        }
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    void stuffUnicode(String s) {
        int length = s.length() * 2;
        this.checkBufferSize(length + this.getBytesForLength(length) + 1);
        int oldOffset = this.m_iOffset;
        this.m_iOffset = CacheList.stuffUNICODE(this.m_aData, this.m_iOffset, s, s.length());
        this.m_iLength += this.m_iOffset - oldOffset;
    }

    void stuffRawInt(byte[] buffer, int offset, int value, int len) {
        this.checkBufferSize(len);
        CacheList.stuffRawInt(buffer, offset, value, len);
    }

    int read4ByteInt(byte[] ba, int offset) {
        return CacheList.read4ByteInt(ba, offset);
    }

    int getBytesForLength(int len) {
        if (len < 255) {
            return 1;
        }
        if (len < 65536) {
            return 3;
        }
        return 7;
    }

    boolean isWide(String s) {
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public final boolean atEnd() {
        return this.m_lastReadOffset >= this.m_iOffset;
    }

    public byte[] getBytes() {
        ListItem it = new ListItem(this.m_aData);
        this.m_lastReadOffset = CacheList.getListElement(this.m_lastReadOffset, it);
        if (it.isNull) {
            return null;
        }
        if (it.dataLength == 1 && this.m_aData[it.dataOffset] == 0) {
            return new byte[0];
        }
        return CacheList.getByteArray(it);
    }

    public int count() throws SQLException {
        return CacheList.count(this.m_aData, this.m_iLength);
    }

    public void copyData(byte[] buffer, int offset) {
        System.arraycopy(this.m_aData, 0, buffer, offset, this.m_iLength);
    }

    public String toString() {
        return CacheList.toString(this.m_aData, this.m_iLength, this.m_locale);
    }
}

