/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheDataSource;
import com.intersys.jdbc.CacheDriver;
import com.intersys.jdbc.CachePooledConnection;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class CacheConnectionPoolDataSource
extends CacheDataSource
implements ConnectionPoolDataSource {
    private int maxPoolSize = 40;
    private int connectionWaitTimeout = 0;
    int activeConnections = 0;
    LinkedBlockingQueue<CachePooledConnection> pool = new LinkedBlockingQueue();

    @Override
    public synchronized PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.getUser(), this.getPassword());
    }

    @Override
    public synchronized PooledConnection getPooledConnection(String usr, String pwd) throws SQLException {
        this.getURL();
        return CacheDriver.CPManager.lookup(this, usr, pwd);
    }

    public synchronized void restartConnectionPool() throws SQLException {
        for (CachePooledConnection pc : this.pool) {
            pc.close();
        }
        this.pool.clear();
        this.activeConnections = 0;
    }

    public synchronized int getPoolCount() {
        return this.pool.size();
    }

    public synchronized void setMaxPoolSize(int max) {
        this.maxPoolSize = max;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getConnectionWaitTimeout() {
        return this.connectionWaitTimeout;
    }

    public void setConnectionWaitTimeout(int timeout) {
        this.connectionWaitTimeout = timeout;
    }
}

