/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheOutputStream;
import com.intersys.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class CacheBlob
extends RealStream
implements Blob {
    CacheBlob(CacheConnection conn, byte[] oref, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, null, oref, scn, streamType, sqlType, 0);
        this.getStreamSize();
    }

    CacheBlob(CacheConnection conn, String oid, int scn, int streamType, int sqlType) throws SQLException {
        super(conn, oid, null, scn, streamType, sqlType, 0);
        this.getSize();
    }

    CacheBlob(CacheConnection conn, byte[] h, int scn) throws SQLException {
        super(conn, null, h, scn, 1, -4, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized byte[] getBytes(long pos, int len) throws SQLException {
        return this.getByteStream(pos, len);
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheInputStream(this.connection, this.streamOID, this.cursorNumber, 1, this.sqlType, 0);
        }
        return new CacheInputStream(this);
    }

    @Override
    public synchronized long position(byte[] pattern, long start) throws SQLException {
        return this.getPosition(pattern, start);
    }

    @Override
    public synchronized long position(Blob pattern, long start) throws SQLException {
        return this.getPosition(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return new CacheOutputStream(this, pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        int count = this.sendBytes(pos, bytes, offset, len);
        this.getStreamSize();
        return count;
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.truncateStream(len);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new SQLException("Error freeing blob " + e.getMessage(), "S1000");
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new CacheInputStream(this.getBytes(pos, (int)length), 1, this.sqlType, 0);
    }
}

