/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.utils.CommonUtils;

public class EditIndexPage
extends AttributesSelectorPage {
    public static final String PROP_DESC = "desc";
    private final DBSTableIndex index;
    private String indexName;
    private List<DBSIndexType> indexTypes;
    private DBSIndexType selectedIndexType;
    private boolean unique;
    private boolean supportUniqueIndexes = true;
    private int descColumnIndex;

    public EditIndexPage(String title, DBSTableIndex index, Collection<DBSIndexType> indexTypes) {
        super(title, index.getTable());
        this.index = index;
        this.indexName = this.index.getName();
        this.indexTypes = new ArrayList<DBSIndexType>(indexTypes);
        Assert.isTrue((!CommonUtils.isEmpty(this.indexTypes) ? 1 : 0) != 0);
    }

    public EditIndexPage(String title, DBSTableIndex index, Collection<DBSIndexType> indexTypes, boolean supportUniqueIndexes) {
        super(title, index.getTable());
        this.index = index;
        this.indexTypes = new ArrayList<DBSIndexType>(indexTypes);
        Assert.isTrue((!CommonUtils.isEmpty(this.indexTypes) ? 1 : 0) != 0);
        this.supportUniqueIndexes = supportUniqueIndexes;
    }

    @Override
    protected void createContentsBeforeColumns(Composite panel) {
        UIUtils.createControlLabel((Composite)panel, (String)EditorsMessages.dialog_struct_edit_index_label_type);
        final Combo typeCombo = new Combo(panel, 12);
        typeCombo.setLayoutData((Object)new GridData(768));
        for (DBSIndexType indexType : this.indexTypes) {
            typeCombo.add(indexType.getName());
            if (this.selectedIndexType != null) continue;
            this.selectedIndexType = indexType;
        }
        typeCombo.select(0);
        typeCombo.setEnabled(this.indexTypes.size() > 1);
        typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditIndexPage.this.selectedIndexType = EditIndexPage.this.indexTypes.get(typeCombo.getSelectionIndex());
            }
        });
        if (this.supportUniqueIndexes) {
            final Button uniqueButton = UIUtils.createLabelCheckbox((Composite)panel, (String)EditorsMessages.dialog_struct_unique, (boolean)false);
            uniqueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditIndexPage.this.unique = uniqueButton.getSelection();
                }
            });
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public DBSIndexType getIndexType() {
        return this.selectedIndexType;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    protected void createAttributeColumns(Table columnsTable) {
        super.createAttributeColumns(columnsTable);
        TableColumn colDesc = UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)EditorsMessages.dialog_struct_create_column_order);
        colDesc.setToolTipText(EditorsMessages.dialog_struct_create_column_order_tooltip);
    }

    @Override
    protected int fillAttributeColumns(DBSEntityAttribute attribute, AttributesSelectorPage.AttributeInfo attributeInfo, TableItem columnItem) {
        this.descColumnIndex = super.fillAttributeColumns(attribute, attributeInfo, columnItem) + 1;
        boolean isDesc = Boolean.TRUE.equals(attributeInfo.getProperty(PROP_DESC));
        columnItem.setText(this.descColumnIndex, isDesc ? "DESC" : "ASC");
        return this.descColumnIndex;
    }

    @Override
    protected Control createCellEditor(Table table, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
        if (index == this.descColumnIndex) {
            boolean isDesc = Boolean.TRUE.equals(attributeInfo.getProperty(PROP_DESC));
            CCombo combo = new CCombo((Composite)table, 12);
            combo.add("ASC");
            combo.add("DESC");
            combo.select(isDesc ? 1 : 0);
            return combo;
        }
        return super.createCellEditor(table, index, item, attributeInfo);
    }

    @Override
    protected void saveCellValue(Control control, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
        if (index == this.descColumnIndex) {
            CCombo combo = (CCombo)control;
            boolean isDesc = combo.getSelectionIndex() == 1;
            item.setText(index, isDesc ? "DESC" : "ASC");
            attributeInfo.setProperty(PROP_DESC, isDesc);
        } else {
            super.saveCellValue(control, index, item, attributeInfo);
        }
    }

    @Override
    public DBSObject getObject() {
        return this.index;
    }
}

