/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import com.dbeaver.db.cassandra.model.CasAbstractDataType;
import com.dbeaver.db.cassandra.model.CasKeyspace;
import com.dbeaver.db.cassandra.model.CasTypedObject;
import com.dbeaver.db.cassandra.model.CasUserTypeAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;

public class CasUserType
extends CasAbstractDataType
implements CasTypedObject,
DBSEntity,
DBPScriptObject {
    private static final Log log = Log.getLog(CasUserType.class);
    private final CasKeyspace keyspace;
    private final UserType metadata;
    private final List<CasUserTypeAttribute> attributes = new ArrayList<CasUserTypeAttribute>();

    public CasUserType(CasKeyspace keyspace, UserType metadata) {
        super(keyspace.getDataSource());
        this.keyspace = keyspace;
        this.metadata = metadata;
        int index = 1;
        for (UserType.Field field : metadata) {
            CasUserTypeAttribute attr = new CasUserTypeAttribute(this, index++, field.getName(), field.getType());
            this.attributes.add(attr);
        }
    }

    @Nullable
    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @Property(viewable=true)
    @NotNull
    public String getTypeName() {
        return this.metadata.getTypeName();
    }

    public int getTypeID() {
        return this.metadata.hashCode();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Nullable
    public List<CasUserTypeAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.attributes;
    }

    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject(this.attributes, (String)attributeName);
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    @NotNull
    public DataType getCasDataType() {
        return this.metadata;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.metadata.exportAsString();
    }
}

