/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TupleType;
import com.dbeaver.db.cassandra.model.CasAbstractDataType;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasTupleTypeAttribute;
import com.dbeaver.db.cassandra.model.CasTypedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;

public class CasTupleType
extends CasAbstractDataType
implements CasTypedObject,
DBSEntity {
    private final TupleType metadata;
    private final List<CasTupleTypeAttribute> attributes = new ArrayList<CasTupleTypeAttribute>();

    public CasTupleType(CasDataSource dataSource, TupleType metadata) {
        super(dataSource);
        this.metadata = metadata;
        int index = 1;
        for (DataType compType : metadata.getComponentTypes()) {
            CasTupleTypeAttribute attr = new CasTupleTypeAttribute(this, index++, String.valueOf(index), compType);
            this.attributes.add(attr);
        }
    }

    public TupleType getMetadata() {
        return this.metadata;
    }

    @Property(viewable=true)
    @NotNull
    public String getTypeName() {
        return this.metadata.getName().toString();
    }

    public int getTypeID() {
        return this.metadata.hashCode();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Nullable
    public List<CasTupleTypeAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.attributes;
    }

    @Nullable
    public CasTupleTypeAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (CasTupleTypeAttribute)DBUtils.findObject(this.attributes, (String)attributeName);
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Override
    @NotNull
    public DataType getCasDataType() {
        return this.metadata;
    }
}

