/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.dbeaver.db.cassandra.CasUtils;
import com.dbeaver.db.cassandra.exec.CasBaseStatement;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasKeyspace;
import com.dbeaver.db.cassandra.model.CasTable;
import com.dbeaver.db.cassandra.model.CasTypedObject;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class CasResultSetMetaData
implements DBCResultSetMetaData {
    private static final Log log = Log.getLog(CasResultSetMetaData.class);
    private final CasBaseStatement sourceStatement;
    private final List<DBCAttributeMetaData> columns;

    public CasResultSetMetaData(CasBaseStatement sourceStatement, ResultSet resultSet) {
        this.sourceStatement = sourceStatement;
        List definitions = resultSet.getColumnDefinitions().asList();
        this.columns = new ArrayList<DBCAttributeMetaData>(definitions.size());
        int i = 0;
        while (i < definitions.size()) {
            ColumnDefinitions.Definition definition = (ColumnDefinitions.Definition)definitions.get(i);
            this.columns.add(new ColumnMetaData(definition, i));
            ++i;
        }
    }

    public List<? extends DBCAttributeMetaData> getAttributes() {
        return this.columns;
    }

    CasTable getOwnTable(ColumnDefinitions.Definition definition) {
        CasDataSource dataSource = this.sourceStatement.getSession().getDataSource();
        CasKeyspace keyspace = dataSource.getKeyspace(definition.getKeyspace());
        if (keyspace != null) {
            try {
                return keyspace.getChild((DBRProgressMonitor)new VoidProgressMonitor(), definition.getTable());
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public class ColumnMetaData
    implements DBCAttributeMetaData,
    CasTypedObject {
        private final ColumnDefinitions.Definition definition;
        private final int position;

        private ColumnMetaData(ColumnDefinitions.Definition definition, int position) {
            this.definition = definition;
            this.position = position;
        }

        public Object getSource() {
            return CasResultSetMetaData.this.sourceStatement.getStatementSource();
        }

        @NotNull
        public String getLabel() {
            return this.definition.getName();
        }

        public String getEntityName() {
            return null;
        }

        @Property
        public boolean isReadOnly() {
            return false;
        }

        public DBCEntityMetaData getEntityMetaData() {
            return null;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return this.definition.getName();
        }

        @Property(viewable=true, order=2)
        public int getOrdinalPosition() {
            return this.position;
        }

        @Override
        @Property(viewable=true, order=3)
        @NotNull
        public DataType getCasDataType() {
            return this.definition.getType();
        }

        @Property(viewable=true, order=5)
        public boolean isRequired() {
            DBPDataKind dataKind = this.getDataKind();
            return dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.BOOLEAN;
        }

        @NotNull
        public String getTypeName() {
            return this.definition.getType().getName().toString();
        }

        @NotNull
        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return CasUtils.getTypeNameID(this.definition.getType());
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return CasUtils.getDataKind(this.definition.getType());
        }

        @Nullable
        public Integer getScale() {
            return 0;
        }

        @Nullable
        public Integer getPrecision() {
            return 0;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public String toString() {
            return this.getName() + " " + this.getFullTypeName();
        }
    }
}

