/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSPreferences;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;

public class AuthModelAWSCredentials
extends AuthModelDatabaseNativeCredentials
implements SMSessionAuthCredentials {
    private static final Log log = Log.getLog(AuthModelAWSCredentials.class);
    private static final String ROLE_SESSION_NAME = "dbeaver";
    public static final String AWS_AUTH_CONTEXT_TYPE = "aws";
    public static final String ROLE_ARN_PREFIX = "arn:aws:iam::";
    private String region;
    private String profileName;
    private String pluginName;
    private boolean defaultAwsCredentials;
    private boolean sessionCredentials;
    @SecureProperty
    private String awsAccessKey;
    @SecureProperty
    private String awsSecretKey;
    private String awsSessionToken;
    private transient AwsCredentialsProvider awsCredentialsProvider;
    private String secretName;
    private boolean ssoOverCli;
    private boolean crossAccountAccess;
    private String awsAssumeAccountId;
    private String awsAssumeRoleName;
    private String awsExternalId;
    private transient Map<String, ?> attributes = Collections.emptyMap();

    public AuthModelAWSCredentials() {
    }

    public AuthModelAWSCredentials(AuthModelAWSCredentials source) {
        this.region = source.region;
        this.profileName = source.profileName;
        this.pluginName = source.pluginName;
        this.sessionCredentials = source.sessionCredentials;
        this.defaultAwsCredentials = source.defaultAwsCredentials;
        this.awsAccessKey = source.awsAccessKey;
        this.awsSecretKey = source.awsSecretKey;
        this.awsSessionToken = source.awsSessionToken;
        this.ssoOverCli = source.ssoOverCli;
        this.crossAccountAccess = source.crossAccountAccess;
        this.awsAssumeAccountId = source.awsAssumeAccountId;
        this.awsAssumeRoleName = source.awsAssumeRoleName;
        this.awsExternalId = source.awsExternalId;
        this.secretName = source.secretName;
        this.attributes = new LinkedHashMap(source.attributes);
        this.awsCredentialsProvider = source.awsCredentialsProvider;
    }

    @Property(hidden=true)
    public String getUserPassword() {
        return super.getUserPassword();
    }

    @Property(hidden=true)
    @AuthProperty(authContextType="aws")
    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Property(hidden=true)
    @AuthProperty(authContextType="aws")
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Property(order=2, nonSecuredProperty=true, required=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Property(nonSecuredProperty=true)
    @AuthProperty(authContextType="aws")
    public boolean isDefaultAwsCredentials() {
        return this.defaultAwsCredentials;
    }

    public void setDefaultAwsCredentials(boolean defaultAwsCredentials) {
        this.defaultAwsCredentials = defaultAwsCredentials;
    }

    @Property(nonSecuredProperty=true)
    public boolean isSessionCredentials() {
        return this.sessionCredentials;
    }

    public void setSessionCredentials(boolean sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
    }

    @Property(order=3)
    @AuthProperty(authContextType="aws")
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    @Property(order=4, password=true, keyName="iam.aws_secret_key")
    @AuthProperty(authContextType="aws")
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    @Property(hidden=true, password=true, keyName="iam.aws_session_token")
    @AuthProperty(authContextType="aws")
    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public void setAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
    }

    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public void setAwsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    public boolean isSsoOverCli() {
        return this.ssoOverCli;
    }

    public void setSsoOverCli(boolean ssoOverCli) {
        this.ssoOverCli = ssoOverCli;
    }

    @Property(order=0x7FFFFFFE, nonSecuredProperty=true)
    public boolean isCrossAccountAccess() {
        return this.crossAccountAccess;
    }

    public void setCrossAccountAccess(boolean crossAccountAccess) {
        this.crossAccountAccess = crossAccountAccess;
    }

    @Property(order=5, nonSecuredProperty=true)
    public String getAwsAssumeAccountId() {
        return this.awsAssumeAccountId;
    }

    void setAwsAssumeAccountId(String awsAssumeAccountId) {
        this.awsAssumeAccountId = awsAssumeAccountId;
    }

    @Property(order=6, nonSecuredProperty=true)
    public String getAwsAssumeRoleName() {
        return this.awsAssumeRoleName;
    }

    @Property(order=7, nonSecuredProperty=true)
    public String getAwsExternalId() {
        return this.awsExternalId;
    }

    public void setAwsExternalId(String awsExternalId) {
        this.awsExternalId = awsExternalId;
    }

    void setAwsAssumeRoleName(String awsAssumeRoleName) {
        this.awsAssumeRoleName = awsAssumeRoleName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getAuthCredentialsProvider(monitor, null);
    }

    @Property(order=8, nonSecuredProperty=true)
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBException {
        AwsCredentialsProvider credentialsProvider = this.resolveCredentialsProvider(monitor, configuration);
        if (this.ssoOverCli) {
            try {
                credentialsProvider.resolveCredentials();
            }
            catch (Throwable throwable) {
                this.initializeSSO(monitor);
            }
        }
        credentialsProvider = this.assumeAccountRole(monitor, credentialsProvider, null);
        return credentialsProvider;
    }

    public AwsCredentialsProvider assumeAccountRole(@NotNull DBRProgressMonitor monitor, @NotNull AwsCredentialsProvider credentialsProvider, @Nullable String jwtToken) throws DBException {
        if (this.crossAccountAccess) {
            if (CommonUtils.isEmpty((String)this.awsAssumeAccountId)) {
                throw new DBCException("AWS account ID must be specified for 3rd party account access");
            }
            if (CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
                throw new DBCException("AWS IAM role name must be specified when 3rd party IAM account is specified");
            }
        }
        if (!CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
            monitor.subTask("Assume AWS role");
            Throwable throwable = null;
            Object var5_6 = null;
            try (StsClient stsClient = AWSIAMUtils.createStsClient(credentialsProvider);){
                Object roleArn;
                if (this.awsAssumeRoleName.startsWith(ROLE_ARN_PREFIX)) {
                    roleArn = this.awsAssumeRoleName;
                } else {
                    String accId;
                    String string = accId = this.crossAccountAccess ? this.awsAssumeAccountId : null;
                    if (accId == null) {
                        accId = stsClient.getCallerIdentity().account();
                    }
                    roleArn = ROLE_ARN_PREFIX + accId + ":role/" + this.awsAssumeRoleName;
                }
                if (jwtToken != null) {
                    AssumeRoleWithWebIdentityRequest arRequest = (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().roleArn((String)roleArn).webIdentityToken(jwtToken).roleSessionName(ROLE_SESSION_NAME).build();
                    credentialsProvider = ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
                } else {
                    AssumeRoleRequest.Builder arRequestBuilder = AssumeRoleRequest.builder().roleArn((String)roleArn).roleSessionName(ROLE_SESSION_NAME);
                    if (!CommonUtils.isEmpty((String)this.awsExternalId)) {
                        arRequestBuilder.externalId(this.awsExternalId);
                    }
                    AssumeRoleRequest arRequest = (AssumeRoleRequest)arRequestBuilder.build();
                    credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return credentialsProvider;
    }

    private AwsCredentialsProvider resolveCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBException {
        DefaultCredentialsProvider credentialsProvider;
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            monitor.subTask("Read AWS profiles");
            if (CommonUtils.isEmpty((String)this.profileName)) {
                throw new DBCException("AWS profile name must be specified");
            }
            credentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profileName).build();
        } else if (this.defaultAwsCredentials) {
            credentialsProvider = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).build();
        } else {
            if (this.sessionCredentials && CommonUtils.isEmpty((String)this.awsAccessKey) && !SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)AWS_AUTH_CONTEXT_TYPE, (String)"AWS", (SMSessionAuthCredentials)this)) {
                throw new DBCException("AWS session credentials are missing");
            }
            String accessKey = this.awsAccessKey;
            String secretKey = this.awsSecretKey;
            String sessionToken = this.awsSessionToken;
            if (configuration != null) {
                if (CommonUtils.isEmpty((String)accessKey)) {
                    accessKey = configuration.getUserName();
                }
                if (CommonUtils.isEmpty((String)secretKey)) {
                    secretKey = configuration.getUserPassword();
                }
            }
            if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                DBPAuthInfo authInfo;
                monitor.subTask("Acquire secret credentials in interactive mode");
                try {
                    authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Please enter access key and secret key", "Access Key", accessKey, "Secret Key", secretKey, false, false);
                }
                catch (Exception e) {
                    authInfo = null;
                    log.error((Object)e);
                }
                if (authInfo != null) {
                    accessKey = authInfo.getUserName();
                    secretKey = authInfo.getUserPassword();
                }
                if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                    throw new DBCException("AWS access key and secret key must be specified");
                }
            }
            Object awsCredentials = CommonUtils.isEmpty((String)sessionToken) ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        this.awsCredentialsProvider = credentialsProvider;
        return credentialsProvider;
    }

    private void initializeSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize SSO over AWS CLI");
        String cliParams = AuthModelAWSCredentials.getAwsCliExecutablePath() + " sso login";
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            cliParams = cliParams + " --profile " + this.profileName;
        }
        log.debug((Object)("Perform AWS SSO init [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams);
        monitor.subTask("SSO init finished");
    }

    private void logoutSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize SSO over AWS CLI");
        String cliParams = AuthModelAWSCredentials.getAwsCliExecutablePath() + " sso logout";
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            cliParams = cliParams + " --profile " + this.profileName;
        }
        log.debug((Object)("Perform AWS SSO logout [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams);
        monitor.subTask("SSO logout finished");
    }

    public void executeCLI(@NotNull DBRProgressMonitor monitor, String cliParams) throws DBCException {
        DBRShellCommand cliCommand = new DBRShellCommand(cliParams);
        cliCommand.setEnabled(true);
        DBRProcessDescriptor cliProcess = new DBRProcessDescriptor(cliCommand);
        AuthModelAWSCredentials.executeCLI(monitor, cliProcess);
    }

    public static void executeCLI(@NotNull DBRProgressMonitor monitor, final DBRProcessDescriptor cliProcess) throws DBCException {
        try {
            cliProcess.execute();
        }
        catch (DBException e) {
            throw new DBCException("Error running AWS CLI. Is it installed on the local machine?", (Throwable)e);
        }
        final String[] cliErrorLog = new String[2];
        AbstractJob dumpJob = null;
        if (cliProcess.isRunning()) {
            dumpJob = new AbstractJob(cliProcess.getName() + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        cliErrorLog[0] = cliProcess.dumpErrors();
                        cliErrorLog[1] = cliProcess.dumpOutput();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            dumpJob.schedule();
        }
        while (cliProcess.isRunning()) {
            if (monitor.isCanceled()) {
                cliProcess.terminate();
                throw new DBCException("AWS SSO initialization has been canceled");
            }
            RuntimeUtils.pause((int)50);
        }
        if (dumpJob != null) {
            try {
                dumpJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        int resCode = cliProcess.getExitValue();
        String infoMessage = cliErrorLog[1];
        if (!CommonUtils.isEmptyTrimmed((String)infoMessage)) {
            log.debug((Object)("AWS SSO login info message:\n" + infoMessage));
        }
        if (resCode != 0) {
            Object errorMessage = cliErrorLog[0];
            if (!CommonUtils.isEmptyTrimmed((String)errorMessage)) {
                errorMessage = "AWS SSO login failed: " + ((String)errorMessage).trim();
                throw new DBCException((String)errorMessage);
            }
            log.debug((Object)("AWS SSO login ended with result  code " + resCode));
        }
    }

    public boolean refreshSession(DBRProgressMonitor monitor, DBPDataSourceContainer dataSource) throws DBException {
        if (this.sessionCredentials) {
            SMAuthUtils.updateSessionCredentialsFromSession((DBRProgressMonitor)monitor, (String)AWS_AUTH_CONTEXT_TYPE, (String)"AWS", (SMSessionAuthCredentials)this);
            return true;
        }
        boolean isSSO = this.ssoOverCli;
        if (!isSSO && this.awsCredentialsProvider instanceof ProfileCredentialsProvider) {
            try {
                this.awsCredentialsProvider.resolveCredentials();
            }
            catch (Exception e) {
                if (AWSIAMUtils.isTokenExpiredError(e)) {
                    isSSO = true;
                }
                throw e;
            }
        }
        if (!isSSO) {
            return false;
        }
        this.awsCredentialsProvider = null;
        this.initializeSSO(monitor);
        return true;
    }

    public boolean closeSession(DBRProgressMonitor monitor) throws DBCException {
        if (!this.ssoOverCli) {
            return false;
        }
        this.logoutSSO(monitor);
        return true;
    }

    @NotNull
    public static String getAwsCliExecutablePath() {
        String executable = AuthModelAWSPreferences.getPreferences().getString("aws.cli.executable");
        return CommonUtils.isEmpty((String)executable) ? AWS_AUTH_CONTEXT_TYPE : executable;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, ?> attributes) {
        this.attributes = attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    void resetSettings() {
        this.sessionCredentials = false;
        this.defaultAwsCredentials = false;
        this.profileName = null;
        this.awsAccessKey = null;
        this.awsSecretKey = null;
        this.awsSessionToken = null;
        this.secretName = null;
        this.pluginName = null;
        this.awsAssumeAccountId = null;
        this.awsAssumeRoleName = null;
    }
}

