/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRInvoker;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.internal.SigningAlgorithm;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.sso.auth.ExpiredTokenException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.utils.BinaryUtils;

public class AWSIAMUtils {
    private static final Log log = Log.getLog(AWSIAMUtils.class);
    private static final Type SECRET_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final String algorithm = "AWS4-HMAC-SHA256";
    private static final String serviceName = "rds-db";
    private static final DateTimeFormatter sdf0 = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC"));
    private static final DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withZone(ZoneId.of("UTC"));
    private static final String expiryMinutes = "899";

    public static void initSecretAuthentication(@NotNull AuthModelAWSCredentials credentials, @NotNull String region, @NotNull String secretName, @NotNull AwsCredentialsProvider credentialsProvider, @NotNull DBPDataSource dataSource, DBPConnectionConfiguration configuration) throws DBException {
        String secretJSON;
        Throwable throwable = null;
        Object var8_8 = null;
        try (SecretsManagerClient client = (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).credentialsProvider(credentialsProvider)).build();){
            GetSecretValueRequest getSecretValueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
            GetSecretValueResponse getSecretValueResponse = client.getSecretValue(getSecretValueRequest);
            secretJSON = getSecretValueResponse.secretString() != null ? getSecretValueResponse.secretString() : new String(Base64.decode((String)getSecretValueResponse.secretBinary().asUtf8String()));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Gson gson = new Gson();
        try {
            String database;
            String port;
            Map map = (Map)gson.fromJson(secretJSON, SECRET_TYPE);
            String password = (String)map.get("password");
            if (password == null) {
                throw new DBException("Secret doesn't contain a password, please verify that your secret has the required field");
            }
            credentials.setUserPassword(password);
            String username = (String)map.get("username");
            if (username != null) {
                if (!username.equals(credentials.getUserName())) {
                    log.warn((Object)("Expected username is different from actual: actual = " + username + ", expected = " + credentials.getUserName()));
                }
                credentials.setUserName(username);
            }
            boolean connectionUrlChanged = false;
            String host = (String)map.get("host");
            if (host != null && !host.equals(configuration.getHostName())) {
                log.warn((Object)("Expected host is different from actual: actual = " + host + ", expected = " + configuration.getHostName()));
                configuration.setHostName(host);
                connectionUrlChanged = true;
            }
            if ((port = (String)map.get("port")) != null && !port.equals(configuration.getHostPort())) {
                log.warn((Object)("Expected port is different from actual: actual = " + host + ", expected = " + configuration.getHostName()));
                configuration.setHostPort(port);
                connectionUrlChanged = true;
            }
            if ((database = (String)map.get("dbname")) != null && !database.equals(configuration.getHostPort())) {
                log.warn((Object)("Expected database is different from actual: actual = " + database + ", expected = " + configuration.getDatabaseName()));
                configuration.setDatabaseName(database);
                connectionUrlChanged = true;
            }
            if (connectionUrlChanged) {
                configuration.setUrl(dataSource.getContainer().getDriver().getConnectionURL(configuration));
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            if (!secretJSON.contains("\n")) {
                credentials.setUserPassword(secretJSON);
            }
            throw new DBException("The secret value must be in JSON or plaintext format.");
        }
    }

    public static String generateIamPassword(String region, String hostName, int port, String username, String awsAccessKey, String awsSecretKey) throws DBCException {
        Instant now = Instant.now();
        String dateTimeStamp = sdf.format(now);
        String date = sdf0.format(now);
        String portStr = Integer.toString(port);
        List<String> initial = AWSIAMUtils.prepareStrings(username, awsAccessKey, date, dateTimeStamp, region, expiryMinutes, hostName, portStr);
        String requestWithoutSignature = initial.get(0);
        String canonicalString = initial.get(1);
        String stringToSign = AWSIAMUtils.createStringToSign(dateTimeStamp, canonicalString, awsAccessKey, date, region);
        String signature = BinaryUtils.toHex((byte[])AWSIAMUtils.calculateSignature(stringToSign, AWSIAMUtils.newSigningKey(awsSecretKey, date, region, serviceName)));
        String password = AWSIAMUtils.appendSignature(requestWithoutSignature, signature);
        return password;
    }

    private static List<String> prepareStrings(String user, String accessKey, String date, String dateTime, String region, String expiryPeriod, String hostName, String port) throws DBCException {
        TreeMap<String, Object> canonicalQueryParameters = new TreeMap<String, Object>();
        canonicalQueryParameters.put("Action", "connect");
        canonicalQueryParameters.put("DBUser", user);
        canonicalQueryParameters.put("X-Amz-Algorithm", algorithm);
        canonicalQueryParameters.put("X-Amz-Credential", accessKey + "%2F" + date + "%2F" + region + "%2Frds-db%2Faws4_request");
        canonicalQueryParameters.put("X-Amz-Date", dateTime);
        canonicalQueryParameters.put("X-Amz-Expires", expiryPeriod);
        canonicalQueryParameters.put("X-Amz-SignedHeaders", "host");
        Object canonicalQueryString = "";
        while (!canonicalQueryParameters.isEmpty()) {
            String currentQueryParameter = (String)canonicalQueryParameters.firstKey();
            String currentQueryParameterValue = (String)canonicalQueryParameters.remove(currentQueryParameter);
            canonicalQueryString = (String)canonicalQueryString + currentQueryParameter + "=" + currentQueryParameterValue;
            if (currentQueryParameter.equals("X-Amz-SignedHeaders")) continue;
            canonicalQueryString = (String)canonicalQueryString + "&";
        }
        String canonicalHeaders = "host:" + hostName + ":" + port + "\n";
        String requestWithoutSignature = hostName + ":" + port + "/?" + (String)canonicalQueryString;
        String hashedPayload = BinaryUtils.toHex((byte[])AWSIAMUtils.hash(""));
        String first = requestWithoutSignature;
        String second = "GET\n/\n" + (String)canonicalQueryString + "\n" + canonicalHeaders + "\nhost\n" + hashedPayload;
        return Arrays.asList(first, second);
    }

    private static byte[] hash(String s) throws DBCException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(s.getBytes("UTF8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new DBCException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String createStringToSign(String dateTime, String canonicalRequest, String accessKey, String date, String region) throws DBCException {
        String credentialScope = date + "/" + region + "/rds-db/aws4_request";
        return "AWS4-HMAC-SHA256\n" + dateTime + "\n" + credentialScope + "\n" + BinaryUtils.toHex((byte[])AWSIAMUtils.hash(canonicalRequest));
    }

    private static byte[] calculateSignature(String stringToSign, byte[] signingKey) throws DBCException {
        return AWSIAMUtils.sign(stringToSign.getBytes(Charset.forName("UTF-8")), signingKey, SigningAlgorithm.HmacSHA256);
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws DBCException {
        try {
            Mac mac = algorithm.getMac();
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new DBCException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws DBCException {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            return AWSIAMUtils.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new DBCException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] newSigningKey(String secretKey, String dateStamp, String regionName, String serviceName) throws DBCException {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = AWSIAMUtils.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = AWSIAMUtils.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = AWSIAMUtils.sign(serviceName, kRegion, SigningAlgorithm.HmacSHA256);
        return AWSIAMUtils.sign("aws4_request", kService, SigningAlgorithm.HmacSHA256);
    }

    private static String appendSignature(String requestWithoutSignature, String signature) {
        return requestWithoutSignature + "&X-Amz-Signature=" + signature;
    }

    public static void updateCredentialsFromSessionData(@NotNull Map<String, Object> objectMap, @NotNull AuthModelAWSCredentials iamCredentials) {
        Map credentialsMap = JSONUtils.getObjectOrNull(objectMap, (String)"aws-credentials");
        if (!CommonUtils.isEmpty((Map)credentialsMap)) {
            log.debug((Object)"Use AWS credentials from current session");
            boolean originalSessionCredentials = iamCredentials.isSessionCredentials();
            iamCredentials.resetSettings();
            InstanceCreator iamCredCreator = type -> iamCredentials;
            Gson gson = new GsonBuilder().registerTypeAdapter(AuthModelAWSCredentials.class, (Object)iamCredCreator).create();
            gson.fromJson(gson.toJsonTree((Object)credentialsMap), AuthModelAWSCredentials.class);
            iamCredentials.setSessionCredentials(originalSessionCredentials);
        }
    }

    public static StsClient createStsClient(AwsCredentialsProvider credentialsProvider) {
        return (StsClient)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).httpClient(ApacheHttpClient.builder().maxConnections(Integer.valueOf(500)).build())).overrideConfiguration((ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryMode.ADAPTIVE).build())).credentialsProvider(credentialsProvider)).build();
    }

    public static <T> T tryExecuteRecover(DBRProgressMonitor monitor, AuthModelAWSCredentials credentials, DBRInvoker<T> runnable) throws DBException {
        try {
            return (T)runnable.invoke();
        }
        catch (Exception e) {
            if (AWSIAMUtils.isTokenExpiredError(e)) {
                credentials.refreshSession(monitor, null);
                return (T)runnable.invoke();
            }
            throw e;
        }
    }

    public static boolean isTokenExpiredError(Exception e) {
        String message = CommonUtils.notEmpty((String)e.getMessage()).toLowerCase();
        return e instanceof ExpiredTokenException || message.contains("token is expired") || message.contains("token has expired") || message.contains("token included in the request is expired");
    }
}

