/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.sqlite.SQLiteUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableColumnManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class SQLiteTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    protected SQLiteDefaultModifier sqliteDefaultModifier = new SQLiteDefaultModifier();

    public boolean canCreateObject(Object container) {
        return true;
    }

    protected SQLTableColumnManager.ColumnModifier[] getSupportedModifiers(GenericTableColumn column, Map<String, Object> options) {
        return new SQLTableColumnManager.ColumnModifier[]{this.DataTypeModifier, this.sqliteDefaultModifier, this.NotNullModifier};
    }

    public boolean canDeleteObject(GenericTableColumn object) {
        return true;
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        SQLiteUtils.createTableAlterActions(monitor, "Drop column " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())), (GenericTableBase)((GenericTableColumn)command.getObject()).getTable(), actions);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + ((GenericTableBase)column.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericTableColumn object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    private class SQLiteDefaultModifier
    extends SQLTableColumnManager.BaseDefaultModifier {
        private SQLiteDefaultModifier() {
            super((SQLTableColumnManager)SQLiteTableColumnManager.this);
        }

        protected void appendDefaultValue(@NotNull StringBuilder sql, @NotNull String defaultValue, boolean useQuotes) {
            sql.append("(");
            super.appendDefaultValue(sql, defaultValue, useQuotes);
            sql.append(")");
        }
    }
}

