/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleMember;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class RedshiftPermissionOwner
extends PostgreRole {
    private static final Log log = Log.getLog(RedshiftPermissionOwner.class);

    public RedshiftPermissionOwner(PostgreDatabase database, String name, String password, boolean isUser) {
        super(database, name, password, isUser);
    }

    public RedshiftPermissionOwner(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database, dbResult);
    }

    public boolean isInherit() {
        return super.isInherit();
    }

    public boolean isCreateRole() {
        return super.isCreateRole();
    }

    public boolean isCanLogin() {
        return super.isCanLogin();
    }

    public boolean isReplication() {
        return super.isReplication();
    }

    public boolean isBypassRls() {
        return super.isBypassRls();
    }

    public boolean isUser() {
        return false;
    }

    public boolean isSuperUser() {
        return false;
    }

    public boolean isCreateDatabase() {
        return false;
    }

    public int getConnLimit() {
        return 0;
    }

    public String getValidUntil() {
        return null;
    }

    public Collection<PostgreRoleMember> getMembers(DBRProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public Collection<PostgreRoleMember> getBelongs(DBRProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public List<PostgrePrivilege> getPrivileges(DBRProgressMonitor monitor, boolean includeNestedObjects) {
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read privileges");){
                JDBCPreparedStatement dbStat;
                Throwable throwable2 = null;
                Object var8_14 = null;
                try {
                    dbStat = session.prepareStatement("SELECT * FROM information_schema.table_privileges WHERE table_catalog=? AND grantee=?");
                    try {
                        dbStat.setString(1, this.getDatabase().getName());
                        dbStat.setString(2, this.getName());
                        permissions.addAll(RedshiftPermissionOwner.getRolePermissions((DBRProgressMonitor)monitor, (PostgreRole)this, (PostgrePrivilegeGrant.Kind)PostgrePrivilegeGrant.Kind.TABLE, (JDBCPreparedStatement)dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var8_14 = null;
                try {
                    dbStat = session.prepareStatement("SELECT * FROM information_schema.routine_privileges WHERE specific_catalog=? AND grantee=?");
                    try {
                        dbStat.setString(1, this.getDatabase().getName());
                        dbStat.setString(2, this.getName());
                        permissions.addAll(RedshiftPermissionOwner.getRolePermissions((DBRProgressMonitor)monitor, (PostgreRole)this, (PostgrePrivilegeGrant.Kind)PostgrePrivilegeGrant.Kind.FUNCTION, (JDBCPreparedStatement)dbStat));
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                throwable2 = null;
                var8_14 = null;
                try {
                    dbStat = session.prepareStatement("with tr as (\n\tselect distinct\n\t\trelnamespace,\n\t\trelname,\n\t\trelkind,\n\t\tarray_to_string(relacl, ',') as relacl\n\tfrom\n\t\tpg_class\n\twhere\n\t\trelacl is not null and\n\t\trelnamespace in (select oid from pg_namespace where nspname not like 'pg_%' and nspname != 'information_schema')\n\tunion all\n\tselect distinct\n\t\tn.oid as relnamespace,\n\t\tn.nspname as relname,\n\t\t'C' as relkind,\n\t\tarray_to_string(nspacl, ',') as relacl\n\tfrom\n\t\tpg_catalog.pg_namespace n\n\twhere\n\t\tn.nspacl is not null\n)\nselect * from tr\nwhere tr.relkind in ('S', 'm', 'C')");
                    try {
                        Throwable throwable5 = null;
                        Object var11_21 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.nextRow()) {
                                List privileges;
                                PostgreSchema schema;
                                long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"relnamespace");
                                String objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                                String objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind");
                                String[] acl = CommonUtils.split((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relacl"), (String)",");
                                if (!ArrayUtils.contains((Object[])PostgreUtils.extractGranteesFromACL((String[])acl), (Object)this.getName()) || (schema = this.getDatabase().getSchema(monitor, schemaId)) == null || objectName == null || objectType == null) continue;
                                PostgrePrivilegeGrant.Kind pKind = PostgrePrivilegeGrant.Kind.TABLE;
                                if (objectType.equals("C")) {
                                    privileges = PostgreUtils.extractPermissionsFromACL((PostgrePrivilegeOwner)schema, (String[])acl, (boolean)false);
                                    pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                                } else if (objectType.equals("S")) {
                                    PostgreSequence sequence = schema.getSequence(monitor, objectName);
                                    privileges = PostgreUtils.extractPermissionsFromACL((PostgrePrivilegeOwner)sequence, (String[])acl, (boolean)false);
                                    pKind = PostgrePrivilegeGrant.Kind.SEQUENCE;
                                } else {
                                    PostgreMaterializedView materializedView = schema.getMaterializedView(monitor, objectName);
                                    privileges = PostgreUtils.extractPermissionsFromACL((PostgrePrivilegeOwner)materializedView, (String[])acl, (boolean)false);
                                }
                                for (PostgrePrivilege p : privileges) {
                                    if (!(p instanceof PostgreObjectPrivilege) || !this.getName().equals(((PostgreObjectPrivilege)p).getGrantee())) continue;
                                    ArrayList<PostgrePrivilegeGrant> grants = new ArrayList<PostgrePrivilegeGrant>();
                                    PostgrePrivilege.ObjectPermission[] objectPermissionArray = p.getPermissions();
                                    int n = objectPermissionArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        PostgrePrivilege.ObjectPermission perm = objectPermissionArray[n2];
                                        grants.add(new PostgrePrivilegeGrant(perm.getGrantor(), this.getName(), this.getDatabase().getName(), schema.getName(), objectName, perm.getPrivilegeType(), false, false));
                                        ++n2;
                                    }
                                    permissions.add((PostgrePrivilege)new PostgreRolePrivilege((PostgrePrivilegeOwner)this, pKind, schema.getName(), objectName, grants));
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable5 == null) {
                                throwable5 = throwable6;
                            } else if (throwable5 != throwable6) {
                                throwable5.addSuppressed(throwable6);
                            }
                            throw throwable5;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                    } else if (throwable2 != throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading privileges", (Throwable)e);
        }
        return permissions;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        return this;
    }

    @NotNull
    public RedshiftDataSource getDataSource() {
        return (RedshiftDataSource)super.getDataSource();
    }

    @NotNull
    public RedshiftDatabase getDatabase() {
        return (RedshiftDatabase)super.getDatabase();
    }

    protected void addPermissionsToDefinition(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            sql.append("\n");
            ArrayList actions = new ArrayList();
            PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePrivilegeOwner)this, actions, options);
            sql.append("\n").append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
        }
    }
}

