/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatashare;
import com.dbeaver.db.redshift.model.RedshiftGroup;
import com.dbeaver.db.redshift.model.RedshiftRole;
import com.dbeaver.db.redshift.model.RedshiftUser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class RedshiftDatabase
extends PostgreDatabase {
    private static final String TYPE_SHARED = "shared";
    private final DatashareCache datashareCache = new DatashareCache();
    private final GroupCache groupCache = new GroupCache();
    private final RoleCache roleCache = new RoleCache();
    private String databaseType;
    private String databaseOptions;

    public RedshiftDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, ResultSet dbResult) throws DBException {
        super(monitor, dataSource, dbResult);
    }

    public RedshiftDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String databaseName) throws DBException {
        super(monitor, dataSource, databaseName);
    }

    public RedshiftDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        super(monitor, dataSource, name, owner, templateName, tablespace, encoding);
    }

    public boolean isSharedDatabase() {
        return this.sharedInstance != null || TYPE_SHARED.equals(this.databaseType);
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getDatabaseOptions() {
        return this.databaseOptions;
    }

    protected void loadInfo(ResultSet dbResult) {
        super.loadInfo(dbResult);
        if (this.getDataSource().supportsRedshiftDatashare()) {
            this.databaseType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"database_type");
            this.databaseOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"database_options");
        }
    }

    @NotNull
    public RedshiftDataSource getDataSource() {
        return (RedshiftDataSource)super.getDataSource();
    }

    @NotNull
    public DatashareCache getDatashareCache() {
        return this.datashareCache;
    }

    public GroupCache getGroupCache() {
        return this.groupCache;
    }

    public RoleCache getDatabaseRoleCache() {
        return this.roleCache;
    }

    @Association
    @NotNull
    public List<RedshiftDatashare> getDatashares(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.datashareCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public RedshiftDatashare getDatashare(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return (RedshiftDatashare)this.datashareCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public List<RedshiftGroup> getGroups(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.groupCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public RedshiftGroup getGroup(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return (RedshiftGroup)this.groupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public List<RedshiftRole> getRoles(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public RedshiftRole getRole(@NotNull DBRProgressMonitor monitor, String name) throws DBException {
        return (RedshiftRole)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.datashareCache.clearCache();
        this.groupCache.clearCache();
        this.roleCache.clearCache();
        return super.refreshObject(monitor);
    }

    public void setSharedInstance(PostgreDatabase instance) {
        this.sharedInstance = instance;
    }

    @NotNull
    protected PostgreDatabase.PostgreDatabaseJDBCObjectCache<RedshiftUser> createRoleCache() {
        return new UserCache();
    }

    static class DatashareCache
    extends JDBCObjectCache<RedshiftDatabase, RedshiftDatashare> {
        DatashareCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull RedshiftDatabase owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM SVV_DATASHARES ORDER BY share_name");
            return dbStat;
        }

        protected RedshiftDatashare fetchObject(@NotNull JDBCSession session, @NotNull RedshiftDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new RedshiftDatashare(owner, dbResult);
        }
    }

    public static class DatashareSupportValidation
    implements IPropertyValueValidator<RedshiftDatabase, Object> {
        public boolean isValidValue(RedshiftDatabase object, Object value) throws IllegalArgumentException {
            return object.getDataSource().supportsRedshiftDatashare() && object.isSharedDatabase();
        }
    }

    static class GroupCache
    extends PostgreDatabase.PostgreDatabaseJDBCObjectCache<RedshiftGroup> {
        GroupCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM pg_catalog.pg_group");
        }

        protected RedshiftGroup fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new RedshiftGroup(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(Exception error) {
            if (error instanceof DBException && "42501".equals(((DBException)error).getDatabaseState())) {
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    static class RoleCache
    extends PostgreDatabase.PostgreDatabaseJDBCObjectCache<RedshiftRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM pg_catalog.svv_roles");
        }

        protected RedshiftRole fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException {
            return new RedshiftRole(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(Exception error) {
            if (error instanceof DBException && "42501".equals(((DBException)error).getDatabaseState())) {
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    static class UserCache
    extends PostgreDatabase.PostgreDatabaseJDBCObjectCache<RedshiftUser> {
        UserCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database) throws SQLException {
            StringBuilder ddl = new StringBuilder();
            ddl.append("select usesysid, usename, passwd, usesuper, usecreatedb, usecatupd, valuntil::timestamp, ");
            if (UserCache.isCurrentUserSuper(session)) {
                ddl.append("case when useconnlimit = 'UNLIMITED' then -1 else useconnlimit::int4 end").append("\nfrom pg_catalog.pg_user_info");
            } else {
                ddl.append("null as useconnlimit").append("\nfrom pg_catalog.pg_user");
            }
            ddl.append("\norder by usename");
            return session.prepareStatement(ddl.toString());
        }

        @Nullable
        protected RedshiftUser fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull JDBCResultSet resultSet) throws SQLException {
            return new RedshiftUser((RedshiftDatabase)database, (ResultSet)resultSet);
        }

        private static boolean isCurrentUserSuper(@NotNull JDBCSession session) throws SQLException {
            Boolean result = (Boolean)JDBCUtils.executeQuery((Connection)session, (String)"select usesuper from pg_catalog.pg_user where usesysid = current_user_id", (Object[])new Object[0]);
            return CommonUtils.getBoolean((Object)result, (boolean)false);
        }
    }
}

