/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.edit;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftRole;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class RedshiftRoleManager
extends SQLObjectEditor<RedshiftRole, RedshiftDatabase>
implements DBEObjectRenamer<RedshiftRole> {
    public static final String ROLE_BASE_NAME = "new_role";

    public boolean canDeleteObject(RedshiftRole object) {
        return !object.getName().startsWith("sys:");
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, RedshiftRole> getObjectsCache(RedshiftRole object) {
        return object.getDatabase().getDatabaseRoleCache();
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull RedshiftRole object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected String getBaseObjectName() {
        return ROLE_BASE_NAME;
    }

    protected RedshiftRole createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new RedshiftRole((PostgreDatabase)container, ROLE_BASE_NAME);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create role", "CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        RedshiftDataSource dataSource = ((RedshiftRole)command.getObject()).getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename role", "ALTER ROLE " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop role", "DROP ROLE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }
}

