/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftserverless.model.Snapshot;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class SnapshotMarshaller {
    private static final MarshallingInfo<List> ACCOUNTSWITHPROVISIONEDRESTOREACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountsWithProvisionedRestoreAccess").build();
    private static final MarshallingInfo<List> ACCOUNTSWITHRESTOREACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("accountsWithRestoreAccess").build();
    private static final MarshallingInfo<Double> ACTUALINCREMENTALBACKUPSIZEINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actualIncrementalBackupSizeInMegaBytes").build();
    private static final MarshallingInfo<String> ADMINPASSWORDSECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adminPasswordSecretArn").build();
    private static final MarshallingInfo<String> ADMINPASSWORDSECRETKMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adminPasswordSecretKmsKeyId").build();
    private static final MarshallingInfo<String> ADMINUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("adminUsername").build();
    private static final MarshallingInfo<Double> BACKUPPROGRESSINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("backupProgressInMegaBytes").build();
    private static final MarshallingInfo<Double> CURRENTBACKUPRATEINMEGABYTESPERSECOND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("currentBackupRateInMegaBytesPerSecond").build();
    private static final MarshallingInfo<Long> ELAPSEDTIMEINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("elapsedTimeInSeconds").build();
    private static final MarshallingInfo<Long> ESTIMATEDSECONDSTOCOMPLETION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("estimatedSecondsToCompletion").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyId").build();
    private static final MarshallingInfo<String> NAMESPACEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("namespaceArn").build();
    private static final MarshallingInfo<String> NAMESPACENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("namespaceName").build();
    private static final MarshallingInfo<String> OWNERACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownerAccount").build();
    private static final MarshallingInfo<String> SNAPSHOTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotArn").build();
    private static final MarshallingInfo<Date> SNAPSHOTCREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotCreateTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> SNAPSHOTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotName").build();
    private static final MarshallingInfo<Integer> SNAPSHOTREMAININGDAYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotRemainingDays").build();
    private static final MarshallingInfo<Integer> SNAPSHOTRETENTIONPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotRetentionPeriod").build();
    private static final MarshallingInfo<Date> SNAPSHOTRETENTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("snapshotRetentionStartTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Double> TOTALBACKUPSIZEINMEGABYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalBackupSizeInMegaBytes").build();
    private static final SnapshotMarshaller instance = new SnapshotMarshaller();

    public static SnapshotMarshaller getInstance() {
        return instance;
    }

    public void marshall(Snapshot snapshot, ProtocolMarshaller protocolMarshaller) {
        if (snapshot == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(snapshot.getAccountsWithProvisionedRestoreAccess(), ACCOUNTSWITHPROVISIONEDRESTOREACCESS_BINDING);
            protocolMarshaller.marshall(snapshot.getAccountsWithRestoreAccess(), ACCOUNTSWITHRESTOREACCESS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getActualIncrementalBackupSizeInMegaBytes(), ACTUALINCREMENTALBACKUPSIZEINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getAdminPasswordSecretArn(), ADMINPASSWORDSECRETARN_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getAdminPasswordSecretKmsKeyId(), ADMINPASSWORDSECRETKMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getAdminUsername(), ADMINUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getBackupProgressInMegaBytes(), BACKUPPROGRESSINMEGABYTES_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getCurrentBackupRateInMegaBytesPerSecond(), CURRENTBACKUPRATEINMEGABYTESPERSECOND_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getElapsedTimeInSeconds(), ELAPSEDTIMEINSECONDS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getEstimatedSecondsToCompletion(), ESTIMATEDSECONDSTOCOMPLETION_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getNamespaceArn(), NAMESPACEARN_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getNamespaceName(), NAMESPACENAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getOwnerAccount(), OWNERACCOUNT_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotArn(), SNAPSHOTARN_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotCreateTime(), SNAPSHOTCREATETIME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotName(), SNAPSHOTNAME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotRemainingDays(), SNAPSHOTREMAININGDAYS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotRetentionPeriod(), SNAPSHOTRETENTIONPERIOD_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getSnapshotRetentionStartTime(), SNAPSHOTRETENTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)snapshot.getTotalBackupSizeInMegaBytes(), TOTALBACKUPSIZEINMEGABYTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

