/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.sql.dialect;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzerImpl;
import org.jkiss.dbeaver.model.lsm.sql.impl.syntax.SQLStandardLexer;
import org.jkiss.dbeaver.model.lsm.sql.impl.syntax.SQLStandardParser;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.utils.Pair;

public class SQLStandardAnalyzer
extends LSMAnalyzerImpl<SQLStandardLexer, SQLStandardParser> {
    public SQLStandardAnalyzer(SQLDialect dialect) {
        super(dialect);
    }

    @Override
    @NotNull
    protected Pair<SQLStandardLexer, SQLStandardParser> createParser(@NotNull STMSource source, @NotNull SQLDialect dialect) {
        SQLStandardLexer lexer = SQLStandardAnalyzer.createLexer(source, dialect);
        SQLStandardParser parser = new SQLStandardParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        return new Pair((Object)lexer, (Object)parser);
    }

    public static SQLStandardLexer createLexer(@NotNull STMSource source, @NotNull SQLDialect dialect) {
        Map<String, String> identifierQuotPairs = Stream.of(Objects.requireNonNull(dialect.getIdentifierQuoteStrings())).collect(Collectors.toUnmodifiableMap(q -> q[0], q -> q[1]));
        SQLStandardLexer lexer = new SQLStandardLexer(source.getStream(), identifierQuotPairs);
        return lexer;
    }

    @Override
    @NotNull
    protected STMTreeRuleNode parseSqlQueryImpl(@NotNull SQLStandardParser parser) {
        return parser.sqlQuery();
    }
}

