/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm;

import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.lsm.LSMAnalyzer;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.stm.STMErrorListener;
import org.jkiss.dbeaver.model.stm.STMParserOverrides;
import org.jkiss.dbeaver.model.stm.STMSource;
import org.jkiss.dbeaver.model.stm.STMTreeRuleNode;
import org.jkiss.utils.Pair;

public abstract class LSMAnalyzerImpl<TLexer extends Lexer, TParser extends STMParserOverrides>
implements LSMAnalyzer {
    private static final Log log = Log.getLog(LSMAnalyzerImpl.class);
    private final SQLDialect dialect;

    public LSMAnalyzerImpl(@NotNull SQLDialect dialect) {
        this.dialect = dialect;
    }

    @NotNull
    protected abstract Pair<TLexer, TParser> createParser(@NotNull STMSource var1, @NotNull SQLDialect var2);

    @NotNull
    protected abstract STMTreeRuleNode parseSqlQueryImpl(@NotNull TParser var1);

    @NotNull
    protected TParser prepareParser(@NotNull STMSource source, @Nullable STMErrorListener errorListener) {
        Pair<TLexer, TParser> pair = this.createParser(source, this.dialect);
        Lexer lexer = (Lexer)pair.getFirst();
        STMParserOverrides parser = (STMParserOverrides)((Object)pair.getSecond());
        if (errorListener != null) {
            lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            parser.addErrorListener(errorListener);
        }
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
        return (TParser)((Object)parser);
    }

    @Override
    @Nullable
    public STMTreeRuleNode parseSqlQueryTree(@NotNull STMSource source, @Nullable STMErrorListener errorListener) {
        try {
            TParser parser = this.prepareParser(source, errorListener);
            STMTreeRuleNode result = this.parseSqlQueryImpl(parser);
            result.fixup((STMParserOverrides)((Object)parser));
            return result;
        }
        catch (RecognitionException e) {
            log.debug((Object)"Recognition exception occurred while trying to parse the query", (Throwable)e);
            return null;
        }
    }
}

