/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.function.Function;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TrimmableField;
import org.firebirdsql.util.IOUtils;

class FBStringField
extends FBField
implements TrimmableField {
    static final String SHORT_TRUE = "Y";
    static final String SHORT_FALSE = "N";
    static final String LONG_TRUE = "true";
    static final String LONG_FALSE = "false";
    static final String SHORT_TRUE_2 = "T";
    static final String SHORT_TRUE_3 = "1";
    protected final int possibleCharLength;
    private boolean trimTrailing;

    FBStringField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
        int charLength = fieldDescriptor.getCharacterLength();
        this.possibleCharLength = charLength != -1 ? charLength : fieldDescriptor.getLength();
    }

    @Override
    public final void setTrimTrailing(boolean trimTrailing) {
        this.trimTrailing = trimTrailing;
    }

    @Override
    public final boolean isTrimTrailing() {
        return this.trimTrailing;
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getString();
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("byte", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("short", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        String string = this.getString().trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("int", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        String string = this.getString().trim();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("long", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return this.getValueAs(BigDecimal.class, BigDecimal::new);
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        String string = this.getString().trim();
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("float", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        String string = this.getString().trim();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidGetConversion("double", string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        String trimmedValue = this.getString().trim();
        return trimmedValue.equalsIgnoreCase(LONG_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE) || trimmedValue.equalsIgnoreCase(SHORT_TRUE_2) || trimmedValue.equals(SHORT_TRUE_3);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        String result = this.applyTrimTrailing(this.getDatatypeCoder().decodeString(this.getFieldData()));
        if (this.requiredType == 12 || this.isTrimTrailing()) {
            return result;
        }
        return this.fixPadding(result);
    }

    private String fixPadding(String result) {
        if (result.length() > this.possibleCharLength) {
            return result.substring(0, this.possibleCharLength);
        }
        return result;
    }

    final String applyTrimTrailing(String value) {
        return this.trimTrailing ? TrimmableField.trimTrailing(value) : value;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return (byte[])this.getFieldData().clone();
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDate(this.getDate(), cal);
    }

    @Override
    public Date getDate() throws SQLException {
        return this.getValueAs(Date.class, Date::valueOf);
    }

    @Override
    LocalDate getLocalDate() throws SQLException {
        return this.getValueAs(LocalDate.class, LocalDate::parse);
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTime(this.getTime(), cal, this.isInvertTimeZone());
    }

    @Override
    public Time getTime() throws SQLException {
        return this.getValueAs(Time.class, Time::valueOf);
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        return this.getValueAs(LocalTime.class, LocalTime::parse);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimestamp(this.getTimestamp(), cal, this.isInvertTimeZone());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        return this.getValueAs(Timestamp.class, string -> {
            int tIdx = ((String)string).indexOf(84);
            if (tIdx != -1) {
                string = ((String)string).substring(0, tIdx) + " " + ((String)string).substring(tIdx + 1);
            }
            return Timestamp.valueOf((String)string);
        });
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        return this.getValueAs(LocalDateTime.class, string -> {
            int spaceIdx = ((String)string).indexOf(32);
            if (spaceIdx != -1) {
                string = ((String)string).substring(0, spaceIdx) + SHORT_TRUE_2 + ((String)string).substring(spaceIdx + 1);
            }
            return LocalDateTime.parse((CharSequence)string);
        });
    }

    @Override
    OffsetTime getOffsetTime() throws SQLException {
        return this.getValueAs(OffsetTime.class, OffsetTime::parse);
    }

    @Override
    OffsetDateTime getOffsetDateTime() throws SQLException {
        return this.getValueAs(OffsetDateTime.class, OffsetDateTime::parse);
    }

    @Override
    ZonedDateTime getZonedDateTime() throws SQLException {
        return this.getValueAs(ZonedDateTime.class, ZonedDateTime::parse);
    }

    @Override
    public BigInteger getBigInteger() throws SQLException {
        return this.getValueAs(BigInteger.class, BigInteger::new);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setString(Byte.toString(value));
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setString(Short.toString(value));
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setString(Integer.toString(value));
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setString(Long.toString(value));
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setString(Float.toString(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setString(Double.toString(value));
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        if (this.possibleCharLength > 4) {
            this.setString(value ? LONG_TRUE : LONG_FALSE);
        } else if (this.possibleCharLength >= 1) {
            this.setString(value ? SHORT_TRUE : SHORT_FALSE);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        byte[] data = this.getDatatypeCoder().encodeString(value);
        if (data.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, data.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(data);
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setBytes(IOUtils.toBytes(in, (int)length));
        }
        catch (IOException ioex) {
            SQLException conversionException = this.invalidSetConversion(InputStream.class);
            conversionException.initCause(ioex);
            throw conversionException;
        }
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new FBDriverNotCapableException("Only length <= Integer.MAX_VALUE supported");
        }
        try {
            this.setString(IOUtils.toString(in, (int)length));
        }
        catch (IOException ioex) {
            SQLException conversionException = this.invalidSetConversion(Reader.class);
            conversionException.initCause(ioex);
            throw conversionException;
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, value.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(value);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setDate(this.getDatatypeCoder().encodeDate(value, cal));
    }

    @Override
    public void setDate(Date value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setLocalDate(LocalDate localDate) throws SQLException {
        this.setAsString(localDate);
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setTime(this.getDatatypeCoder().encodeTime(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTime(Time value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setLocalTime(LocalTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setTimestamp(this.getDatatypeCoder().encodeTimestamp(value, cal, this.isInvertTimeZone()));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setOffsetTime(OffsetTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setOffsetDateTime(OffsetDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    void setZonedDateTime(ZonedDateTime value) throws SQLException {
        this.setAsString(value);
    }

    @Override
    public void setBigInteger(BigInteger value) throws SQLException {
        this.setAsString(value);
    }

    private void setAsString(Object value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setString(value.toString());
    }

    private <T> T getValueAs(Class<T> type, Function<String, T> converter) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        String string = this.getString().trim();
        try {
            return converter.apply(string);
        }
        catch (RuntimeException e) {
            SQLException conversionException = this.invalidGetConversion(type, string);
            conversionException.initCause(e);
            throw conversionException;
        }
    }
}

