/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.fields;

import java.util.Objects;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;

public final class FieldDescriptor {
    private final int position;
    private final DatatypeCoder datatypeCoder;
    private final int type;
    private final int subType;
    private final int scale;
    private final int length;
    private final String fieldName;
    private final String tableAlias;
    private final String originalName;
    private final String originalTableName;
    private final String ownerName;
    private int hash;

    public FieldDescriptor(int position, DatatypeCoder datatypeCoder, int type, int subType, int scale, int length, String fieldName, String tableAlias, String originalName, String originalTableName, String ownerName) {
        assert (datatypeCoder != null) : "dataTypeCoder should not be null";
        this.position = position;
        this.datatypeCoder = FieldDescriptor.datatypeCoderForType(datatypeCoder, type, subType, scale);
        this.type = type;
        this.subType = subType;
        this.scale = scale;
        this.length = length;
        this.fieldName = fieldName;
        this.tableAlias = tableAlias == null || !tableAlias.isEmpty() ? tableAlias : null;
        this.originalName = originalName;
        this.originalTableName = originalTableName;
        this.ownerName = ownerName;
    }

    public int getPosition() {
        return this.position;
    }

    public DatatypeCoder getDatatypeCoder() {
        return this.datatypeCoder;
    }

    public IEncodingFactory getEncodingFactory() {
        return this.datatypeCoder.getEncodingFactory();
    }

    public int getType() {
        return this.type;
    }

    public int getSubType() {
        return this.subType;
    }

    public int getScale() {
        return this.scale;
    }

    public int getLength() {
        return this.length;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getOriginalTableName() {
        return this.originalTableName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isVarying() {
        return this.isFbType(448);
    }

    public boolean isFbType(int fbType) {
        return (this.type & 0xFFFFFFFE) == fbType;
    }

    public boolean isNullable() {
        return (this.type & 1) == 1;
    }

    public boolean isDbKey() {
        return "DB_KEY".equals(this.originalName) && this.isFbType(452) && (this.subType & 0xFF) == 1;
    }

    public int getCharacterLength() {
        switch (this.type & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                int maxBytesPerChar = this.getDatatypeCoder().getEncodingDefinition().getMaxBytesPerChar();
                return maxBytesPerChar > 1 && this.length % maxBytesPerChar == 0 ? this.length / maxBytesPerChar : this.length;
            }
        }
        return -1;
    }

    private static DatatypeCoder datatypeCoderForType(DatatypeCoder datatypeCoder, int type, int subType, int scale) {
        int characterSetId = FieldDescriptor.getCharacterSetId(type, subType, scale);
        EncodingDefinition encodingDefinition = datatypeCoder.getEncodingFactory().getEncodingDefinitionByCharacterSetId(characterSetId);
        return datatypeCoder.forEncodingDefinition(encodingDefinition);
    }

    private static int getCharacterSetId(int type, int subType, int scale) {
        switch (type & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                return subType & 0xFF;
            }
            case 520: {
                if (subType == 1) {
                    return scale & 0xFF;
                }
                return 1;
            }
        }
        return 127;
    }

    public int getCharacterSetId() {
        return FieldDescriptor.getCharacterSetId(this.type, this.subType, this.scale);
    }

    public boolean typeEquals(FieldDescriptor other) {
        return this == other || other != null && this.type == other.type && this.subType == other.subType && this.scale == other.scale && this.length == other.length;
    }

    public byte getPaddingByte() {
        switch (this.type & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                if (this.getCharacterSetId() == 1) {
                    return 0;
                }
                return 32;
            }
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendFieldDescriptor(sb);
        return sb.toString();
    }

    void appendFieldDescriptor(StringBuilder sb) {
        sb.append("FieldDescriptor:[").append("Position=").append(this.position).append(",FieldName=").append(this.fieldName).append(",TableAlias=").append(this.tableAlias).append(",Type=").append(this.type).append(",SubType=").append(this.subType).append(",Scale=").append(this.scale).append(",Length=").append(this.length).append(",OriginalName=").append(this.originalName).append(",OriginalTableName=").append(this.originalTableName).append(",OwnerName=").append(this.ownerName).append(']');
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor other = (FieldDescriptor)obj;
        return this.position == other.position && this.type == other.type && this.subType == other.subType && this.scale == other.scale && this.length == other.length && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.tableAlias, other.tableAlias) && Objects.equals(this.originalName, other.originalName) && Objects.equals(this.originalTableName, other.originalTableName) && Objects.equals(this.ownerName, other.ownerName) && this.datatypeCoder.equals(other.datatypeCoder);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.position, this.type, this.subType, this.scale, this.length, this.fieldName, this.tableAlias, this.originalName, this.originalTableName, this.ownerName);
        }
        return this.hash;
    }
}

