/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLPermission;
import java.util.concurrent.atomic.AtomicReference;
import org.firebirdsql.gds.ng.monitor.Operation;
import org.firebirdsql.gds.ng.monitor.OperationAware;

public final class OperationMonitor {
    private static final String PERMISSION_INIT_OPERATION_AWARE = "org.firebirdsql.jaybird.initOperationAware";
    private static final AtomicReference<OperationAware> instance = new AtomicReference<NoOpOperationAware>(NoOpOperationAware.INSTANCE);

    private OperationMonitor() {
    }

    static void startOperation(Operation operation) {
        OperationAware operationAware = instance.get();
        operationAware.startOperation(operation);
    }

    static void endOperation(Operation operation) {
        OperationAware operationAware = instance.get();
        operationAware.endOperation(operation);
    }

    public static void initOperationAware(OperationAware operationAware) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            SQLPermission permission = new SQLPermission(PERMISSION_INIT_OPERATION_AWARE);
            securityManager.checkPermission(permission);
        }
        instance.set(operationAware != null ? operationAware : NoOpOperationAware.INSTANCE);
    }

    private static final class NoOpOperationAware
    implements OperationAware {
        private static final NoOpOperationAware INSTANCE = new NoOpOperationAware();

        private NoOpOperationAware() {
        }

        @Override
        public void startOperation(Operation operation) {
        }

        @Override
        public void endOperation(Operation operation) {
        }
    }
}

