/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import com.couchbase.client.java.search.queries.Coordinate;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class GeoPolygonQuery
extends AbstractFtsQuery {
    private final List<Coordinate> coordinates;
    private String field;

    public GeoPolygonQuery(List<Coordinate> coordinates) {
        this.coordinates = coordinates;
    }

    public GeoPolygonQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public GeoPolygonQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        JsonArray points = JsonArray.empty();
        for (Coordinate coordinate : this.coordinates) {
            points.add(JsonArray.from(coordinate.lon(), coordinate.lat()));
        }
        input.put("polygon_points", points);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

