/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.path.index;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.element.WithIndexOptionElement;
import com.couchbase.client.java.query.dsl.path.AbstractPath;
import com.couchbase.client.java.query.dsl.path.index.WithPath;
import java.util.Collection;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class DefaultWithPath
extends AbstractPath
implements WithPath {
    public DefaultWithPath(AbstractPath parent) {
        super(parent);
    }

    private Statement with(boolean defer, String ... nodeNames) {
        JsonObject options = JsonObject.create();
        if (defer) {
            options.put("defer_build", true);
        }
        if (nodeNames != null && nodeNames.length > 0) {
            options.put("nodes", JsonArray.from(nodeNames));
        }
        this.element(new WithIndexOptionElement(options));
        return this;
    }

    @Override
    public Statement withNode(String nodeName) {
        if (nodeName == null) {
            return this.with(false, null);
        }
        return this.with(false, nodeName);
    }

    @Override
    public Statement withNodes(String ... nodeNames) {
        return this.with(false, nodeNames);
    }

    @Override
    public Statement withNodes(Collection<String> nodeNames) {
        String[] nodeNamesArray = nodeNames == null || nodeNames.isEmpty() ? null : nodeNames.toArray(new String[nodeNames.size()]);
        return this.with(false, nodeNamesArray);
    }

    @Override
    public Statement withDefer() {
        return this.with(true, null);
    }

    @Override
    public Statement withDeferAndNode(String nodeName) {
        if (nodeName == null) {
            return this.with(true, null);
        }
        return this.with(true, nodeName);
    }

    @Override
    public Statement withDeferAndNodes(String ... nodeNames) {
        return this.with(true, nodeNames);
    }

    @Override
    public Statement withDeferAndNodes(Collection<String> nodeNames) {
        String[] nodeNamesArray = nodeNames == null || nodeNames.isEmpty() ? null : nodeNames.toArray(new String[nodeNames.size()]);
        return this.with(true, nodeNamesArray);
    }
}

