/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class AggregateFunctions {
    private AggregateFunctions() {
    }

    public static Expression arrayAgg(Expression expression) {
        return Expression.x("ARRAY_AGG(" + expression.toString() + ")");
    }

    public static Expression arrayAgg(String expression) {
        return AggregateFunctions.arrayAgg(Expression.x(expression));
    }

    public static Expression avg(Expression expression) {
        return Expression.x("AVG(" + expression.toString() + ")");
    }

    public static Expression avg(String expression) {
        return AggregateFunctions.avg(Expression.x(expression));
    }

    public static Expression count(Expression expression) {
        return Expression.x("COUNT(" + expression.toString() + ")");
    }

    public static Expression count(String expression) {
        return AggregateFunctions.count(Expression.x(expression));
    }

    public static Expression countAll() {
        return Expression.x("COUNT(*)");
    }

    public static Expression max(Expression expression) {
        return Expression.x("MAX(" + expression.toString() + ")");
    }

    public static Expression max(String expression) {
        return AggregateFunctions.max(Expression.x(expression));
    }

    public static Expression min(Expression expression) {
        return Expression.x("MIN(" + expression.toString() + ")");
    }

    public static Expression min(String expression) {
        return AggregateFunctions.min(Expression.x(expression));
    }

    public static Expression sum(Expression expression) {
        return Expression.x("SUM(" + expression.toString() + ")");
    }

    public static Expression sum(String expression) {
        return AggregateFunctions.sum(Expression.x(expression));
    }

    public static Expression distinct(Expression expression) {
        return Expression.x("DISTINCT " + expression.toString());
    }

    public static Expression distinct(String expression) {
        return Expression.x("DISTINCT " + expression);
    }
}

