/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.cluster;

import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.CompressionMode;
import com.couchbase.client.java.cluster.EjectionMethod;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultBucketSettings
implements BucketSettings {
    private static final int DEFAULT_QUOTA_MB = 100;
    private final String name;
    private final BucketType type;
    private final int quota;
    private final int port;
    private final String password;
    private final int replicas;
    private final boolean indexReplicas;
    private final boolean enableFlush;
    private final Map<String, Object> customSettings;
    private final JsonObject raw;
    private final CompressionMode compressionMode;
    private final EjectionMethod ejectionMethod;

    private DefaultBucketSettings(Builder builder) {
        this(builder, JsonObject.empty());
    }

    private DefaultBucketSettings(Builder builder, JsonObject raw) {
        this.name = builder.name();
        this.type = builder.type();
        this.quota = builder.quota();
        this.port = builder.port();
        this.password = builder.password();
        this.replicas = builder.replicas();
        this.indexReplicas = builder.indexReplicas();
        this.enableFlush = builder.enableFlush();
        this.customSettings = builder.customSettings();
        this.compressionMode = builder.compressionMode();
        this.ejectionMethod = builder.ejectionMethod();
        this.raw = raw;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultBucketSettings create(String name) {
        return DefaultBucketSettings.builder().name(name).build();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BucketType type() {
        return this.type;
    }

    @Override
    public int quota() {
        return this.quota;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public int replicas() {
        return this.replicas;
    }

    @Override
    public boolean indexReplicas() {
        return this.indexReplicas;
    }

    @Override
    public boolean enableFlush() {
        return this.enableFlush;
    }

    @Override
    public CompressionMode compressionMode() {
        return this.compressionMode;
    }

    @Override
    public EjectionMethod ejectionMethod() {
        return this.ejectionMethod;
    }

    @Override
    public Map<String, Object> customSettings() {
        return this.customSettings;
    }

    @Override
    public JsonObject raw() {
        return this.raw;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("DefaultBucketSettings{").append("name='").append(this.name).append('\'').append(", type=").append((Object)this.type).append(", quota=").append(this.quota).append(", port=").append(this.port).append(", password='").append(this.password).append('\'').append(", replicas=").append(this.replicas).append(", indexReplicas=").append(this.indexReplicas).append(", compressionMode=").append((Object)this.compressionMode).append(", ejectionMethod=").append((Object)this.ejectionMethod).append(", enableFlush=").append(this.enableFlush);
        if (!this.customSettings.isEmpty()) {
            s.append(", customSettings=").append(this.customSettings);
        }
        s.append('}');
        return s.toString();
    }

    public static class Builder
    implements BucketSettings {
        private String name = "";
        private BucketType type = BucketType.COUCHBASE;
        private int quota = 100;
        private int port = 0;
        private String password = "";
        private int replicas = 0;
        private boolean indexReplicas = false;
        private boolean enableFlush = false;
        private CompressionMode compressionMode = null;
        private EjectionMethod ejectionMethod = null;
        private final Map<String, Object> customSettings = new LinkedHashMap<String, Object>();

        @Override
        public String name() {
            return this.name;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public BucketType type() {
            return this.type;
        }

        public Builder type(BucketType type) {
            this.type = type;
            return this;
        }

        @Override
        public int quota() {
            return this.quota;
        }

        public Builder quota(int quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public int port() {
            return this.port;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public String password() {
            return this.password;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public int replicas() {
            return this.replicas;
        }

        public Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public boolean indexReplicas() {
            return this.indexReplicas;
        }

        public Builder indexReplicas(boolean indexReplicas) {
            this.indexReplicas = indexReplicas;
            return this;
        }

        @Override
        public boolean enableFlush() {
            return this.enableFlush;
        }

        public Builder enableFlush(boolean enableFlush) {
            this.enableFlush = enableFlush;
            return this;
        }

        @Override
        public CompressionMode compressionMode() {
            return this.compressionMode;
        }

        public Builder compressionMode(CompressionMode compressionMode) {
            this.compressionMode = compressionMode;
            return this;
        }

        @Override
        public EjectionMethod ejectionMethod() {
            return this.ejectionMethod;
        }

        public Builder ejectionMethod(EjectionMethod ejectionMethod) {
            this.ejectionMethod = ejectionMethod;
            return this;
        }

        @Override
        public Map<String, Object> customSettings() {
            return this.customSettings;
        }

        @Override
        public JsonObject raw() {
            return JsonObject.empty();
        }

        public Builder withSetting(String key, Object value) {
            this.customSettings.put(key, value);
            return this;
        }

        public Builder withSettings(Map<String, Object> customSettings) {
            this.customSettings.putAll(customSettings);
            return this;
        }

        public DefaultBucketSettings build() {
            return new DefaultBucketSettings(this);
        }

        public DefaultBucketSettings build(JsonObject raw) {
            return new DefaultBucketSettings(this, raw);
        }
    }
}

