/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.UnicodeReader;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ContentUtils {
    static final int STREAM_COPY_BUFFER_SIZE = 10000;
    private static final String LOB_DIR = ".lob";
    private static final Log log = Log.getLog(ContentUtils.class);

    public static Path getLobFolder(DBRProgressMonitor monitor, DBPPlatform application) throws IOException {
        return application.getTempFolder(monitor, LOB_DIR);
    }

    public static Path createTempContentFile(DBRProgressMonitor monitor, DBPPlatform application, String fileName) throws IOException {
        return ContentUtils.makeTempFile(monitor, ContentUtils.getLobFolder(monitor, application), fileName, "data");
    }

    public static Path makeTempFile(DBRProgressMonitor monitor, Path folder, String name, String extension) throws IOException {
        name = CommonUtils.escapeFileName((String)name);
        Path tempFile = folder.resolve(name + "-" + System.currentTimeMillis() + "." + extension);
        Files.createFile(tempFile, new FileAttribute[0]);
        return tempFile;
    }

    public static void saveContentToFile(InputStream contentStream, File file, DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream os = new FileOutputStream(file);){
            ContentUtils.copyStreams(contentStream, file.length(), os, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (monitor.isCanceled() && !file.delete()) {
            log.warn("Can't delete incomplete file '" + file.getAbsolutePath() + "'");
        }
    }

    public static void saveContentToFile(Reader contentReader, File file, String charset, DBRProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);){
            ContentUtils.copyStreams(contentReader, file.length(), writer, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (monitor.isCanceled() && !file.delete()) {
            log.warn("Can't delete incomplete file '" + file.getAbsolutePath() + "'");
        }
    }

    public static void copyStreams(InputStream inputStream, long contentLength, OutputStream outputStream, DBRProgressMonitor monitor) throws IOException {
        monitor.beginTask("Copy binary content", contentLength < 0L ? 10000 : (int)contentLength);
        try {
            byte[] buffer = new byte[10000];
            long totalCopied = 0L;
            ByteNumberFormat nf = new ByteNumberFormat(ByteNumberFormat.BinaryPrefix.ISO);
            String subtaskSuffix = " / " + nf.format(contentLength);
            while (!monitor.isCanceled()) {
                int count = inputStream.read(buffer);
                if (count <= 0) {
                    break;
                }
                totalCopied += (long)count;
                outputStream.write(buffer, 0, count);
                monitor.worked(10000);
                if (contentLength <= 0L) continue;
                monitor.subTask(nf.format(totalCopied) + subtaskSuffix);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void copyStreams(Reader reader, long contentLength, Writer writer, DBRProgressMonitor monitor) throws IOException {
        monitor.beginTask("Copy character content", contentLength < 0L ? 10000 : (int)contentLength);
        try {
            char[] buffer = new char[10000];
            while (!monitor.isCanceled()) {
                int count = reader.read(buffer);
                if (count <= 0) {
                    break;
                }
                writer.write(buffer, 0, count);
                monitor.worked(10000);
            }
        }
        finally {
            monitor.done();
        }
    }

    public static long calculateContentLength(File file, String charset) throws IOException {
        return ContentUtils.calculateContentLength(new FileInputStream(file), charset);
    }

    public static long calculateContentLength(InputStream stream, String charset) throws IOException {
        return ContentUtils.calculateContentLength(new InputStreamReader(stream, charset));
    }

    public static long calculateContentLength(Reader reader) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            try {
                int count;
                long length = 0L;
                char[] buffer = new char[10000];
                while ((count = reader.read(buffer)) > 0) {
                    length += (long)count;
                }
                return length;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.warn("Error closing stream", e);
        }
    }

    public static String readToString(InputStream is, Charset charset) throws IOException {
        return IOUtils.readToString((Reader)new UnicodeReader(is, charset));
    }

    public static boolean isTextContent(DBDContent content) {
        String contentType;
        String string = contentType = content == null ? null : content.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("text");
    }

    public static boolean isTextMime(String mimeType) {
        return mimeType != null && mimeType.toLowerCase(Locale.ENGLISH).startsWith("text");
    }

    public static boolean isTextValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof CharSequence) {
            return true;
        }
        if (value instanceof byte[]) {
            byte[] byArray = (byte[])value;
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (!(Character.isLetterOrDigit(b) || Character.isSpaceChar(b) || Character.isISOControl(b))) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static boolean isXML(DBDContent content) {
        return "text/xml".equalsIgnoreCase(content.getContentType());
    }

    public static boolean isJSON(DBDContent content) {
        return "text/json".equalsIgnoreCase(content.getContentType());
    }

    @Nullable
    public static String getContentStringValue(@NotNull DBRProgressMonitor monitor, @NotNull DBDContent object) throws DBCException {
        block8: {
            if (object.isNull()) {
                return null;
            }
            DBDContentStorage data = object.getContents(monitor);
            if (data != null) {
                String string;
                Object cachedValue;
                if (data instanceof DBDContentCached && (cachedValue = ((DBDContentCached)((Object)data)).getCachedValue()) instanceof String) {
                    return (String)cachedValue;
                }
                Reader contentReader = data.getContentReader();
                if (contentReader == null) break block8;
                try {
                    StringWriter buf = new StringWriter();
                    ContentUtils.copyStreams(contentReader, object.getContentLength(), buf, monitor);
                    string = buf.toString();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable)contentReader);
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug("Can't extract string from content", e);
                    }
                }
                IOUtils.close((Closeable)contentReader);
                return string;
            }
        }
        return object.toString();
    }

    @Nullable
    public static byte[] getContentBinaryValue(@NotNull DBRProgressMonitor monitor, @NotNull DBDContent object) throws DBCException {
        block7: {
            DBDContentStorage data = object.getContents(monitor);
            if (data != null) {
                byte[] byArray;
                Object cachedValue;
                if (data instanceof DBDContentCached && (cachedValue = ((DBDContentCached)((Object)data)).getCachedValue()) instanceof byte[]) {
                    return (byte[])cachedValue;
                }
                InputStream contentStream = data.getContentStream();
                if (contentStream == null) break block7;
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    ContentUtils.copyStreams(contentStream, object.getContentLength(), buf, monitor);
                    byArray = buf.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.close((Closeable)contentStream);
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.debug("Can't extract string from content", e);
                    }
                }
                IOUtils.close((Closeable)contentStream);
                return byArray;
            }
        }
        return null;
    }

    public static void deleteTempFile(File tempFile) {
        if (!tempFile.delete()) {
            log.warn("Can't delete temp file '" + tempFile.getAbsolutePath() + "'");
        }
    }

    public static void deleteTempFile(Path tempFile) {
        try {
            Files.delete(tempFile);
        }
        catch (IOException iOException) {
            log.warn("Can't delete temp file '" + String.valueOf(tempFile.toAbsolutePath()) + "'");
        }
    }

    public static boolean deleteFileRecursive(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File ch = fileArray[n2];
                if (!ContentUtils.deleteFileRecursive(ch)) {
                    return false;
                }
                ++n2;
            }
        }
        return file.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteFileRecursive(Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            try {
                List<Path> files = Files.list(file).toList();
                for (Path ch : files) {
                    if (ContentUtils.deleteFileRecursive(ch)) continue;
                    return false;
                }
            }
            catch (IOException e) {
                log.warn("Error reading directory " + String.valueOf(file), e);
            }
        }
        try {
            Files.deleteIfExists(file);
            return true;
        }
        catch (IOException e) {
            log.warn("Error deleting file " + String.valueOf(file), e);
            return false;
        }
    }

    public static void makeFileBackup(Path file) {
        Path backupFile;
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        String backupFileName = file.getFileName().toString() + ".bak";
        if (!backupFileName.startsWith(".")) {
            backupFileName = "." + backupFileName;
        }
        if (Files.exists(backupFile = file.getParent().resolve(backupFileName), new LinkOption[0])) {
            try {
                Date backupTime = new Date(Files.getLastModifiedTime(backupFile, new LinkOption[0]).toMillis());
                if (CommonUtils.isSameDay((Date)backupTime, (Date)new Date())) {
                    return;
                }
            }
            catch (IOException e) {
                log.error("Error getting file modified time", e);
            }
        }
        try {
            Files.copy(file, backupFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            log.error("Error creating backup copy of " + String.valueOf(file.toAbsolutePath()), e);
        }
    }
}

