/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.SecuredPasswordEncrypter;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GlobalProxyAuthenticator
extends Authenticator {
    private SecuredPasswordEncrypter encrypter;
    private final IProxyService proxyService;

    public GlobalProxyAuthenticator() {
        BundleContext bundleContext = ModelActivator.getInstance().getBundle().getBundleContext();
        ServiceReference proxyServiceRef = bundleContext.getServiceReference(IProxyService.class);
        this.proxyService = proxyServiceRef != null ? (IProxyService)bundleContext.getService(proxyServiceRef) : null;
    }

    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        IProxyData[] proxyData;
        DBPDataSourceContainer activeContext;
        String requestingProtocol;
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String proxyHost = store.getString("ui.proxy.host");
        if (!CommonUtils.isEmpty((String)proxyHost) && proxyHost.equalsIgnoreCase(this.getRequestingHost()) && store.getInt("ui.proxy.port") == this.getRequestingPort()) {
            DBPAuthInfo authInfo;
            String userName = store.getString("ui.proxy.user");
            String userPassword = this.decryptPassword(store.getString("ui.proxy.password"));
            if ((CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) && (authInfo = this.readCredentialsInUI("Auth proxy '" + proxyHost + "'", userName, userPassword)) != null) {
                userName = authInfo.getUserName();
                userPassword = authInfo.getUserPassword();
                if (authInfo.isSavePassword()) {
                    store.setValue("ui.proxy.user", userName);
                    store.setValue("ui.proxy.password", this.encryptPassword(userPassword));
                }
            }
            if (!CommonUtils.isEmpty((String)userName) && !CommonUtils.isEmpty((String)userPassword)) {
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }
        if (("SOCKS5".equals(requestingProtocol = this.getRequestingProtocol()) || "SOCKS4".equals(requestingProtocol)) && (activeContext = DBExecUtils.findConnectionContext(this.getRequestingHost(), this.getRequestingPort(), this.getRequestingScheme())) != null) {
            for (DBWHandlerConfiguration networkHandler : activeContext.getConnectionConfiguration().getHandlers()) {
                DBPAuthInfo authInfo;
                if (!networkHandler.isEnabled() || networkHandler.getType() != DBWHandlerType.PROXY) continue;
                String userName = networkHandler.getUserName();
                String userPassword = networkHandler.getPassword();
                if ((CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) && (authInfo = this.readCredentialsInUI(this.getRequestingPrompt(), userName, userPassword)) != null) {
                    userName = authInfo.getUserName();
                    userPassword = authInfo.getUserPassword();
                    if (authInfo.isSavePassword()) {
                        networkHandler.setUserName(userName);
                        networkHandler.setPassword(userPassword);
                        networkHandler.setSavePassword(true);
                        activeContext.getRegistry().flushConfig();
                    }
                }
                if (CommonUtils.isEmpty((String)userName) || CommonUtils.isEmpty((String)userPassword)) continue;
                return new PasswordAuthentication(userName, userPassword.toCharArray());
            }
        }
        if (this.proxyService != null && (proxyData = this.proxyService.getProxyData()) != null) {
            IProxyData[] iProxyDataArray = proxyData;
            int n = proxyData.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData pd = iProxyDataArray[n2];
                if (this.getRequestingProtocol().startsWith(pd.getType()) && pd.getUserId() != null && pd.getHost() != null && pd.getPort() == this.getRequestingPort() && pd.getHost().equalsIgnoreCase(this.getRequestingHost())) {
                    return new PasswordAuthentication(pd.getUserId(), pd.getPassword().toCharArray());
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    private String encryptPassword(String password) {
        try {
            if (this.encrypter == null) {
                this.encrypter = new SecuredPasswordEncrypter();
            }
            return this.encrypter.encrypt(password);
        }
        catch (EncryptionException encryptionException) {
            return password;
        }
    }

    private String decryptPassword(String password) {
        if (CommonUtils.isEmpty((String)password)) {
            return password;
        }
        try {
            if (this.encrypter == null) {
                this.encrypter = new SecuredPasswordEncrypter();
            }
            return this.encrypter.decrypt(password);
        }
        catch (EncryptionException encryptionException) {
            return password;
        }
    }

    private DBPAuthInfo readCredentialsInUI(String prompt, String userName, String userPassword) {
        return DBWorkbench.getPlatformUI().promptUserCredentials(prompt, userName, userPassword, false, true);
    }
}

