/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.SubTaskProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociationLazy;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public final class DBStructUtils {
    private static final Log log = Log.getLog(DBStructUtils.class);
    private static final String INT_DATA_TYPE = "int";
    private static final String INTEGER_DATA_TYPE = "integer";
    private static final String FLOAT_DATA_TYPE = "float";
    private static final String REAL_DATA_TYPE = "real";
    private static final String DOUBLE_DATA_TYPE = "double";
    private static final String TEXT_DATA_TYPE = "text";
    private static final String VARCHAR_DATA_TYPE = "varchar";
    private static final String VARCHAR2_DATA_TYPE = "varchar2";
    private static final int DEFAULT_VARCHAR_LENGTH = 100;

    @Nullable
    public static DBSEntityReferrer getEnumerableConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBDAttributeBinding attribute) throws DBException {
        DBSEntityAttribute entityAttribute = attribute.getEntityAttribute();
        if (entityAttribute != null) {
            return DBStructUtils.getEnumerableConstraint(monitor, entityAttribute);
        }
        return null;
    }

    @Nullable
    public static DBSEntityReferrer getEnumerableConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute entityAttribute) throws DBException {
        DBSDictionary dictionary;
        DBSEntity associatedEntity;
        DBSEntityReferrer constraint;
        List<DBSEntityReferrer> refs = DBUtils.getAttributeReferrers(monitor, entityAttribute, true);
        DBSEntityReferrer dBSEntityReferrer = constraint = refs.isEmpty() ? null : refs.get(0);
        if (constraint != null && (associatedEntity = DBStructUtils.getAssociatedEntity(monitor, constraint)) instanceof DBSDictionary && (dictionary = (DBSDictionary)((Object)associatedEntity)).supportsDictionaryEnumeration()) {
            return constraint;
        }
        return null;
    }

    @Nullable
    public static DBSEntity getAssociatedEntity(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityConstraint constraint) throws DBException {
        if (constraint instanceof DBSEntityAssociationLazy) {
            return ((DBSEntityAssociationLazy)constraint).getAssociatedEntity(monitor);
        }
        if (constraint instanceof DBSEntityAssociation) {
            return ((DBSEntityAssociation)constraint).getAssociatedEntity();
        }
        return null;
    }

    public static String generateTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(table.getClass(), SQLObjectEditor.class);
        if (entityEditor instanceof SQLTableManager) {
            DBEPersistAction[] ddlActions = ((SQLTableManager)entityEditor).getTableDDL(monitor, table, options);
            return SQLUtils.generateScript(table.getDataSource(), ddlActions, addComments);
        }
        log.debug("Table editor not found for " + table.getClass().getName());
        return SQLUtils.generateCommentLine(table.getDataSource(), "Can't generate DDL: table editor not found for " + table.getClass().getName());
    }

    public static String generateObjectDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(object.getClass(), SQLObjectEditor.class);
        if (entityEditor != null) {
            SQLObjectEditor.ObjectCreateCommand createCommand = entityEditor.makeCreateCommand(object, options);
            DBEPersistAction[] ddlActions = createCommand.getPersistActions(monitor, DBUtils.getDefaultContext(object, true), options);
            return SQLUtils.generateScript(object.getDataSource(), ddlActions, addComments);
        }
        log.debug("Object editor not found for " + object.getClass().getName());
        return SQLUtils.generateCommentLine(object.getDataSource(), "Can't generate DDL: object editor not found for " + object.getClass().getName());
    }

    public static String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, Map<String, Object> options, boolean addComments) throws DBException {
        String definitionText;
        if (table instanceof DBPScriptObject && !CommonUtils.isEmpty((String)(definitionText = ((DBPScriptObject)((Object)table)).getObjectDefinitionText(monitor, options)))) {
            return definitionText;
        }
        return DBStructUtils.generateTableDDL(monitor, table, options, addComments);
    }

    public static <T extends DBSEntity> void generateTableListDDL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull Collection<T> tablesOrViews, Map<String, Object> options, boolean addComments) throws DBException {
        ArrayList goodTableList = new ArrayList();
        ArrayList cycleTableList = new ArrayList();
        ArrayList viewList = new ArrayList();
        DBStructUtils.sortTableList(monitor, tablesOrViews, goodTableList, cycleTableList, viewList);
        for (DBSEntity table : goodTableList) {
            sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_definition));
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        ArrayList<DBSEntity> goodCycleTableList = new ArrayList<DBSEntity>();
        for (DBSEntity table : cycleTableList) {
            if (!(table instanceof DBPScriptObjectExt2) || !((DBPScriptObjectExt2)((Object)table)).supportsObjectDefinitionOption("ddl.skipForeignKeys") || !((DBPScriptObjectExt2)((Object)table)).supportsObjectDefinitionOption("ddl.onlyForeignKeys")) continue;
            goodCycleTableList.add(table);
        }
        cycleTableList.removeAll(goodCycleTableList);
        if (!CommonUtils.getOption(options, (String)"ddl.separateForeignKeys", (boolean)true)) {
            for (DBSEntity table : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_definition));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
            }
        } else {
            HashMap<String, Object> optionsNoFK = new HashMap<String, Object>(options);
            optionsNoFK.put("ddl.skipForeignKeys", true);
            for (DBSEntity table : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_definition));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, optionsNoFK, addComments));
            }
            HashMap<String, Object> optionsOnlyFK = new HashMap<String, Object>(options);
            optionsOnlyFK.put("ddl.onlyForeignKeys", true);
            for (DBSEntity table : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_foreign_keys));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, optionsOnlyFK, addComments));
            }
        }
        for (DBSEntity table : cycleTableList) {
            sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_definition));
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        for (DBSEntity table : viewList) {
            sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_source));
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, options, addComments));
        }
        monitor.done();
    }

    private static String getObjectNameComment(@NotNull DBSObject object, @NotNull String comment) {
        DBPDataSource dataSource = object.getDataSource();
        if (dataSource == null) {
            return "";
        }
        if (!dataSource.getContainer().getPreferenceStore().getBoolean("database.meta.extra.ddl.info")) {
            return "";
        }
        Object[] singleLineComments = dataSource.getSQLDialect().getSingleLineComments();
        if (ArrayUtils.isEmpty((Object[])singleLineComments)) {
            return "";
        }
        String lf = GeneralUtils.getDefaultLineSeparator();
        return ((String)singleLineComments[0]).trim() + " " + DBUtils.getObjectFullName(object, DBPEvaluationContext.DDL) + " " + comment + lf + lf;
    }

    private static void addDDLLine(StringBuilder sql, String ddl) {
        if (!CommonUtils.isEmpty((String)(ddl = ddl.trim()))) {
            sql.append(ddl);
            if (!ddl.endsWith(";")) {
                sql.append(";");
            }
            String lf = GeneralUtils.getDefaultLineSeparator();
            sql.append(lf).append(lf).append(lf);
        }
    }

    public static <T extends DBSEntity> void sortTableList(DBRProgressMonitor monitor, Collection<T> input, List<T> simpleTables, List<T> cyclicTables, List<T> views) throws DBException {
        monitor.beginTask("Sorting table list", input.size());
        ArrayList<DBSEntity> realTables = new ArrayList<DBSEntity>();
        for (DBSEntity entity : input) {
            if (entity instanceof DBSView || entity instanceof DBSTable && ((DBSTable)entity).isView()) {
                views.add(entity);
                continue;
            }
            realTables.add(entity);
        }
        SubTaskProgressMonitor proxyMonitor = new SubTaskProgressMonitor(monitor);
        Iterator iterator = realTables.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) break;
            DBSEntity table = (DBSEntity)iterator.next();
            try {
                if (CommonUtils.isEmpty(table.getAssociations(proxyMonitor))) {
                    simpleTables.add(table);
                    iterator.remove();
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
            monitor.worked(1);
        }
        boolean refsFound = true;
        block6: while (refsFound) {
            if (monitor.isCanceled()) break;
            refsFound = false;
            Iterator iterator2 = realTables.iterator();
            while (iterator2.hasNext()) {
                if (monitor.isCanceled()) continue block6;
                DBSEntity table = (DBSEntity)iterator2.next();
                try {
                    boolean allGood = true;
                    for (DBSEntityAssociation ref : CommonUtils.safeCollection(table.getAssociations(proxyMonitor))) {
                        monitor.worked(1);
                        DBSEntity refEntity = ref.getAssociatedEntity();
                        if (refEntity != null && (simpleTables.contains(refEntity) || refEntity == table)) continue;
                        allGood = false;
                        break;
                    }
                    if (!allGood) continue;
                    simpleTables.add(table);
                    iterator2.remove();
                    refsFound = true;
                }
                catch (DBException e) {
                    log.error(e);
                }
            }
        }
        cyclicTables.addAll(realTables);
        monitor.done();
    }

    /*
     * WARNING - void declaration
     */
    public static String mapTargetDataType(@Nullable DBSObject objectContainer, @NotNull DBSTypedObject srcTypedObject, boolean addModifiers) {
        SQLDataTypeConverter dataTypeConverter;
        DBDAttributeBinding attributeBinding;
        boolean isBindingWithEntityAttr = false;
        if (srcTypedObject instanceof DBDAttributeBinding && (attributeBinding = (DBDAttributeBinding)srcTypedObject).getEntityAttribute() != null) {
            isBindingWithEntityAttr = true;
        }
        if (objectContainer != null && (srcTypedObject instanceof DBSEntityAttribute || isBindingWithEntityAttr || srcTypedObject instanceof DBSObject && objectContainer.getDataSource() == ((DBSObject)((Object)srcTypedObject)).getDataSource())) {
            DBPDataSource srcDataSource = ((DBSObject)((Object)srcTypedObject)).getDataSource();
            assert (srcDataSource != null);
            DBPDataSource tgtDataSource = objectContainer.getDataSource();
            assert (tgtDataSource != null);
            if (srcDataSource.getClass() == tgtDataSource.getClass() && addModifiers) {
                return srcTypedObject.getFullTypeName();
            }
        }
        SQLDataTypeConverter sQLDataTypeConverter = dataTypeConverter = objectContainer == null || objectContainer.getDataSource() == null ? null : DBUtils.getAdapter(SQLDataTypeConverter.class, objectContainer.getDataSource().getSQLDialect());
        if (dataTypeConverter != null && srcTypedObject instanceof DBSObject) {
            DBPDataSource srcDataSource = ((DBSObject)((Object)srcTypedObject)).getDataSource();
            assert (srcDataSource != null);
            DBPDataSource tgtDataSource = objectContainer.getDataSource();
            String targetTypeName = dataTypeConverter.convertExternalDataType(srcDataSource.getSQLDialect(), srcTypedObject, DBUtils.getAdapter(DBPDataTypeProvider.class, tgtDataSource));
            if (targetTypeName != null) {
                return targetTypeName;
            }
        }
        Object typeName = srcTypedObject.getTypeName();
        String typeNameLower = ((String)typeName).toLowerCase(Locale.ENGLISH);
        DBPDataKind dataKind = srcTypedObject.getDataKind();
        DBPDataTypeProvider dataTypeProvider = DBUtils.getParentOfType(DBPDataTypeProvider.class, objectContainer);
        if (dataTypeProvider != null) {
            DBSDataType dataType = dataTypeProvider.getLocalDataType((String)typeName);
            if (dataType == null && ((String)typeName).contains("(") && (dataType = dataTypeProvider.getLocalDataType(SQLUtils.stripColumnTypeModifiers((String)typeName))) != null) {
                int startPos = ((String)typeName).indexOf("(");
                typeName = String.valueOf(dataType) + ((String)typeName).substring(startPos);
            }
            if (dataType == null && typeNameLower.equals(DOUBLE_DATA_TYPE) && (dataType = dataTypeProvider.getLocalDataType("DOUBLE PRECISION")) != null) {
                typeName = dataType.getTypeName();
            }
            if (dataType != null && !DBPDataKind.canConsume(dataKind, dataType.getDataKind())) {
                dataType = null;
            }
            if (dataType == null) {
                void var10_28;
                void var10_26;
                void var10_24;
                LinkedHashMap<String, DBSDataType> possibleTypes = new LinkedHashMap<String, DBSDataType>();
                for (DBSDataType dBSDataType : dataTypeProvider.getLocalDataTypes()) {
                    if (!DBPDataKind.canConsume(dBSDataType.getDataKind(), dataKind)) continue;
                    possibleTypes.put(dBSDataType.getTypeName().toLowerCase(Locale.ENGLISH), dBSDataType);
                }
                Object var10_14 = null;
                if (!possibleTypes.isEmpty()) {
                    DBSDataType dBSDataType = (DBSDataType)possibleTypes.get(typeNameLower);
                    if (dBSDataType == null && dataKind == DBPDataKind.NUMERIC) {
                        void var10_17;
                        for (Map.Entry type : possibleTypes.values()) {
                            if (!CommonUtils.equalObjects((Object)type.getScale(), (Object)srcTypedObject.getScale()) || !CommonUtils.equalObjects((Object)type.getPrecision(), (Object)srcTypedObject.getPrecision())) continue;
                            Map.Entry entry = type;
                            break;
                        }
                        if (var10_17 == null) {
                            if (typeNameLower.contains(FLOAT_DATA_TYPE) || typeNameLower.contains(REAL_DATA_TYPE) || srcTypedObject.getScale() != null && srcTypedObject.getScale() > 0 && srcTypedObject.getScale() <= 6) {
                                for (String psn : possibleTypes.keySet()) {
                                    if (!psn.contains(FLOAT_DATA_TYPE) && !psn.contains(REAL_DATA_TYPE)) continue;
                                    DBSDataType dBSDataType2 = (DBSDataType)possibleTypes.get(psn);
                                    break;
                                }
                            } else if (typeNameLower.contains(DOUBLE_DATA_TYPE) || srcTypedObject.getScale() != null && srcTypedObject.getScale() > 0 && srcTypedObject.getScale() <= 15) {
                                for (String psn : possibleTypes.keySet()) {
                                    if (!psn.contains(DOUBLE_DATA_TYPE)) continue;
                                    DBSDataType dBSDataType3 = (DBSDataType)possibleTypes.get(psn);
                                    break;
                                }
                            } else if (INT_DATA_TYPE.equals(typeNameLower) && possibleTypes.get(INTEGER_DATA_TYPE) != null || INTEGER_DATA_TYPE.equals(typeNameLower) && possibleTypes.get(INT_DATA_TYPE) != null) {
                                DBSDataType dBSDataType4 = INT_DATA_TYPE.equals(typeNameLower) ? (DBSDataType)possibleTypes.get(INTEGER_DATA_TYPE) : (DBSDataType)possibleTypes.get(INT_DATA_TYPE);
                            } else if (typeNameLower.contains(INT_DATA_TYPE)) {
                                for (String psn : possibleTypes.keySet()) {
                                    if (!psn.contains(INT_DATA_TYPE)) continue;
                                    DBSDataType dBSDataType5 = (DBSDataType)possibleTypes.get(psn);
                                    break;
                                }
                            }
                        }
                    } else if (dBSDataType == null && dataKind == DBPDataKind.STRING && (typeNameLower.contains(TEXT_DATA_TYPE) || srcTypedObject.getMaxLength() <= 0L)) {
                        if (possibleTypes.containsKey(TEXT_DATA_TYPE)) {
                            DBSDataType dBSDataType6 = (DBSDataType)possibleTypes.get(TEXT_DATA_TYPE);
                        } else {
                            for (Map.Entry type : possibleTypes.entrySet()) {
                                if (!((String)type.getKey()).endsWith(TEXT_DATA_TYPE) || ((DBSDataType)type.getValue()).getDataKind() != DBPDataKind.STRING) continue;
                                DBSDataType dBSDataType7 = (DBSDataType)type.getValue();
                                break;
                            }
                        }
                    }
                }
                if (var10_24 == null) {
                    typeName = DBUtils.getDefaultDataTypeName(objectContainer, dataKind);
                    typeNameLower = ((String)typeName).toLowerCase(Locale.ENGLISH);
                    if (!possibleTypes.isEmpty()) {
                        DBSDataType dBSDataType = (DBSDataType)possibleTypes.get(typeNameLower);
                    }
                }
                if (var10_26 == null && !possibleTypes.isEmpty()) {
                    DBSDataType dBSDataType = (DBSDataType)possibleTypes.values().iterator().next();
                }
                if (var10_28 != null) {
                    typeName = var10_28.getTypeName();
                }
            }
            if (dataType != null) {
                dataKind = dataType.getDataKind();
                if (((String)typeName).equalsIgnoreCase(dataType.getTypeName())) {
                    typeName = dataType.getTypeName();
                }
            }
        }
        if (addModifiers && objectContainer != null) {
            SQLDialect dialect = objectContainer.getDataSource().getSQLDialect();
            String modifiers = dialect.getColumnTypeModifiers((DBPDataSource)objectContainer, srcTypedObject, (String)typeName, dataKind);
            if (modifiers != null) {
                typeName = (String)typeName + modifiers;
            } else if (VARCHAR_DATA_TYPE.equals(typeNameLower) || VARCHAR2_DATA_TYPE.equals(typeNameLower)) {
                typeName = (String)typeName + "(100)";
            }
        }
        return typeName;
    }

    public static String getAttributeName(@NotNull DBSAttributeBase attribute) {
        return DBStructUtils.getAttributeName(attribute, DBPAttributeReferencePurpose.UNSPECIFIED);
    }

    public static String getAttributeName(@NotNull DBSAttributeBase attribute, DBPAttributeReferencePurpose purpose) {
        DBSEntityAttribute entityAttribute;
        if (attribute instanceof DBDAttributeBindingMeta && (entityAttribute = ((DBDAttributeBindingMeta)attribute).getEntityAttribute()) != null) {
            attribute = entityAttribute;
        }
        return DBUtils.isPseudoAttribute(attribute) ? attribute.getName() : DBUtils.getObjectFullName(attribute, DBPEvaluationContext.DML);
    }
}

