/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletionInfo;
import org.jkiss.dbeaver.model.sql.SQLBlockCompletions;

public class SQLBlockCompletionsCollection
implements SQLBlockCompletions {
    private static final Predicate<String> RECOGNIZABLE_TOKEN_PATTERN = Pattern.compile("^\\w+$").asMatchPredicate();
    private final Map<String, Integer> tokenIdByString = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
    private final List<String> tokenStringById = new ArrayList<String>();
    private final Map<Integer, SQLBlockCompletionInfo> blockCompletionByHeadToken = new HashMap<Integer, SQLBlockCompletionInfo>();
    private final Map<Integer, Map<Integer, Set<SQLBlockCompletionInfo>>> blockCompletionByTailToken = new HashMap<Integer, Map<Integer, Set<SQLBlockCompletionInfo>>>();

    @Override
    @Nullable
    public SQLBlockCompletionInfo findCompletionByHead(int headTokenId) {
        return this.blockCompletionByHeadToken.get(headTokenId);
    }

    @Nullable
    public String findTokenString(int id) {
        return this.tokenStringById.get(id - 100);
    }

    @Override
    @Nullable
    public Integer findTokenId(@NotNull String str) {
        return this.tokenIdByString.get(str);
    }

    private int obtainTokenId(@NotNull String str) {
        if (!RECOGNIZABLE_TOKEN_PATTERN.test(str)) {
            throw new IllegalArgumentException("Illegal block completion part '" + str + "' while expecting keyword-like token.");
        }
        Integer id = this.tokenIdByString.get(str);
        if (id == null) {
            id = this.tokenStringById.size() + 100;
            this.tokenStringById.add(str);
            this.tokenIdByString.put(str, id);
        }
        return id;
    }

    public void registerCompletionPair(@NotNull String headToken, @NotNull String tailToken) {
        this.registerBlockCompletionInfo(headToken, new String[]{NEW_LINE_COMPLETION_PART, "\t", NEW_LINE_COMPLETION_PART, tailToken, NEW_LINE_COMPLETION_PART}, tailToken, null, null);
    }

    public void registerCompletionPair(@NotNull String headToken, @NotNull String tailToken, @NotNull String tailEndToken) {
        this.registerCompletionInfo(headToken, new String[]{NEW_LINE_COMPLETION_PART, "\t", NEW_LINE_COMPLETION_PART, tailToken + " " + tailEndToken, NEW_LINE_COMPLETION_PART}, tailToken, tailEndToken);
    }

    public void registerCompletionInfo(@NotNull String headToken, @NotNull String[] completionParts, @NotNull String tailToken, @Nullable String tailEndToken) {
        this.registerBlockCompletionInfo(headToken, completionParts, tailToken, tailEndToken, headToken.equalsIgnoreCase(tailEndToken) ? tailToken : null);
    }

    private void registerBlockCompletionInfo(@NotNull String headToken, @NotNull String[] completionParts, @NotNull String tailToken, @Nullable String tailEndToken, @Nullable String prevCancelToken) {
        if (headToken == null || completionParts == null || tailToken == null) {
            throw new IllegalArgumentException("Illegal block completion info. headToken, completionParts and tailToken are mandatory.");
        }
        SQLBlockCompletionInfo info = new SQLBlockCompletionInfo(this, this.obtainTokenId(headToken), completionParts, this.obtainTokenId(tailToken), tailEndToken == null ? null : Integer.valueOf(this.obtainTokenId(tailEndToken)), prevCancelToken == null ? null : Integer.valueOf(this.obtainTokenId(prevCancelToken)));
        this.blockCompletionByHeadToken.put(info.getHeadTokenId(), info);
        this.blockCompletionByTailToken.computeIfAbsent(info.getTailTokenId(), n -> new HashMap()).computeIfAbsent(info.getTailEndTokenId(), n -> new HashSet()).add(info);
    }
}

