/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFile;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFolder;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOPath;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPath;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.ByteNumberFormat;

public abstract class DBNPathBase
extends DBNNode
implements DBNNodeWithResource,
DBNLazyNode {
    private static final Log log = Log.getLog(DBNPath.class);
    private static final DBNNode[] EMPTY_NODES = new DBNNode[0];
    private static final ByteNumberFormat numberFormat = new ByteNumberFormat();
    private DBNNode[] children;
    private DBPImage resImage;
    private transient Long size;
    private transient FileTime lastModified;

    protected DBNPathBase(DBNNode parentNode) {
        super(parentNode);
    }

    public abstract Path getPath();

    protected abstract void setPath(Path var1);

    @Override
    protected void dispose(boolean reflect) {
        this.children = null;
        super.dispose(reflect);
    }

    @Override
    public IResource getResource() {
        return this.getAdapter(IResource.class);
    }

    @Override
    public DBPImage getResourceImage() {
        return this.resImage;
    }

    @Override
    public void setResourceImage(DBPImage resourceImage) {
        this.resImage = resourceImage;
    }

    @Override
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name() + ".path";
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    public String getNodeDisplayName() {
        return this.getFileName();
    }

    private String getFileName() {
        return URLDecoder.decode(EFSNIOResource.getPathFileNameOrHost(this.getPath()), StandardCharsets.UTF_8);
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public DBPImage getNodeIcon() {
        if (this.resImage != null) {
            return this.resImage;
        }
        return this.allowsChildren() ? DBIcon.TREE_FOLDER : DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return Files.isDirectory(this.getPath(), new LinkOption[0]);
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && this.allowsChildren()) {
            this.children = this.readChildNodes(monitor);
        }
        return this.children;
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        List<DBNNode> result;
        block13: {
            Path path = this.getPath();
            if (this.allowsChildren() && Files.exists(path, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (Stream<Path> fileList = Files.list(path);){
                        result = fileList.map(this::makeNode).collect(Collectors.toList());
                        break block13;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new DBException("Error reading directory members", e);
                }
            }
            result = Collections.emptyList();
        }
        if (result.isEmpty()) {
            return EMPTY_NODES;
        }
        this.filterChildren(result);
        DBNNode[] childNodes = result.toArray(new DBNNode[0]);
        this.sortChildren(childNodes);
        return childNodes;
    }

    public DBNPathBase getChild(Path thePath) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child instanceof DBNPathBase && thePath.equals(((DBNPathBase)child).getPath())) {
                return (DBNPathBase)child;
            }
            ++n2;
        }
        return null;
    }

    public DBNPathBase getChild(String name) {
        if (this.children == null) {
            return null;
        }
        DBNNode[] dBNNodeArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNNode child = dBNNodeArray[n2];
            if (child.getName().equals(name)) {
                return (DBNPathBase)child;
            }
            ++n2;
        }
        return null;
    }

    public void addChildResource(Path path) {
        if (this.children == null) {
            return;
        }
        DBNPath child = new DBNPath(this, path);
        this.children = (DBNNode[])ArrayUtils.add(DBNNode.class, (Object[])this.children, (Object)child);
        this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, child));
    }

    public void removeChildResource(Path path) {
        if (this.children == null) {
            return;
        }
        DBNPathBase child = this.getChild(path);
        if (child != null) {
            this.children = (DBNNode[])ArrayUtils.remove(DBNNode.class, (Object[])this.children, (Object)child);
            this.fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, child));
        }
    }

    private DBNPathBase makeNode(Path resource) {
        return new DBNPath(this, resource);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.children = null;
        this.size = null;
        this.lastModified = null;
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, DBNEvent.NodeChange.REFRESH, this));
        return this;
    }

    @Override
    @Deprecated
    public String getNodeItemPath() {
        return this.getParentNode().getNodeItemPath() + "/" + this.getName();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        Path path = this.getPath();
        try {
            this.setPath(Files.move(path, path.getParent().resolve(newName), new CopyOption[0]));
        }
        catch (IOException e) {
            throw new DBException("Can't rename resource", e);
        }
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        if (otherNode == null) {
            return true;
        }
        if (Files.isRegularFile(this.getPath(), new LinkOption[0])) {
            return this.getParentNode().supportsDrop(otherNode);
        }
        return otherNode.getAdapter(IResource.class) != null && otherNode != this && otherNode.getParentNode() != this && !this.isChildOf(otherNode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        IResource thisResource = this.getResource();
        IContainer folder = thisResource instanceof IContainer ? (IContainer)thisResource : thisResource.getParent();
        if (!(folder instanceof IFolder)) {
            throw new DBException("Can't drop files into non-folder");
        }
        if (nodes.isEmpty()) {
            return;
        }
        boolean doCopy = !this.isTheSameFileSystem(nodes.iterator().next());
        String action = (doCopy ? "Copy" : "Move") + " resource(s)";
        String message = action + "\n" + nodes.stream().map(DBNNode::getNodeDisplayName).collect(Collectors.joining(",")) + "\ninto folder " + String.valueOf(folder.getFullPath()) + "?";
        if (!DBWorkbench.getPlatformUI().confirmAction(action, message)) {
            return;
        }
        monitor.beginTask("Drop files", nodes.size());
        try {
            try {
                for (DBNNode node : nodes) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    IResource resource = node.getAdapter(IResource.class);
                    if (resource == null || !resource.exists()) {
                        log.debug("Resource " + String.valueOf(resource) + " doesn't not exists");
                        continue;
                    }
                    if (!(resource instanceof IFile)) {
                        log.debug("Resource " + String.valueOf(resource) + " is not a file");
                        continue;
                    }
                    if (resource.getParent().equals((Object)folder)) continue;
                    boolean doCopy2 = !this.isTheSameFileSystem(node);
                    boolean doDelete = false;
                    monitor.subTask((doCopy2 ? "Copy" : "Move") + " file " + resource.getName());
                    try {
                        IFile targetFile = ((IFolder)folder).getFile(resource.getName());
                        if (!doCopy2) {
                            boolean wasMoved = false;
                            IFile iFile = targetFile;
                            if (iFile instanceof EFSNIOFile) {
                                void nioFile;
                                EFSNIOFile cfr_ignored_0 = (EFSNIOFile)iFile;
                                EFSNIOFile cfr_ignored_1 = (EFSNIOFile)iFile;
                                EFSNIOPath nioTargetPath = new EFSNIOPath(nioFile.getNioPath());
                                try {
                                    resource.move((IPath)nioTargetPath, true, monitor.getNestedMonitor());
                                    wasMoved = true;
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    log.debug("Underlying FS doesn't support file move. Do copy instead");
                                }
                            }
                            if (!wasMoved) {
                                doCopy2 = true;
                                doDelete = true;
                            }
                        }
                        if (doCopy2) {
                            Throwable throwable = null;
                            EFSNIOFile eFSNIOFile = null;
                            try (InputStream is = ((IFile)resource).getContents();){
                                if (targetFile.exists()) {
                                    targetFile.setContents(is, true, false, monitor.getNestedMonitor());
                                } else {
                                    targetFile.create(is, true, monitor.getNestedMonitor());
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        if (!doDelete) continue;
                        resource.delete(true, monitor.getNestedMonitor());
                    }
                    finally {
                        monitor.worked(1);
                    }
                }
            }
            catch (Exception e) {
                throw new DBException("Error creating NIO resource", e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isTheSameFileSystem(DBNNode node) {
        return false;
    }

    protected void filterChildren(List<DBNNode> list) {
    }

    protected void sortChildren(DBNNode[] list) {
        Arrays.sort(list, (o1, o2) -> {
            if (o1 instanceof DBNPathBase && o2 instanceof DBNPathBase) {
                Path res1 = ((DBNPathBase)o1).getPath();
                Path res2 = ((DBNPathBase)o2).getPath();
                if (res1 instanceof IFolder && !(res2 instanceof IFolder)) {
                    return -1;
                }
                if (res2 instanceof IFolder && !(res1 instanceof IFolder)) {
                    return 1;
                }
            }
            return o1.getNodeDisplayName().compareToIgnoreCase(o2.getNodeDisplayName());
        });
    }

    public Collection<DBPDataSourceContainer> getAssociatedDataSources() {
        return Collections.emptyList();
    }

    public void refreshResourceState(Object source) {
        this.fireNodeEvent(new DBNEvent(source, DBNEvent.Action.UPDATE, this));
    }

    @Property(viewable=true, order=10)
    public String getResourcePath() {
        return this.getPath() == null ? "" : this.getPath().toAbsolutePath().toString();
    }

    @Property(viewable=false, order=11)
    public String getResourceLocation() {
        return this.getPath() == null ? "" : this.getPath().toString();
    }

    @Property(viewable=true, order=11)
    public String getResourceSize() throws IOException {
        if (this.size == null) {
            try {
                this.size = this.getPath() == null ? 0L : Files.size(this.getPath());
            }
            catch (IOException e) {
                log.debug("Error reading file '" + String.valueOf(this.getPath()) + "' size", e);
            }
            if (this.size == null) {
                this.size = 0L;
            }
        }
        return numberFormat.format((Object)this.size);
    }

    @Property(viewable=true, order=11)
    public String getResourceLastModified() throws IOException {
        if (this.lastModified == null) {
            this.lastModified = Files.getLastModifiedTime(this.getPath(), new LinkOption[0]);
        }
        if (this.lastModified.toMillis() <= 0L) {
            return null;
        }
        return this.lastModified.toString();
    }

    protected boolean isResourceExists() {
        return this.getPath() != null && Files.exists(this.getPath(), new LinkOption[0]);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Path.class) {
            return adapter.cast(this.getPath());
        }
        if (adapter == IResource.class) {
            DBNFileSystemRoot rootNode;
            DBNFileSystemRoot dBNFileSystemRoot = rootNode = this instanceof DBNFileSystemRoot ? (DBNFileSystemRoot)this : DBNUtils.getParentOfType(DBNFileSystemRoot.class, this);
            if (rootNode == null) {
                return null;
            }
            DBFVirtualFileSystemRoot fsRoot = rootNode.getRoot();
            EFSNIOFileSystemRoot root = new EFSNIOFileSystemRoot(this.getOwnerProject().getEclipseProject(), fsRoot, fsRoot.getFileSystem().getType() + "/" + fsRoot.getFileSystem().getId() + "/" + fsRoot.getRootId());
            Path path = this.getPath();
            EFSNIOResource resource = this.allowsChildren() ? new EFSNIOFolder(root, path) : new EFSNIOFile(root, path);
            return adapter.cast(resource);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String toString() {
        Path path = this.getPath();
        return path == null ? super.toString() : path.toString();
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }

    @Override
    public boolean isRemoteResource() {
        return true;
    }
}

