/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObjectLocalized;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class DBNNode
implements DBPNamedObject,
DBPNamedObjectLocalized,
DBPObjectWithDescription,
DBPPersistedObject,
DBPAdaptable {
    static final Log log = Log.getLog(DBNNode.class);
    protected final DBNNode parentNode;

    protected DBNNode() {
        this.parentNode = null;
    }

    protected DBNNode(DBNNode parentNode) {
        this.parentNode = parentNode;
    }

    public boolean isDisposed() {
        return false;
    }

    protected void dispose(boolean reflect) {
    }

    public DBNModel getModel() {
        return this.parentNode == null ? null : this.parentNode.getModel();
    }

    public DBNNode getParentNode() {
        return this.parentNode;
    }

    public boolean isLocked() {
        return this.getParentNode() != null && this.getParentNode().isLocked();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    public boolean isManagable() {
        return false;
    }

    @NotNull
    public String getNodeId() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getName() {
        return this.getNodeDisplayName();
    }

    public abstract String getNodeDisplayName();

    protected String getSortName() {
        return this.getNodeDisplayName();
    }

    @Override
    public String getLocalizedName(String locale) {
        return this.getName();
    }

    public abstract String getNodeType();

    public String getNodeTypeLabel() {
        return this.getNodeType();
    }

    @Nullable
    public String getNodeBriefInfo() {
        return null;
    }

    public abstract String getNodeDescription();

    public abstract DBPImage getNodeIcon();

    @Override
    @Nullable
    public String getDescription() {
        return this.getNodeDescription();
    }

    @NotNull
    public DBPImage getNodeIconDefault() {
        DBPImage image = this.getNodeIcon();
        if (image == null) {
            if (this.hasChildren(false)) {
                return DBIcon.TREE_FOLDER;
            }
            return DBIcon.TREE_PAGE;
        }
        return image;
    }

    public String getNodeFullName() {
        StringBuilder pathName = new StringBuilder();
        pathName.append(this.getNodeDisplayName());
        DBNNode parent = this.getParentNode();
        while (parent != null && !(parent instanceof DBNDataSource)) {
            String parentName;
            if (!(parent instanceof DBNDatabaseFolder) && !CommonUtils.isEmpty((String)(parentName = parent.getNodeDisplayName()))) {
                pathName.insert(0, '.').insert(0, parentName);
            }
            parent = parent.getParentNode();
        }
        return pathName.toString();
    }

    public String getNodeTargetName() {
        return this.getNodeDisplayName();
    }

    public boolean hasChildren(boolean navigableOnly) {
        return navigableOnly ? this.allowsNavigableChildren() : this.allowsChildren();
    }

    protected abstract boolean allowsChildren();

    protected boolean allowsNavigableChildren() {
        return this.allowsChildren();
    }

    public abstract DBNNode[] getChildren(DBRProgressMonitor var1) throws DBException;

    void clearNode(boolean reflect) {
    }

    public boolean supportsRename() {
        return false;
    }

    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        throw new DBException("Rename is not supported");
    }

    public boolean supportsDrop(DBNNode otherNode) {
        return false;
    }

    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        throw new DBException("Drop is not supported");
    }

    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.getParentNode() != null) {
            return this.getParentNode().refreshNode(monitor, source);
        }
        return null;
    }

    public boolean allowsOpen() {
        return true;
    }

    public boolean isChildOf(DBNNode node) {
        DBNNode parent = this.getParentNode();
        while (parent != null) {
            if (parent == node) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    public boolean isFiltered() {
        return false;
    }

    @Deprecated
    public abstract String getNodeItemPath();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNodeUri() {
        StringBuilder pathBuilder = new StringBuilder();
        DBNNode currentNode = this;
        while (currentNode != null && !(currentNode instanceof DBNRoot)) {
            if (!pathBuilder.isEmpty()) {
                pathBuilder.insert(0, '/');
            }
            Object nodeId = DBNUtils.encodeNodePath(currentNode.getNodeId());
            if (currentNode instanceof DBNResource && currentNode.getParentNode() instanceof DBNProject) {
                nodeId = "resources/" + (String)nodeId;
            }
            pathBuilder.insert(0, (String)nodeId);
            DBNNode dBNNode = currentNode;
            if (dBNNode instanceof DBNLocalFolder) {
                void folder;
                DBNLocalFolder cfr_ignored_0 = (DBNLocalFolder)dBNNode;
                DBNLocalFolder cfr_ignored_1 = (DBNLocalFolder)dBNNode;
                currentNode = folder.getLogicalParent();
                continue;
            }
            currentNode = currentNode.getParentNode();
        }
        return NodePathType.node.getPrefix() + String.valueOf(pathBuilder);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        IProject.class.isAssignableFrom(adapter);
        return null;
    }

    @Nullable
    public DBPProject getOwnerProject() {
        DBNNode node = this.getParentNode();
        while (node != null) {
            if (node instanceof DBNProject) {
                return ((DBNProject)node).getProject();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public Throwable getLastLoadError() {
        return null;
    }

    static void sortNodes(List<? extends DBNNode> nodes) {
        nodes.sort((o1, o2) -> {
            boolean isFolder1 = o1 instanceof DBNLocalFolder;
            boolean isFolder2 = o2 instanceof DBNLocalFolder;
            if (isFolder1 && !isFolder2) {
                return -1;
            }
            if (!isFolder1 && isFolder2) {
                return 1;
            }
            return o1.getSortName().compareToIgnoreCase(o2.getSortName());
        });
    }

    protected void fireNodeEvent(DBNEvent event) {
        this.getModel().fireNodeEvent(event);
    }

    public static Class<? extends DBSObject> getFolderChildrenClass(DBXTreeFolder meta) {
        String itemsType = CommonUtils.toString((Object)meta.getType());
        if (CommonUtils.isEmpty((String)itemsType)) {
            return null;
        }
        Class<DBSObject> aClass = meta.getSource().getObjectClass(itemsType, DBSObject.class);
        if (aClass == null) {
            log.error("Items class '" + itemsType + "' not found");
            return null;
        }
        if (!DBSObject.class.isAssignableFrom(aClass)) {
            log.error("Class '" + aClass.getName() + "' doesn't extend DBSObject");
            return null;
        }
        return aClass;
    }

    public static boolean nodeHasStructureContainers(DBNNode node, DBXTreeNode meta) {
        List<DBXTreeNode> children = meta.getChildren(node);
        if (!CommonUtils.isEmpty(children)) {
            for (DBXTreeNode child : children) {
                Class<? extends DBSObject> childrenClass;
                if (!(child instanceof DBXTreeFolder) || (childrenClass = DBNNode.getFolderChildrenClass((DBXTreeFolder)child)) == null || !DBSObjectContainer.class.isAssignableFrom(childrenClass)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getNodeUri();
    }

    public static enum NodePathType {
        resource,
        dbvfs,
        folder,
        database,
        ext,
        other,
        node;


        public String getPrefix() {
            return this.name() + "://";
        }
    }
}

