/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DBNDataSource
extends DBNDatabaseNode
implements DBNContainer,
DBPAdaptable {
    private static final boolean USE_ICON_DECORATIONS = false;
    private final DBPDataSourceContainer dataSource;
    private DBXTreeNode treeRoot;

    public DBNDataSource(@NotNull DBNNode parentNode, @NotNull DBPDataSourceContainer dataSource) {
        super(parentNode);
        this.dataSource = dataSource;
        this.treeRoot = dataSource.getDriver().getNavigatorRoot();
        this.registerNode();
    }

    @Override
    public DBNNode getParentNode() {
        DBNLocalFolder localFolder;
        DBPDataSourceFolder folder = this.dataSource.getFolder();
        if (folder != null && (localFolder = ((DBNProjectDatabases)super.getParentNode()).getFolderNode(folder)) != null) {
            return localFolder;
        }
        return super.getParentNode();
    }

    @Override
    protected void dispose(boolean reflect) {
        this.unregisterNode(reflect);
        super.dispose(reflect);
    }

    @Override
    @Nullable
    public DBPDataSourceContainer getObject() {
        return this.dataSource;
    }

    @Override
    public Object getValueObject() {
        return this.dataSource.getDataSource();
    }

    @Override
    public String getChildrenType() {
        List<DBXTreeNode> metaChildren = this.treeRoot.getChildren(this);
        if (CommonUtils.isEmpty(metaChildren) || metaChildren.size() > 1) {
            return "?";
        }
        return metaChildren.get(0).getChildrenTypeLabel(this.getDataSource(), null);
    }

    @Override
    public Class<?> getChildrenClass() {
        List<DBXTreeNode> metaChildren = this.treeRoot.getChildren(null);
        if (CommonUtils.isEmpty(metaChildren) || metaChildren.size() > 1) {
            return null;
        }
        DBXTreeNode childNode = metaChildren.get(0);
        if (childNode instanceof DBXTreeItem) {
            return this.getChildrenClass((DBXTreeItem)childNode);
        }
        return null;
    }

    @Override
    public String getNodeDisplayName() {
        return this.dataSource.getName();
    }

    @Override
    public String getNodeDescription() {
        return this.dataSource.getDescription();
    }

    @Override
    public String getNodeFullName() {
        return this.getNodeDisplayName();
    }

    @Override
    @Deprecated
    public String getNodeItemPath() {
        return DBNDataSource.makeDataSourceItemPath(this.dataSource);
    }

    @Override
    public boolean isManagable() {
        return true;
    }

    @Override
    @NotNull
    public String getNodeId() {
        return this.dataSource.getId();
    }

    @Override
    public DBXTreeNode getMeta() {
        return this.treeRoot;
    }

    @Override
    protected boolean reloadObject(DBRProgressMonitor monitor, DBSObject object) {
        return false;
    }

    @Override
    public boolean initializeNode(@Nullable DBRProgressMonitor monitor, DBRProgressListener onFinish) throws DBException {
        return DBUtils.initDataSource(monitor, this.dataSource, onFinish);
    }

    @Override
    public DBPImage getNodeIcon() {
        DBPImage image = super.getNodeIcon();
        return image;
    }

    public boolean hasNetworkHandlers() {
        for (DBWHandlerConfiguration handler : this.dataSource.getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNDataSource.class) {
            return adapter.cast(this);
        }
        if (DBPDataSourceContainer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.dataSource);
        }
        return super.getAdapter(adapter);
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSource;
    }

    @Override
    public boolean supportsRename() {
        return true;
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) {
        this.dataSource.setName(newName);
        this.dataSource.persistConfiguration();
        this.dataSource.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this.dataSource, null));
    }

    @Override
    protected void afterChildRead() {
        this.dataSource.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, (DBSObject)this.dataSource, true));
    }

    @Override
    public boolean supportsDrop(DBNNode otherNode) {
        return otherNode == null || otherNode instanceof DBNDataSource || otherNode instanceof DBNLocalFolder && ((DBNLocalFolder)otherNode).getFolder().canMoveTo(this.dataSource.getFolder());
    }

    @Override
    public void dropNodes(DBRProgressMonitor monitor, Collection<DBNNode> nodes) throws DBException {
        DBPDataSourceFolder folder = this.dataSource.getFolder();
        for (DBNNode node : nodes) {
            if (node instanceof DBNDataSource) {
                if (((DBNDataSource)node).moveToFolder(this.getOwnerProject(), folder)) continue;
                return;
            }
            if (!(node instanceof DBNLocalFolder)) continue;
            ((DBNLocalFolder)node).getFolder().setParent(this.dataSource.getFolder());
        }
        DBNModel.updateConfigAndRefreshDatabases(this);
    }

    public boolean moveToFolder(DBPProject project, DBPDataSourceFolder folder) {
        DBPDataSourceFolder oldFolder = this.dataSource.getFolder();
        if (oldFolder == folder) {
            return false;
        }
        this.dataSource.setFolder(folder);
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        DBNNode node = super.refreshNode(monitor, source);
        if (node == this) {
            this.dataSource.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, this.dataSource));
        }
        return node;
    }

    public void cleanupNode() {
        this.clearNode(true);
    }

    @Override
    public String toString() {
        return this.dataSource.toString();
    }

    public static DBNDataSource getDataSourceNode(DBNNode node) {
        DBNNode pn = node;
        while (pn != null) {
            if (pn instanceof DBNDataSource) {
                return (DBNDataSource)pn;
            }
            pn = pn.getParentNode();
        }
        return null;
    }

    @NotNull
    public static String makeDataSourceItemPath(DBPDataSourceContainer dataSource) {
        return DBNNode.NodePathType.database.getPrefix() + DBNUtils.encodeNodePath(dataSource.getId());
    }
}

