/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class SQLForeignKeyManager<OBJECT_TYPE extends AbstractTableConstraint, TABLE_TYPE extends AbstractTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    public static final String OPTION_REF_TABLE = "refTable";
    public static final String OPTION_REF_CONSTRAINT = "refConstraint";
    public static final String OPTION_REF_ATTRIBUTES = "refAttributes";
    public static final String OPTION_OWN_ATTRIBUTES = "ownAttributes";

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        AbstractTable table = (AbstractTable)((AbstractTableConstraint)command.getObject()).getTable();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_foreign_key, "ALTER TABLE " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " ADD " + String.valueOf(this.getNestedDeclaration(monitor, (TABLE_TYPE)table, (DBECommandAbstract<OBJECT_TYPE>)command, options))));
    }

    @Override
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_foreign_key, this.getDropForeignKeyPattern((AbstractTableConstraint)command.getObject()).replace("%TABLE%", ((AbstractTableConstraint)command.getObject()).getTable().getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%CONSTRAINT%", DBUtils.getQuotedIdentifier((DBSObject)command.getObject()))));
    }

    @Override
    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        return this.getNestedDeclarationScript(owner, command, options);
    }

    private StringBuilder getNestedDeclarationScript(TABLE_TYPE owner, DBECommandAbstract<OBJECT_TYPE> command, Map<String, Object> options) {
        AbstractTableConstraint foreignKey = (AbstractTableConstraint)command.getObject();
        boolean legacySyntax = this.isLegacyForeignKeySyntax(owner);
        boolean constraintDuplicated = this.isFKConstraintDuplicated(owner);
        String constraintName = DBUtils.getQuotedIdentifier(foreignKey.getDataSource(), foreignKey.getName());
        StringBuilder decl = new StringBuilder(40);
        if (!legacySyntax || !foreignKey.isPersisted() || constraintDuplicated) {
            decl.append("CONSTRAINT ");
        }
        if (!legacySyntax) {
            decl.append(constraintName).append(" ");
        }
        decl.append(foreignKey.getConstraintType().getName().toUpperCase(Locale.ENGLISH)).append(" (");
        try {
            List columns = ((AbstractTableConstraint)command.getObject()).getAttributeReferences(new VoidProgressMonitor());
            boolean firstColumn = true;
            for (DBSEntityAttributeRef constraintColumn : CommonUtils.safeCollection(columns)) {
                DBSEntityAttribute attribute = constraintColumn.getAttribute();
                if (!firstColumn) {
                    decl.append(",");
                }
                firstColumn = false;
                if (attribute == null) continue;
                decl.append(DBUtils.getQuotedIdentifier(attribute));
            }
        }
        catch (DBException e) {
            log.error("Can't obtain reference attributes", e);
        }
        DBSEntityConstraint refConstraint = ((DBSTableForeignKey)((Object)foreignKey)).getReferencedConstraint();
        String refTableName = refConstraint == null ? "<?>" : DBUtils.getEntityScriptName(refConstraint.getParentObject(), options);
        decl.append(") REFERENCES ").append(refTableName).append("(");
        if (refConstraint instanceof DBSEntityReferrer) {
            try {
                boolean firstColumn = true;
                List<? extends DBSEntityAttributeRef> columns = ((DBSEntityReferrer)refConstraint).getAttributeReferences(new VoidProgressMonitor());
                for (DBSEntityAttributeRef constraintColumn : CommonUtils.safeCollection(columns)) {
                    if (!firstColumn) {
                        decl.append(",");
                    }
                    firstColumn = false;
                    DBSEntityAttribute attribute = constraintColumn.getAttribute();
                    if (attribute == null) continue;
                    decl.append(DBUtils.getQuotedIdentifier(attribute));
                }
            }
            catch (DBException e) {
                log.error("Can't obtain ref constraint reference attributes", e);
            }
        }
        decl.append(")");
        this.appendUpdateDeleteRule(foreignKey, decl);
        if (legacySyntax) {
            decl.append(" CONSTRAINT ").append(constraintName);
        }
        return decl;
    }

    protected void appendUpdateDeleteRule(OBJECT_TYPE foreignKey, StringBuilder decl) {
        DBSForeignKeyModifyRule updateRule;
        DBSForeignKeyModifyRule deleteRule = ((DBSTableForeignKey)foreignKey).getDeleteRule();
        if (deleteRule != null && !CommonUtils.isEmpty((String)deleteRule.getClause())) {
            decl.append(" ON DELETE ").append(deleteRule.getClause());
        }
        if ((updateRule = ((DBSTableForeignKey)foreignKey).getUpdateRule()) != null && !CommonUtils.isEmpty((String)updateRule.getClause())) {
            decl.append(" ON UPDATE ").append(updateRule.getClause());
        }
    }

    protected String getDropForeignKeyPattern(OBJECT_TYPE constraint) {
        return "ALTER TABLE %TABLE% DROP CONSTRAINT %CONSTRAINT%";
    }

    protected String getNewConstraintName(DBRProgressMonitor monitor, OBJECT_TYPE foreignKey) {
        DBSEntityConstraint uniqueKey = ((DBSTableForeignKey)foreignKey).getReferencedConstraint();
        DBSEntity targetTable = uniqueKey == null ? null : uniqueKey.getParentObject();
        AbstractTable table = (AbstractTable)((AbstractTableConstraint)foreignKey).getParentObject();
        String baseName = CommonUtils.escapeIdentifier((String)table.getName()) + "_" + (String)(uniqueKey == null ? "" : CommonUtils.escapeIdentifier((String)targetTable.getName()) + "_") + "FK";
        DBSObjectCache<DBSObject, OBJECT_TYPE> objectsCache = this.getObjectsCache(foreignKey);
        if (objectsCache == null) {
            return baseName;
        }
        int i = 0;
        String constrName;
        OBJECT_TYPE child;
        while ((child = objectsCache.getCachedObject(constrName = DBObjectNameCaseTransformer.transformName(foreignKey.getDataSource(), i == 0 ? baseName : baseName + "_" + i))) != null) {
            ++i;
        }
        return constrName;
    }

    @NotNull
    public static String generateConstraintName(DBSEntity table, DBSEntityConstraint uniqueKey) {
        DBSEntity targetTable = uniqueKey == null ? null : uniqueKey.getParentObject();
        return CommonUtils.escapeIdentifier((String)table.getName()) + "_" + (String)(uniqueKey == null ? "" : CommonUtils.escapeIdentifier((String)targetTable.getName()) + "_") + "FK";
    }

    protected <T extends DBSEntityConstraint> T getReferencedKey(DBRProgressMonitor monitor, TABLE_TYPE table, Class<T> refKeyClass, Map<String, Object> options) {
        Object refAttrs;
        Object refConstraint = options.get(OPTION_REF_CONSTRAINT);
        if (refKeyClass.isInstance(refConstraint)) {
            return (T)((DBSEntityConstraint)refKeyClass.cast(refConstraint));
        }
        Object refTable = options.get(OPTION_REF_TABLE);
        if (refTable instanceof DBSEntity && (refAttrs = options.get(OPTION_REF_ATTRIBUTES)) instanceof Collection) {
            try {
                DBSEntityConstraint entityConstraint = DBUtils.findEntityConstraint(monitor, (DBSEntity)refTable, (Collection)refAttrs);
                if (refKeyClass.isInstance(entityConstraint)) {
                    return (T)((DBSEntityConstraint)refKeyClass.cast(entityConstraint));
                }
            }
            catch (DBException e) {
                log.debug("Error searchign constraint by attributes", e);
            }
        }
        return null;
    }

    protected boolean isLegacyForeignKeySyntax(TABLE_TYPE owner) {
        return false;
    }

    protected boolean isFKConstraintDuplicated(TABLE_TYPE owner) {
        return false;
    }

    public static <FK extends AbstractTableConstraint> void updateForeignKeyName(@NotNull DBRProgressMonitor monitor, @NotNull FK foreignKey) {
        SQLForeignKeyManager objectManager = DBWorkbench.getPlatform().getEditorsRegistry().getObjectManager(foreignKey.getClass(), SQLForeignKeyManager.class);
        if (objectManager == null) {
            log.debug("Foreign key manager not found for " + foreignKey.getClass().getName());
        } else {
            String fkName = objectManager.getNewConstraintName(monitor, foreignKey);
            foreignKey.setName(fkName);
        }
    }
}

