/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPImageProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingNested;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeBindingType
extends DBDAttributeBindingNested
implements DBPImageProvider {
    private static final Log log = Log.getLog(DBDAttributeBindingType.class);
    @NotNull
    private final DBSAttributeBase attribute;
    private List<DBSEntityReferrer> referrers;
    private int ordinalPosition;

    public DBDAttributeBindingType(@NotNull DBDAttributeBinding parent, @NotNull DBSAttributeBase attribute, int ordinalPosition) {
        super(parent, DBUtils.findValueHandler(parent.getDataSource(), (DBSTypedObject)attribute));
        this.attribute = attribute;
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    public int getOrdinalPosition() {
        return this.ordinalPosition < 0 ? this.attribute.getOrdinalPosition() : this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    public boolean isRequired() {
        return this.attribute.isRequired();
    }

    @Override
    public boolean isAutoGenerated() {
        return this.attribute.isAutoGenerated();
    }

    @Override
    public boolean isPseudoAttribute() {
        return false;
    }

    @Override
    @Nullable
    public DBSObject getSource() {
        if (this.attribute instanceof DBSObject) {
            return ((DBSObject)((Object)this.attribute)).getParentObject();
        }
        return null;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.attribute.getName();
    }

    @Override
    @Nullable
    public String getEntityName() {
        DBSObject source = this.getSource();
        if (source instanceof DBSEntity) {
            return source.getName();
        }
        return null;
    }

    @Override
    @NotNull
    public String getName() {
        return this.attribute.getName();
    }

    @Override
    @Nullable
    public DBSEntityAttribute getEntityAttribute() {
        if (this.attribute instanceof DBSEntityAttribute) {
            return (DBSEntityAttribute)this.attribute;
        }
        return null;
    }

    @Override
    @Nullable
    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    @Override
    @Nullable
    public Object extractNestedValue(@NotNull Object ownerValue, int itemIndex) throws DBCException {
        assert (this.parent != null);
        if (this.parent.getDataKind() == DBPDataKind.ARRAY && ownerValue instanceof DBDCollection) {
            DBDCollection collection = (DBDCollection)ownerValue;
            if (collection.getItemCount() > itemIndex) {
                ownerValue = collection.getItem(itemIndex);
            } else {
                log.trace("Collection index out of bounds: " + itemIndex);
                return null;
            }
        }
        if (ownerValue instanceof DBDComposite) {
            return ((DBDComposite)ownerValue).getAttributeValue(this.attribute);
        }
        if (ownerValue instanceof Map) {
            return ((Map)ownerValue).get(this.getName());
        }
        if (ownerValue == null) {
            return null;
        }
        DBDAttributeBinding parent = this.getParent(1);
        log.debug("Can't extract field '" + this.getName() + "' from type '" + (parent == null ? null : parent.getName()) + "': wrong value (" + String.valueOf(ownerValue) + ")");
        throw new DBCException(DBValueFormatting.getDefaultValueDisplayString(ownerValue, DBDDisplayFormat.NATIVE));
    }

    @Override
    @Nullable
    public List<DBSEntityReferrer> getReferrers() {
        return this.referrers;
    }

    @Override
    public void lateBinding(@NotNull DBCSession session, List<Object[]> rows) throws DBException {
        this.referrers = this.findVirtualReferrers();
        super.lateBinding(session, rows);
    }

    @Override
    @Nullable
    public DBSDataType getDataType() {
        if (this.attribute instanceof DBSTypedObjectEx) {
            return ((DBSTypedObjectEx)((Object)this.attribute)).getDataType();
        }
        return super.getDataType();
    }

    @Override
    @Nullable
    public DBPImage getObjectImage() {
        return DBValueFormatting.getObjectImage(this.attribute);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.attribute.getTypeName();
    }

    @Override
    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this.attribute);
    }

    @Override
    public int getTypeID() {
        return this.attribute.getTypeID();
    }

    @Override
    @NotNull
    public DBPDataKind getDataKind() {
        return this.attribute.getDataKind();
    }

    @Override
    public Integer getScale() {
        return this.attribute.getScale();
    }

    @Override
    @Nullable
    public Integer getPrecision() {
        return this.attribute.getPrecision();
    }

    @Override
    public long getMaxLength() {
        return this.attribute.getMaxLength();
    }

    @Override
    public long getTypeModifiers() {
        return this.attribute.getTypeModifiers();
    }

    @Override
    public String toString() {
        return this.attribute.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof DBDAttributeBindingType && CommonUtils.equalObjects((Object)this.attribute, (Object)((DBDAttributeBindingType)obj).attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }
}

