/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TransactionQueryResult {
    private final List<QueryChunkRow> rows;
    private final QueryChunkHeader header;
    private final QueryChunkTrailer trailer;
    private final JsonSerializer serializer;

    @Stability.Internal
    public TransactionQueryResult(QueryChunkHeader header, List<QueryChunkRow> rows, QueryChunkTrailer trailer, JsonSerializer serializer) {
        this.rows = Objects.requireNonNull(rows);
        this.header = Objects.requireNonNull(header);
        this.trailer = Objects.requireNonNull(trailer);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public List<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> List<T> rowsAs(Class<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (QueryChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public <T> List<T> rowsAs(TypeRef<T> target) {
        ArrayList<T> converted = new ArrayList<T>(this.rows.size());
        for (QueryChunkRow row : this.rows) {
            converted.add(this.serializer.deserialize(target, row.data()));
        }
        return converted;
    }

    public QueryMetaData metaData() {
        return QueryMetaData.from(this.header, this.trailer);
    }

    public String toString() {
        return "TransactionQueryResult{rows=" + this.rows + ", header=" + this.header + ", trailer=" + this.trailer + '}';
    }
}

