/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.manager.user.Role;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Stability.Volatile
@JsonIgnoreProperties(ignoreUnknown=true)
public class RoleAndOrigins {
    private final Role role;
    private final List<Origin> origins;

    @JsonCreator
    public RoleAndOrigins(ObjectNode node) {
        this((Role)Mapper.convertValue((Object)node, Role.class), (List)Mapper.convertValue((Object)node.path("origins"), (TypeReference)new TypeReference<List<Origin>>(){}));
    }

    public RoleAndOrigins(Role role, List<Origin> origins) {
        this.role = Objects.requireNonNull(role);
        this.origins = CbCollections.isNullOrEmpty(origins) ? Collections.singletonList(Origin.USER) : CbCollections.copyToUnmodifiableList(origins);
    }

    public boolean innate() {
        return this.origins.stream().anyMatch(origin -> ((Origin)origin).type.equals("user"));
    }

    public Role role() {
        return this.role;
    }

    public List<Origin> origins() {
        return this.origins;
    }

    public String toString() {
        return this.role + "<-" + this.origins;
    }

    public static class Origin {
        private static final Origin USER = new Origin("user", null);
        private final String type;
        private final Optional<String> name;

        @JsonIgnoreProperties(ignoreUnknown=true)
        public Origin(@JsonProperty(value="type") String type, @JsonProperty(value="name") String name) {
            this.type = Objects.requireNonNull(type);
            this.name = Optional.ofNullable(name);
        }

        public String type() {
            return this.type;
        }

        public Optional<String> name() {
            return this.name;
        }

        public String toString() {
            return this.name.map(name -> this.type + ":" + name).orElse(this.type);
        }
    }
}

