/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import java.util.Optional;

public class WatchQueryIndexesOptions {
    private boolean watchPrimary;
    private String scopeName;
    private String collectionName;

    private WatchQueryIndexesOptions() {
    }

    public static WatchQueryIndexesOptions watchQueryIndexesOptions() {
        return new WatchQueryIndexesOptions();
    }

    public WatchQueryIndexesOptions watchPrimary(boolean watchPrimary) {
        this.watchPrimary = watchPrimary;
        return this;
    }

    public WatchQueryIndexesOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty((String)scopeName, (String)"ScopeName");
        return this;
    }

    public WatchQueryIndexesOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty((String)collectionName, (String)"CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage((String)"If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built {
        Built() {
        }

        public boolean watchPrimary() {
            return WatchQueryIndexesOptions.this.watchPrimary;
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(WatchQueryIndexesOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(WatchQueryIndexesOptions.this.collectionName);
        }
    }
}

