/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetResult;
import java.time.Instant;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

@Stability.Volatile
public class ScanResult {
    private final String id;
    private final byte[] content;
    private final int flags;
    private final long cas;
    private final Optional<Instant> expiry;
    private final Transcoder transcoder;
    private final boolean idOnly;

    @Stability.Internal
    public ScanResult(boolean idOnly, String id, byte[] content, int flags, long cas, Optional<Instant> expiry, Transcoder transcoder) {
        this.id = id;
        this.idOnly = idOnly;
        this.cas = cas;
        this.content = content;
        this.flags = flags;
        this.expiry = expiry;
        this.transcoder = transcoder;
    }

    public String id() {
        return this.id;
    }

    public boolean idOnly() {
        return this.idOnly;
    }

    public long cas() {
        this.requireBody();
        return this.cas;
    }

    public Optional<Instant> expiryTime() {
        this.requireBody();
        return this.expiry;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public JsonArray contentAsArray() {
        return this.contentAs(JsonArray.class);
    }

    public <T> T contentAs(Class<T> target) {
        this.requireBody();
        return this.transcoder.decode(target, this.content, this.flags);
    }

    public <T> T contentAs(TypeRef<T> target) {
        this.requireBody();
        return this.transcoder.decode(target, this.content, this.flags);
    }

    public byte[] contentAsBytes() {
        this.requireBody();
        return this.content;
    }

    private void requireBody() {
        if (this.idOnly) {
            throw new NoSuchElementException("This result came from a scan configured to return only document IDs.");
        }
    }

    public String toString() {
        return "ScanResult{id=" + RedactableArgument.redactMeta((Object)this.id) + ", content=" + RedactableArgument.redactUser((Object)GetResult.convertContentToString(this.content, this.flags)) + ", flags=0x" + Integer.toHexString(this.flags) + ", cas=0x" + Long.toHexString(this.cas) + ", expiry=" + this.expiry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanResult that = (ScanResult)o;
        return this.flags == that.flags && this.cas == that.cas && Objects.equals(this.id, that.id) && Arrays.equals(this.content, that.content) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.transcoder, that.transcoder);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.flags, this.cas, this.expiry, this.transcoder);
        result = 31 * result + Arrays.hashCode(this.content);
        return result;
    }
}

