/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.bigtableadmin.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigtableadmin.v2.BigtableAdminRequest;
import com.google.api.services.bigtableadmin.v2.BigtableAdminRequestInitializer;
import com.google.api.services.bigtableadmin.v2.model.AppProfile;
import com.google.api.services.bigtableadmin.v2.model.Backup;
import com.google.api.services.bigtableadmin.v2.model.CheckConsistencyRequest;
import com.google.api.services.bigtableadmin.v2.model.CheckConsistencyResponse;
import com.google.api.services.bigtableadmin.v2.model.Cluster;
import com.google.api.services.bigtableadmin.v2.model.CopyBackupRequest;
import com.google.api.services.bigtableadmin.v2.model.CreateInstanceRequest;
import com.google.api.services.bigtableadmin.v2.model.CreateTableRequest;
import com.google.api.services.bigtableadmin.v2.model.DropRowRangeRequest;
import com.google.api.services.bigtableadmin.v2.model.Empty;
import com.google.api.services.bigtableadmin.v2.model.GenerateConsistencyTokenRequest;
import com.google.api.services.bigtableadmin.v2.model.GenerateConsistencyTokenResponse;
import com.google.api.services.bigtableadmin.v2.model.GetIamPolicyRequest;
import com.google.api.services.bigtableadmin.v2.model.Instance;
import com.google.api.services.bigtableadmin.v2.model.ListAppProfilesResponse;
import com.google.api.services.bigtableadmin.v2.model.ListBackupsResponse;
import com.google.api.services.bigtableadmin.v2.model.ListClustersResponse;
import com.google.api.services.bigtableadmin.v2.model.ListHotTabletsResponse;
import com.google.api.services.bigtableadmin.v2.model.ListInstancesResponse;
import com.google.api.services.bigtableadmin.v2.model.ListLocationsResponse;
import com.google.api.services.bigtableadmin.v2.model.ListOperationsResponse;
import com.google.api.services.bigtableadmin.v2.model.ListTablesResponse;
import com.google.api.services.bigtableadmin.v2.model.ModifyColumnFamiliesRequest;
import com.google.api.services.bigtableadmin.v2.model.Operation;
import com.google.api.services.bigtableadmin.v2.model.Policy;
import com.google.api.services.bigtableadmin.v2.model.RestoreTableRequest;
import com.google.api.services.bigtableadmin.v2.model.SetIamPolicyRequest;
import com.google.api.services.bigtableadmin.v2.model.Table;
import com.google.api.services.bigtableadmin.v2.model.TestIamPermissionsRequest;
import com.google.api.services.bigtableadmin.v2.model.TestIamPermissionsResponse;
import com.google.api.services.bigtableadmin.v2.model.UndeleteTableRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class BigtableAdmin
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://bigtableadmin.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://bigtableadmin.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://bigtableadmin.googleapis.com/";

    public BigtableAdmin(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    BigtableAdmin(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Bigtable Admin API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return BigtableAdmin.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://bigtableadmin.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), BigtableAdmin.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(BigtableAdmin.DEFAULT_BATCH_PATH);
        }

        public BigtableAdmin build() {
            return new BigtableAdmin(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setBigtableAdminRequestInitializer(BigtableAdminRequestInitializer bigtableadminRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)bigtableadminRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Instances instances() {
            return new Instances();
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public List list(String name) throws IOException {
                List result = new List(name);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends BigtableAdminRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(BigtableAdmin.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Instances {
            public Create create(String parent, CreateInstanceRequest content) throws IOException {
                Create result = new Create(parent, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public PartialUpdateInstance partialUpdateInstance(String name, Instance content) throws IOException {
                PartialUpdateInstance result = new PartialUpdateInstance(name, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String name, Instance content) throws IOException {
                Update result = new Update(name, content);
                BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public AppProfiles appProfiles() {
                return new AppProfiles();
            }

            public Clusters clusters() {
                return new Clusters();
            }

            public Tables tables() {
                return new Tables();
            }

            public class Tables {
                public CheckConsistency checkConsistency(String name, CheckConsistencyRequest content) throws IOException {
                    CheckConsistency result = new CheckConsistency(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, CreateTableRequest content) throws IOException {
                    Create result = new Create(parent, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public DropRowRange dropRowRange(String name, DropRowRangeRequest content) throws IOException {
                    DropRowRange result = new DropRowRange(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GenerateConsistencyToken generateConsistencyToken(String name, GenerateConsistencyTokenRequest content) throws IOException {
                    GenerateConsistencyToken result = new GenerateConsistencyToken(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ModifyColumnFamilies modifyColumnFamilies(String name, ModifyColumnFamiliesRequest content) throws IOException {
                    ModifyColumnFamilies result = new ModifyColumnFamilies(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Table content) throws IOException {
                    Patch result = new Patch(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Restore restore(String parent, RestoreTableRequest content) throws IOException {
                    Restore result = new Restore(parent, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Undelete undelete(String name, UndeleteTableRequest content) throws IOException {
                    Undelete result = new Undelete(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Undelete
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:undelete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Undelete(String name, UndeleteTableRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public Undelete set$Xgafv(String $Xgafv) {
                        return (Undelete)super.set$Xgafv($Xgafv);
                    }

                    public Undelete setAccessToken(String accessToken) {
                        return (Undelete)super.setAccessToken(accessToken);
                    }

                    public Undelete setAlt(String alt) {
                        return (Undelete)super.setAlt(alt);
                    }

                    public Undelete setCallback(String callback) {
                        return (Undelete)super.setCallback(callback);
                    }

                    public Undelete setFields(String fields) {
                        return (Undelete)super.setFields(fields);
                    }

                    public Undelete setKey(String key) {
                        return (Undelete)super.setKey(key);
                    }

                    public Undelete setOauthToken(String oauthToken) {
                        return (Undelete)super.setOauthToken(oauthToken);
                    }

                    public Undelete setPrettyPrint(Boolean prettyPrint) {
                        return (Undelete)super.setPrettyPrint(prettyPrint);
                    }

                    public Undelete setQuotaUser(String quotaUser) {
                        return (Undelete)super.setQuotaUser(quotaUser);
                    }

                    public Undelete setUploadType(String uploadType) {
                        return (Undelete)super.setUploadType(uploadType);
                    }

                    public Undelete setUploadProtocol(String uploadProtocol) {
                        return (Undelete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Undelete setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Undelete set(String parameterName, Object value) {
                        return (Undelete)super.set(parameterName, value);
                    }
                }

                public class TestIamPermissions
                extends BigtableAdminRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v2/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends BigtableAdminRequest<Policy> {
                    private static final String REST_PATH = "v2/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Restore
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+parent}/tables:restore";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Restore(String parent, RestoreTableRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Restore set$Xgafv(String $Xgafv) {
                        return (Restore)super.set$Xgafv($Xgafv);
                    }

                    public Restore setAccessToken(String accessToken) {
                        return (Restore)super.setAccessToken(accessToken);
                    }

                    public Restore setAlt(String alt) {
                        return (Restore)super.setAlt(alt);
                    }

                    public Restore setCallback(String callback) {
                        return (Restore)super.setCallback(callback);
                    }

                    public Restore setFields(String fields) {
                        return (Restore)super.setFields(fields);
                    }

                    public Restore setKey(String key) {
                        return (Restore)super.setKey(key);
                    }

                    public Restore setOauthToken(String oauthToken) {
                        return (Restore)super.setOauthToken(oauthToken);
                    }

                    public Restore setPrettyPrint(Boolean prettyPrint) {
                        return (Restore)super.setPrettyPrint(prettyPrint);
                    }

                    public Restore setQuotaUser(String quotaUser) {
                        return (Restore)super.setQuotaUser(quotaUser);
                    }

                    public Restore setUploadType(String uploadType) {
                        return (Restore)super.setUploadType(uploadType);
                    }

                    public Restore setUploadProtocol(String uploadProtocol) {
                        return (Restore)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Restore setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Restore set(String parameterName, Object value) {
                        return (Restore)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Table content) {
                        super(BigtableAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class ModifyColumnFamilies
                extends BigtableAdminRequest<Table> {
                    private static final String REST_PATH = "v2/{+name}:modifyColumnFamilies";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected ModifyColumnFamilies(String name, ModifyColumnFamiliesRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Table.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public ModifyColumnFamilies set$Xgafv(String $Xgafv) {
                        return (ModifyColumnFamilies)super.set$Xgafv($Xgafv);
                    }

                    public ModifyColumnFamilies setAccessToken(String accessToken) {
                        return (ModifyColumnFamilies)super.setAccessToken(accessToken);
                    }

                    public ModifyColumnFamilies setAlt(String alt) {
                        return (ModifyColumnFamilies)super.setAlt(alt);
                    }

                    public ModifyColumnFamilies setCallback(String callback) {
                        return (ModifyColumnFamilies)super.setCallback(callback);
                    }

                    public ModifyColumnFamilies setFields(String fields) {
                        return (ModifyColumnFamilies)super.setFields(fields);
                    }

                    public ModifyColumnFamilies setKey(String key) {
                        return (ModifyColumnFamilies)super.setKey(key);
                    }

                    public ModifyColumnFamilies setOauthToken(String oauthToken) {
                        return (ModifyColumnFamilies)super.setOauthToken(oauthToken);
                    }

                    public ModifyColumnFamilies setPrettyPrint(Boolean prettyPrint) {
                        return (ModifyColumnFamilies)super.setPrettyPrint(prettyPrint);
                    }

                    public ModifyColumnFamilies setQuotaUser(String quotaUser) {
                        return (ModifyColumnFamilies)super.setQuotaUser(quotaUser);
                    }

                    public ModifyColumnFamilies setUploadType(String uploadType) {
                        return (ModifyColumnFamilies)super.setUploadType(uploadType);
                    }

                    public ModifyColumnFamilies setUploadProtocol(String uploadProtocol) {
                        return (ModifyColumnFamilies)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public ModifyColumnFamilies setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public ModifyColumnFamilies set(String parameterName, Object value) {
                        return (ModifyColumnFamilies)super.set(parameterName, value);
                    }
                }

                public class List
                extends BigtableAdminRequest<ListTablesResponse> {
                    private static final String REST_PATH = "v2/{+parent}/tables";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String view;

                    protected List(String parent) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, ListTablesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public List setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends BigtableAdminRequest<Policy> {
                    private static final String REST_PATH = "v2/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends BigtableAdminRequest<Table> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String view;

                    protected Get(String name) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, Table.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class GenerateConsistencyToken
                extends BigtableAdminRequest<GenerateConsistencyTokenResponse> {
                    private static final String REST_PATH = "v2/{+name}:generateConsistencyToken";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected GenerateConsistencyToken(String name, GenerateConsistencyTokenRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, GenerateConsistencyTokenResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public GenerateConsistencyToken set$Xgafv(String $Xgafv) {
                        return (GenerateConsistencyToken)super.set$Xgafv($Xgafv);
                    }

                    public GenerateConsistencyToken setAccessToken(String accessToken) {
                        return (GenerateConsistencyToken)super.setAccessToken(accessToken);
                    }

                    public GenerateConsistencyToken setAlt(String alt) {
                        return (GenerateConsistencyToken)super.setAlt(alt);
                    }

                    public GenerateConsistencyToken setCallback(String callback) {
                        return (GenerateConsistencyToken)super.setCallback(callback);
                    }

                    public GenerateConsistencyToken setFields(String fields) {
                        return (GenerateConsistencyToken)super.setFields(fields);
                    }

                    public GenerateConsistencyToken setKey(String key) {
                        return (GenerateConsistencyToken)super.setKey(key);
                    }

                    public GenerateConsistencyToken setOauthToken(String oauthToken) {
                        return (GenerateConsistencyToken)super.setOauthToken(oauthToken);
                    }

                    public GenerateConsistencyToken setPrettyPrint(Boolean prettyPrint) {
                        return (GenerateConsistencyToken)super.setPrettyPrint(prettyPrint);
                    }

                    public GenerateConsistencyToken setQuotaUser(String quotaUser) {
                        return (GenerateConsistencyToken)super.setQuotaUser(quotaUser);
                    }

                    public GenerateConsistencyToken setUploadType(String uploadType) {
                        return (GenerateConsistencyToken)super.setUploadType(uploadType);
                    }

                    public GenerateConsistencyToken setUploadProtocol(String uploadProtocol) {
                        return (GenerateConsistencyToken)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GenerateConsistencyToken setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public GenerateConsistencyToken set(String parameterName, Object value) {
                        return (GenerateConsistencyToken)super.set(parameterName, value);
                    }
                }

                public class DropRowRange
                extends BigtableAdminRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:dropRowRange";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected DropRowRange(String name, DropRowRangeRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public DropRowRange set$Xgafv(String $Xgafv) {
                        return (DropRowRange)super.set$Xgafv($Xgafv);
                    }

                    public DropRowRange setAccessToken(String accessToken) {
                        return (DropRowRange)super.setAccessToken(accessToken);
                    }

                    public DropRowRange setAlt(String alt) {
                        return (DropRowRange)super.setAlt(alt);
                    }

                    public DropRowRange setCallback(String callback) {
                        return (DropRowRange)super.setCallback(callback);
                    }

                    public DropRowRange setFields(String fields) {
                        return (DropRowRange)super.setFields(fields);
                    }

                    public DropRowRange setKey(String key) {
                        return (DropRowRange)super.setKey(key);
                    }

                    public DropRowRange setOauthToken(String oauthToken) {
                        return (DropRowRange)super.setOauthToken(oauthToken);
                    }

                    public DropRowRange setPrettyPrint(Boolean prettyPrint) {
                        return (DropRowRange)super.setPrettyPrint(prettyPrint);
                    }

                    public DropRowRange setQuotaUser(String quotaUser) {
                        return (DropRowRange)super.setQuotaUser(quotaUser);
                    }

                    public DropRowRange setUploadType(String uploadType) {
                        return (DropRowRange)super.setUploadType(uploadType);
                    }

                    public DropRowRange setUploadProtocol(String uploadProtocol) {
                        return (DropRowRange)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public DropRowRange setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public DropRowRange set(String parameterName, Object value) {
                        return (DropRowRange)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends BigtableAdminRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(BigtableAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends BigtableAdminRequest<Table> {
                    private static final String REST_PATH = "v2/{+parent}/tables";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, CreateTableRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Table.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class CheckConsistency
                extends BigtableAdminRequest<CheckConsistencyResponse> {
                    private static final String REST_PATH = "v2/{+name}:checkConsistency";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected CheckConsistency(String name, CheckConsistencyRequest content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, CheckConsistencyResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                    }

                    public CheckConsistency set$Xgafv(String $Xgafv) {
                        return (CheckConsistency)super.set$Xgafv($Xgafv);
                    }

                    public CheckConsistency setAccessToken(String accessToken) {
                        return (CheckConsistency)super.setAccessToken(accessToken);
                    }

                    public CheckConsistency setAlt(String alt) {
                        return (CheckConsistency)super.setAlt(alt);
                    }

                    public CheckConsistency setCallback(String callback) {
                        return (CheckConsistency)super.setCallback(callback);
                    }

                    public CheckConsistency setFields(String fields) {
                        return (CheckConsistency)super.setFields(fields);
                    }

                    public CheckConsistency setKey(String key) {
                        return (CheckConsistency)super.setKey(key);
                    }

                    public CheckConsistency setOauthToken(String oauthToken) {
                        return (CheckConsistency)super.setOauthToken(oauthToken);
                    }

                    public CheckConsistency setPrettyPrint(Boolean prettyPrint) {
                        return (CheckConsistency)super.setPrettyPrint(prettyPrint);
                    }

                    public CheckConsistency setQuotaUser(String quotaUser) {
                        return (CheckConsistency)super.setQuotaUser(quotaUser);
                    }

                    public CheckConsistency setUploadType(String uploadType) {
                        return (CheckConsistency)super.setUploadType(uploadType);
                    }

                    public CheckConsistency setUploadProtocol(String uploadProtocol) {
                        return (CheckConsistency)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public CheckConsistency setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/tables/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public CheckConsistency set(String parameterName, Object value) {
                        return (CheckConsistency)super.set(parameterName, value);
                    }
                }
            }

            public class Clusters {
                public Create create(String parent, Cluster content) throws IOException {
                    Create result = new Create(parent, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public PartialUpdateCluster partialUpdateCluster(String name, Cluster content) throws IOException {
                    PartialUpdateCluster result = new PartialUpdateCluster(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Update update(String name, Cluster content) throws IOException {
                    Update result = new Update(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Backups backups() {
                    return new Backups();
                }

                public HotTablets hotTablets() {
                    return new HotTablets();
                }

                public class HotTablets {
                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends BigtableAdminRequest<ListHotTabletsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/hotTablets";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String endTime;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;
                        @Key
                        private String startTime;

                        protected List(String parent) {
                            super(BigtableAdmin.this, "GET", REST_PATH, null, ListHotTabletsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getEndTime() {
                            return this.endTime;
                        }

                        public List setEndTime(String endTime) {
                            this.endTime = endTime;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public String getStartTime() {
                            return this.startTime;
                        }

                        public List setStartTime(String startTime) {
                            this.startTime = startTime;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }
                }

                public class Backups {
                    public Copy copy(String parent, CopyBackupRequest content) throws IOException {
                        Copy result = new Copy(parent, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Create create(String parent, Backup content) throws IOException {
                        Create result = new Create(parent, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                        GetIamPolicy result = new GetIamPolicy(resource, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, Backup content) throws IOException {
                        Patch result = new Patch(name, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                        SetIamPolicy result = new SetIamPolicy(resource, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                        TestIamPermissions result = new TestIamPermissions(resource, content);
                        BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class TestIamPermissions
                    extends BigtableAdminRequest<TestIamPermissionsResponse> {
                        private static final String REST_PATH = "v2/{+resource}:testIamPermissions";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                            super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public TestIamPermissions set$Xgafv(String $Xgafv) {
                            return (TestIamPermissions)super.set$Xgafv($Xgafv);
                        }

                        public TestIamPermissions setAccessToken(String accessToken) {
                            return (TestIamPermissions)super.setAccessToken(accessToken);
                        }

                        public TestIamPermissions setAlt(String alt) {
                            return (TestIamPermissions)super.setAlt(alt);
                        }

                        public TestIamPermissions setCallback(String callback) {
                            return (TestIamPermissions)super.setCallback(callback);
                        }

                        public TestIamPermissions setFields(String fields) {
                            return (TestIamPermissions)super.setFields(fields);
                        }

                        public TestIamPermissions setKey(String key) {
                            return (TestIamPermissions)super.setKey(key);
                        }

                        public TestIamPermissions setOauthToken(String oauthToken) {
                            return (TestIamPermissions)super.setOauthToken(oauthToken);
                        }

                        public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                            return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                        }

                        public TestIamPermissions setQuotaUser(String quotaUser) {
                            return (TestIamPermissions)super.setQuotaUser(quotaUser);
                        }

                        public TestIamPermissions setUploadType(String uploadType) {
                            return (TestIamPermissions)super.setUploadType(uploadType);
                        }

                        public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                            return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public TestIamPermissions setResource(String resource) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public TestIamPermissions set(String parameterName, Object value) {
                            return (TestIamPermissions)super.set(parameterName, value);
                        }
                    }

                    public class SetIamPolicy
                    extends BigtableAdminRequest<Policy> {
                        private static final String REST_PATH = "v2/{+resource}:setIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                            super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public SetIamPolicy set$Xgafv(String $Xgafv) {
                            return (SetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public SetIamPolicy setAccessToken(String accessToken) {
                            return (SetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public SetIamPolicy setAlt(String alt) {
                            return (SetIamPolicy)super.setAlt(alt);
                        }

                        public SetIamPolicy setCallback(String callback) {
                            return (SetIamPolicy)super.setCallback(callback);
                        }

                        public SetIamPolicy setFields(String fields) {
                            return (SetIamPolicy)super.setFields(fields);
                        }

                        public SetIamPolicy setKey(String key) {
                            return (SetIamPolicy)super.setKey(key);
                        }

                        public SetIamPolicy setOauthToken(String oauthToken) {
                            return (SetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public SetIamPolicy setQuotaUser(String quotaUser) {
                            return (SetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public SetIamPolicy setUploadType(String uploadType) {
                            return (SetIamPolicy)super.setUploadType(uploadType);
                        }

                        public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public SetIamPolicy setResource(String resource) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public SetIamPolicy set(String parameterName, Object value) {
                            return (SetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends BigtableAdminRequest<Backup> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String updateMask;

                        protected Patch(String name, Backup content) {
                            super(BigtableAdmin.this, "PATCH", REST_PATH, (Object)content, Backup.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends BigtableAdminRequest<ListBackupsResponse> {
                        private static final String REST_PATH = "v2/{+parent}/backups";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String filter;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(BigtableAdmin.this, "GET", REST_PATH, null, ListBackupsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getFilter() {
                            return this.filter;
                        }

                        public List setFilter(String filter) {
                            this.filter = filter;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class GetIamPolicy
                    extends BigtableAdminRequest<Policy> {
                        private static final String REST_PATH = "v2/{+resource}:getIamPolicy";
                        private final Pattern RESOURCE_PATTERN;
                        @Key
                        private String resource;

                        protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                            super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                            this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public GetIamPolicy set$Xgafv(String $Xgafv) {
                            return (GetIamPolicy)super.set$Xgafv($Xgafv);
                        }

                        public GetIamPolicy setAccessToken(String accessToken) {
                            return (GetIamPolicy)super.setAccessToken(accessToken);
                        }

                        public GetIamPolicy setAlt(String alt) {
                            return (GetIamPolicy)super.setAlt(alt);
                        }

                        public GetIamPolicy setCallback(String callback) {
                            return (GetIamPolicy)super.setCallback(callback);
                        }

                        public GetIamPolicy setFields(String fields) {
                            return (GetIamPolicy)super.setFields(fields);
                        }

                        public GetIamPolicy setKey(String key) {
                            return (GetIamPolicy)super.setKey(key);
                        }

                        public GetIamPolicy setOauthToken(String oauthToken) {
                            return (GetIamPolicy)super.setOauthToken(oauthToken);
                        }

                        public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                            return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                        }

                        public GetIamPolicy setQuotaUser(String quotaUser) {
                            return (GetIamPolicy)super.setQuotaUser(quotaUser);
                        }

                        public GetIamPolicy setUploadType(String uploadType) {
                            return (GetIamPolicy)super.setUploadType(uploadType);
                        }

                        public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                            return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getResource() {
                            return this.resource;
                        }

                        public GetIamPolicy setResource(String resource) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.resource = resource;
                            return this;
                        }

                        @Override
                        public GetIamPolicy set(String parameterName, Object value) {
                            return (GetIamPolicy)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends BigtableAdminRequest<Backup> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(BigtableAdmin.this, "GET", REST_PATH, null, Backup.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends BigtableAdminRequest<Empty> {
                        private static final String REST_PATH = "v2/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String name) {
                            super(BigtableAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+/backups/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends BigtableAdminRequest<Operation> {
                        private static final String REST_PATH = "v2/{+parent}/backups";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String backupId;

                        protected Create(String parent, Backup content) {
                            super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getBackupId() {
                            return this.backupId;
                        }

                        public Create setBackupId(String backupId) {
                            this.backupId = backupId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }

                    public class Copy
                    extends BigtableAdminRequest<Operation> {
                        private static final String REST_PATH = "v2/{+parent}/backups:copy";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Copy(String parent, CopyBackupRequest content) {
                            super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                        }

                        public Copy set$Xgafv(String $Xgafv) {
                            return (Copy)super.set$Xgafv($Xgafv);
                        }

                        public Copy setAccessToken(String accessToken) {
                            return (Copy)super.setAccessToken(accessToken);
                        }

                        public Copy setAlt(String alt) {
                            return (Copy)super.setAlt(alt);
                        }

                        public Copy setCallback(String callback) {
                            return (Copy)super.setCallback(callback);
                        }

                        public Copy setFields(String fields) {
                            return (Copy)super.setFields(fields);
                        }

                        public Copy setKey(String key) {
                            return (Copy)super.setKey(key);
                        }

                        public Copy setOauthToken(String oauthToken) {
                            return (Copy)super.setOauthToken(oauthToken);
                        }

                        public Copy setPrettyPrint(Boolean prettyPrint) {
                            return (Copy)super.setPrettyPrint(prettyPrint);
                        }

                        public Copy setQuotaUser(String quotaUser) {
                            return (Copy)super.setQuotaUser(quotaUser);
                        }

                        public Copy setUploadType(String uploadType) {
                            return (Copy)super.setUploadType(uploadType);
                        }

                        public Copy setUploadProtocol(String uploadProtocol) {
                            return (Copy)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Copy setParent(String parent) {
                            if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Copy set(String parameterName, Object value) {
                            return (Copy)super.set(parameterName, value);
                        }
                    }
                }

                public class Update
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Update(String name, Cluster content) {
                        super(BigtableAdmin.this, "PUT", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Update set$Xgafv(String $Xgafv) {
                        return (Update)super.set$Xgafv($Xgafv);
                    }

                    public Update setAccessToken(String accessToken) {
                        return (Update)super.setAccessToken(accessToken);
                    }

                    public Update setAlt(String alt) {
                        return (Update)super.setAlt(alt);
                    }

                    public Update setCallback(String callback) {
                        return (Update)super.setCallback(callback);
                    }

                    public Update setFields(String fields) {
                        return (Update)super.setFields(fields);
                    }

                    public Update setKey(String key) {
                        return (Update)super.setKey(key);
                    }

                    public Update setOauthToken(String oauthToken) {
                        return (Update)super.setOauthToken(oauthToken);
                    }

                    public Update setPrettyPrint(Boolean prettyPrint) {
                        return (Update)super.setPrettyPrint(prettyPrint);
                    }

                    public Update setQuotaUser(String quotaUser) {
                        return (Update)super.setQuotaUser(quotaUser);
                    }

                    public Update setUploadType(String uploadType) {
                        return (Update)super.setUploadType(uploadType);
                    }

                    public Update setUploadProtocol(String uploadProtocol) {
                        return (Update)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Update setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Update set(String parameterName, Object value) {
                        return (Update)super.set(parameterName, value);
                    }
                }

                public class PartialUpdateCluster
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected PartialUpdateCluster(String name, Cluster content) {
                        super(BigtableAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public PartialUpdateCluster set$Xgafv(String $Xgafv) {
                        return (PartialUpdateCluster)super.set$Xgafv($Xgafv);
                    }

                    public PartialUpdateCluster setAccessToken(String accessToken) {
                        return (PartialUpdateCluster)super.setAccessToken(accessToken);
                    }

                    public PartialUpdateCluster setAlt(String alt) {
                        return (PartialUpdateCluster)super.setAlt(alt);
                    }

                    public PartialUpdateCluster setCallback(String callback) {
                        return (PartialUpdateCluster)super.setCallback(callback);
                    }

                    public PartialUpdateCluster setFields(String fields) {
                        return (PartialUpdateCluster)super.setFields(fields);
                    }

                    public PartialUpdateCluster setKey(String key) {
                        return (PartialUpdateCluster)super.setKey(key);
                    }

                    public PartialUpdateCluster setOauthToken(String oauthToken) {
                        return (PartialUpdateCluster)super.setOauthToken(oauthToken);
                    }

                    public PartialUpdateCluster setPrettyPrint(Boolean prettyPrint) {
                        return (PartialUpdateCluster)super.setPrettyPrint(prettyPrint);
                    }

                    public PartialUpdateCluster setQuotaUser(String quotaUser) {
                        return (PartialUpdateCluster)super.setQuotaUser(quotaUser);
                    }

                    public PartialUpdateCluster setUploadType(String uploadType) {
                        return (PartialUpdateCluster)super.setUploadType(uploadType);
                    }

                    public PartialUpdateCluster setUploadProtocol(String uploadProtocol) {
                        return (PartialUpdateCluster)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public PartialUpdateCluster setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public PartialUpdateCluster setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public PartialUpdateCluster set(String parameterName, Object value) {
                        return (PartialUpdateCluster)super.set(parameterName, value);
                    }
                }

                public class List
                extends BigtableAdminRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v2/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends BigtableAdminRequest<Cluster> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, Cluster.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends BigtableAdminRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(BigtableAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/clusters/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+parent}/clusters";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String clusterId;

                    protected Create(String parent, Cluster content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getClusterId() {
                        return this.clusterId;
                    }

                    public Create setClusterId(String clusterId) {
                        this.clusterId = clusterId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class AppProfiles {
                public Create create(String parent, AppProfile content) throws IOException {
                    Create result = new Create(parent, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, AppProfile content) throws IOException {
                    Patch result = new Patch(name, content);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends BigtableAdminRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean ignoreWarnings;
                    @Key
                    private String updateMask;

                    protected Patch(String name, AppProfile content) {
                        super(BigtableAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getIgnoreWarnings() {
                        return this.ignoreWarnings;
                    }

                    public Patch setIgnoreWarnings(Boolean ignoreWarnings) {
                        this.ignoreWarnings = ignoreWarnings;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends BigtableAdminRequest<ListAppProfilesResponse> {
                    private static final String REST_PATH = "v2/{+parent}/appProfiles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, ListAppProfilesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends BigtableAdminRequest<AppProfile> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, AppProfile.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends BigtableAdminRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean ignoreWarnings;

                    protected Delete(String name) {
                        super(BigtableAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+/appProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getIgnoreWarnings() {
                        return this.ignoreWarnings;
                    }

                    public Delete setIgnoreWarnings(Boolean ignoreWarnings) {
                        this.ignoreWarnings = ignoreWarnings;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends BigtableAdminRequest<AppProfile> {
                    private static final String REST_PATH = "v2/{+parent}/appProfiles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String appProfileId;
                    @Key
                    private Boolean ignoreWarnings;

                    protected Create(String parent, AppProfile content) {
                        super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, AppProfile.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getAppProfileId() {
                        return this.appProfileId;
                    }

                    public Create setAppProfileId(String appProfileId) {
                        this.appProfileId = appProfileId;
                        return this;
                    }

                    public Boolean getIgnoreWarnings() {
                        return this.ignoreWarnings;
                    }

                    public Create setIgnoreWarnings(Boolean ignoreWarnings) {
                        this.ignoreWarnings = ignoreWarnings;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Update
            extends BigtableAdminRequest<Instance> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String name, Instance content) {
                    super(BigtableAdmin.this, "PUT", REST_PATH, (Object)content, Instance.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String name) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class TestIamPermissions
            extends BigtableAdminRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v2/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends BigtableAdminRequest<Policy> {
                private static final String REST_PATH = "v2/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class PartialUpdateInstance
            extends BigtableAdminRequest<Operation> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected PartialUpdateInstance(String name, Instance content) {
                    super(BigtableAdmin.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public PartialUpdateInstance set$Xgafv(String $Xgafv) {
                    return (PartialUpdateInstance)super.set$Xgafv($Xgafv);
                }

                public PartialUpdateInstance setAccessToken(String accessToken) {
                    return (PartialUpdateInstance)super.setAccessToken(accessToken);
                }

                public PartialUpdateInstance setAlt(String alt) {
                    return (PartialUpdateInstance)super.setAlt(alt);
                }

                public PartialUpdateInstance setCallback(String callback) {
                    return (PartialUpdateInstance)super.setCallback(callback);
                }

                public PartialUpdateInstance setFields(String fields) {
                    return (PartialUpdateInstance)super.setFields(fields);
                }

                public PartialUpdateInstance setKey(String key) {
                    return (PartialUpdateInstance)super.setKey(key);
                }

                public PartialUpdateInstance setOauthToken(String oauthToken) {
                    return (PartialUpdateInstance)super.setOauthToken(oauthToken);
                }

                public PartialUpdateInstance setPrettyPrint(Boolean prettyPrint) {
                    return (PartialUpdateInstance)super.setPrettyPrint(prettyPrint);
                }

                public PartialUpdateInstance setQuotaUser(String quotaUser) {
                    return (PartialUpdateInstance)super.setQuotaUser(quotaUser);
                }

                public PartialUpdateInstance setUploadType(String uploadType) {
                    return (PartialUpdateInstance)super.setUploadType(uploadType);
                }

                public PartialUpdateInstance setUploadProtocol(String uploadProtocol) {
                    return (PartialUpdateInstance)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public PartialUpdateInstance setName(String name) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public PartialUpdateInstance setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public PartialUpdateInstance set(String parameterName, Object value) {
                    return (PartialUpdateInstance)super.set(parameterName, value);
                }
            }

            public class List
            extends BigtableAdminRequest<ListInstancesResponse> {
                private static final String REST_PATH = "v2/{+parent}/instances";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(BigtableAdmin.this, "GET", REST_PATH, null, ListInstancesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends BigtableAdminRequest<Policy> {
                private static final String REST_PATH = "v2/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                    super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends BigtableAdminRequest<Instance> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(BigtableAdmin.this, "GET", REST_PATH, null, Instance.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends BigtableAdminRequest<Empty> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(BigtableAdmin.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/instances/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/instances/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends BigtableAdminRequest<Operation> {
                private static final String REST_PATH = "v2/{+parent}/instances";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, CreateInstanceRequest content) {
                    super(BigtableAdmin.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Projects projects() {
            return new Projects();
        }

        public class Projects {
            public ChildOperations childOperations() {
                return new ChildOperations();
            }

            public class ChildOperations {
                public List list(String name) throws IOException {
                    List result = new List(name);
                    BigtableAdmin.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends BigtableAdminRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(BigtableAdmin.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^operations/projects/.*$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/projects/.*$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/projects/.*$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Get
        extends BigtableAdminRequest<Operation> {
            private static final String REST_PATH = "v2/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(BigtableAdmin.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!BigtableAdmin.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

