/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.time.Period;
import oracle.sql.Datum;
import oracle.sql.utilpack;

public class INTERVALYM
extends Datum {
    private static int MASKVAL = 255;
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;
    private static int INTERVALYMMAXLENGTH = 5;
    private static int MAXYEARPREC = 9;
    private static int MAXMONTH = 12;
    static final long serialVersionUID = 8393284561907159296L;

    public INTERVALYM() {
        super(INTERVALYM._initIntervalYM());
    }

    public INTERVALYM(byte[] intervalYM) {
        super(intervalYM);
    }

    public INTERVALYM(String str) {
        super(INTERVALYM.toBytes(str));
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static final INTERVALYM toIntervalym(Period period) {
        if (period == null) {
            return null;
        }
        if (period.getDays() != 0) {
            throw new IllegalArgumentException("Invalid period input, argument cannot contain days");
        }
        byte[] bytes = new byte[INTERVALYMMAXLENGTH];
        int y = period.getYears() ^ INTYMYEAROFFSET;
        bytes[0] = (byte)(y >> 24);
        bytes[1] = (byte)(y >> 16 & 0xFF);
        bytes[2] = (byte)(y >> 8 & 0xFF);
        bytes[3] = (byte)(y & 0xFF);
        int m = period.getMonths() + INTYMMONTHOFFSET;
        bytes[4] = (byte)(m & 0xFF);
        return new INTERVALYM(bytes);
    }

    public static final Period toPeriod(byte[] bytes) {
        if (bytes.equals(null)) {
            return null;
        }
        int y = (bytes[0] & 0xFF) << 24;
        y |= (bytes[1] & 0xFF) << 16;
        y |= (bytes[2] & 0xFF) << 8;
        y |= bytes[3] & 0xFF;
        int m = bytes[4] - INTYMMONTHOFFSET;
        return Period.of(y ^= INTYMYEAROFFSET, m, 0);
    }

    public Period getPeriod() {
        return INTERVALYM.toPeriod(this.shareBytes());
    }

    public static byte[] toBytes(String str) {
        int indexOfHyphen;
        String interStr;
        if (str == null) {
            return null;
        }
        byte[] intarr = new byte[INTERVALYMMAXLENGTH];
        char sign = (interStr = str.trim()).charAt(0);
        int startIndex = sign != '-' && sign != '+' ? 0 : 1;
        String yearStr = (interStr = interStr.substring(startIndex)).substring(0, indexOfHyphen = interStr.indexOf(45));
        if (yearStr.length() > MAXYEARPREC) {
            throw new NumberFormatException();
        }
        int intervalyear = Integer.valueOf(yearStr);
        String monthStr = interStr.substring(indexOfHyphen + 1);
        int intervalmonth = Integer.valueOf(monthStr);
        if (intervalmonth >= MAXMONTH) {
            throw new NumberFormatException();
        }
        if (sign == '-') {
            intervalyear = -1 * intervalyear;
            intervalmonth = -1 * intervalmonth;
        }
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(intervalyear += INTYMYEAROFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(intervalyear);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(intervalyear);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(intervalyear);
        intarr[4] = (byte)(intervalmonth + INTYMMONTHOFFSET);
        return intarr;
    }

    public static String toString(byte[] inparray) {
        if (inparray == null || inparray.length == 0) {
            return new String();
        }
        boolean positive = true;
        int intervalYear = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[0]);
        intervalYear |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[1]);
        intervalYear |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[2]);
        intervalYear |= inparray[3] & 0xFF;
        int intervalMonth = inparray[4] - INTYMMONTHOFFSET;
        if ((intervalYear -= INTYMYEAROFFSET) < 0) {
            positive = false;
            intervalYear = -intervalYear;
        }
        if (intervalMonth < 0) {
            positive = false;
            intervalMonth = -intervalMonth;
        }
        String result = intervalYear + "-" + intervalMonth;
        if (!positive) {
            result = "-" + result;
        }
        return result;
    }

    @Override
    public Object toJdbc() {
        return this;
    }

    @Override
    public String stringValue() {
        return INTERVALYM.toString(this.getBytes());
    }

    public String toString() {
        return INTERVALYM.toString(this.getBytes());
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        INTERVALYM[] intym = new INTERVALYM[arraySize];
        return intym;
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls.getName().compareTo("java.lang.String") == 0;
    }

    private static byte[] _initIntervalYM() {
        byte[] intarr = new byte[INTERVALYMMAXLENGTH];
        int year = 0;
        int month = 0;
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(year += INTYMYEAROFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(year);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(year);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(year);
        intarr[4] = (byte)(month + INTYMMONTHOFFSET);
        return intarr;
    }
}

