/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy
implements Diagnosable {
    private static final String CLASS_NAME = ConnStrategy.class.getName();
    static final int MAX_ITERATION_COUNT = 100;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption currentOption;
    public int sdu;
    public int tdu;
    public int nextOptToTry;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private final ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private final SSLContext sslContext;
    private final OracleHostnameResolver hostnameResolver;
    private int outboundConnectTimeout = 0;
    private String connectionIdPrefix;
    private final Diagnosable diagnosable;

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties up) {
        this(up, null, null, null);
    }

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties up, SSLContext sslContext, OracleHostnameResolver hostnameResolver, Diagnosable diagnosable) {
        this.diagnosable = diagnosable;
        this.nextOptToTry = 0;
        this.osuser = up.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = up.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(up.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "600"));
        this.userProp = up;
        this.createSocketOptions(up);
        this.sslContext = sslContext;
        this.hostnameResolver = hostnameResolver;
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up) {
        ConnStrategy.createSocketOptions(up, this.socketOptions, !this.reuseOpt);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up, @Blind(value=PropertiesBlinder.class) Properties socketOptions) {
        ConnStrategy.createSocketOptions(up, socketOptions, true);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties up, @Blind(value=PropertiesBlinder.class) Properties socketOptions, boolean setDefaultNoDelay) {
        String propertyKey = null;
        String propertyValue = null;
        boolean tcpNoDelayParam = false;
        Enumeration<Object> e = up.keys();
        while (e.hasMoreElements()) {
            Object password;
            propertyKey = (String)e.nextElement();
            if (propertyKey.equalsIgnoreCase("TCP.NODELAY")) {
                tcpNoDelayParam = true;
                propertyValue = up.getProperty(propertyKey).toUpperCase();
                if (propertyValue.equals("NO")) {
                    socketOptions.put((Object)0, "NO");
                    continue;
                }
                socketOptions.put((Object)0, "YES");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)3, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, false, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)4, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_allow_weak_dn_match")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)43, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)28, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_location")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(propertyValue, up));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_password")) {
                password = up.get("oracle.net.wallet_password");
                socketOptions.put((Object)16, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_version")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                password = up.get(propertyKey);
                socketOptions.put((Object)10, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                password = up.get(propertyKey);
                socketOptions.put((Object)13, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)14, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)18, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.keepAlive")) {
                propertyValue = up.getProperty(propertyKey);
                if (Boolean.parseBoolean(propertyValue)) {
                    socketOptions.put((Object)1, "YES");
                    continue;
                }
                socketOptions.put((Object)1, "NO");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.useNio")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)20, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)21, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqTransport");
                socketOptions.put((Object)22, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)23, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)24, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, true, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketUser")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)26, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketPassword")) {
                password = up.get("oracle.net.websocketPassword");
                socketOptions.put((Object)27, password instanceof String ? OpaqueString.newOpaqueString((String)password) : (OpaqueString)password);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)29, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.httpsProxyHost")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)30, propertyValue);
                socketOptions.put((Object)31, up.getProperty("oracle.net.httpsProxyPort"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.socksProxyHost")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)36, propertyValue);
                socketOptions.put((Object)37, up.getProperty("oracle.net.socksProxyPort"));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.socksRemoteDNS")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)39, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPIDLE")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)33, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPINTERVAL")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)34, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.TCP_KEEPCOUNT")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)35, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_context_protocol")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)38, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match_default")) {
                propertyValue = up.getProperty(propertyKey);
                socketOptions.put((Object)40, propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.jdbc.provider.sslContext")) continue;
            Object providerSSLContext = up.get(propertyKey);
            socketOptions.put((Object)42, providerSSLContext instanceof String ? OpaqueString.newOpaqueString((String)providerSSLContext) : (OpaqueString)providerSSLContext);
        }
        if (!tcpNoDelayParam && setDefaultNoDelay) {
            socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean keepAlive) {
        if (keepAlive) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnOption execute(boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent) throws NetException, InterruptedIOException {
        int i;
        ArrayList<ConnOption> cOpts;
        if (this.diagnosable.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConnectDescription desc : this.descriptionList) {
                cOpts = desc.getConnectOptions();
                int max = cOpts.size() - 1;
                for (i = 0; i < max; ++i) {
                    stringBuilder.append(cOpts.get(i));
                    if (i >= max) continue;
                    stringBuilder.append(System.lineSeparator());
                }
            }
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", "number of descriptions={0}, connect options={1} ", (String)null, null, (Object)this.descriptionList.size(), (Object)stringBuilder.toString());
        }
        IOException causeException = null;
        for (int d = this.lastRetryConnectDescription; d < this.descriptionList.size(); ++d) {
            ConnectDescription desc;
            desc = this.descriptionList.get(d);
            cOpts = desc.getConnectOptions();
            this.prepareForExecuteDescription(desc);
            this.outboundConnectTimeout = this.getOutboundConnectTimeout(desc);
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "execute", "RETRY_COUNT={0}, LAST RETRY COUNTER={1}, OUTBOUND_CONNECT_TIMEOUT={2}, TRANSPORT_CONNECT_TIMEOUT={3}, SDU={4}, TDU={5}. ", (String)null, null, (Object)this.retryCount, (Object)this.lastRetryCounter, (Object)this.outboundConnectTimeout, (Object)desc.getTransportConnectTimeout(), (Object)this.sdu, (Object)this.tdu);
            int delay = desc.getDelayInMillis();
            for (i = this.lastRetryCounter; i <= this.retryCount; ++i) {
                int iterationCount = 0;
                while (this.nextOptToTry < cOpts.size() && iterationCount++ < 100) {
                    try {
                        this.currentOption = cOpts.get(this.nextOptToTry);
                        this.prepareForExecuteConnOption(this.currentOption);
                        this.executeConnOption(this.currentOption, dmsParent, desc.getTransportConnectTimeout(), startNewOCTOInterruptTask, this.outboundConnectTimeout);
                        this.handleExecuteConnOptionCompletion(this.currentOption);
                        this.lastRetryCounter = i;
                        this.lastRetryConnectDescription = d;
                        ConnOption connOption = this.currentOption;
                        return connOption;
                    }
                    catch (InterruptedIOException interruptErr) {
                        this.handleExecuteConnOptionFailure(this.currentOption, interruptErr);
                        throw interruptErr;
                    }
                    catch (IOException err) {
                        this.handleExecuteConnOptionFailure(this.currentOption, err);
                        causeException = err;
                    }
                    finally {
                        ++this.nextOptToTry;
                    }
                }
                this.nextOptToTry = 0;
                DownHostsCache.getInstance().reorderAddresses(cOpts);
                if (delay <= 0 || i >= this.retryCount) continue;
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException interruptException) {
                    throw new InterruptedIOException(interruptException.getMessage());
                }
            }
            this.lastRetryCounter = 0;
        }
        if (causeException == null) {
            throw new NetException(17820);
        }
        if (causeException instanceof NetException) {
            throw (NetException)causeException;
        }
        if (causeException instanceof UnknownHostException) {
            throw (NetException)new NetException(17868).initCause(causeException);
        }
        throw (NetException)new NetException(17820).initCause(causeException);
    }

    private void logDescriptionList(String methodName) {
        if (!this.diagnosable.isDebugEnabled()) {
            return;
        }
        this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, methodName, "CS contains following Connection Options. number of descriptions={0}. ", (String)null, null, (Object)this.descriptionList.size());
        for (ConnectDescription desc : this.descriptionList) {
            ArrayList<ConnOption> cOpts = desc.getConnectOptions();
            for (ConnOption copt : cOpts) {
                this.diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, methodName, "ConnOption={0}.", (String)null, null, (Object)copt);
            }
        }
    }

    public String getConnectionIdPrefix() {
        return this.connectionIdPrefix;
    }

    private void prepareForExecuteDescription(ConnectDescription desc) {
        this.setSecurityOptions(desc);
        if (desc.getTransportConnectTimeout() >= 0) {
            this.socketOptions.put((Object)2, Integer.toString(desc.getTransportConnectTimeout()));
        }
        this.sdu = desc.getSdu();
        this.tdu = desc.getTdu();
        this.retryCount = desc.getRetryCount();
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        this.setExpireTimeSocketOption(desc.getExpireTime(), this.socketOptions);
        this.connectionIdPrefix = this.userProp.getProperty("oracle.net.connectionIdPrefix", desc.getConnectionIdPrefix());
        if (desc.getTokenAuthentication() != null || "OCI_TOKEN".equalsIgnoreCase(desc.getPasswordAuthentication()) || "AZURE_TOKEN".equalsIgnoreCase(desc.getPasswordAuthentication())) {
            this.socketOptions.put((Object)40, "true");
        }
    }

    private void setSecurityOptions(ConnectDescription desc) {
        if (desc.getEncryptionClient() != null) {
            this.userProp.setProperty("oracle.net.encryption_client", desc.getEncryptionClient());
        }
        if (desc.getEncryptionClientTypes() != null) {
            this.userProp.setProperty("oracle.net.encryption_types_client", desc.getEncryptionClientTypes());
        }
        if (desc.getChecksumClient() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_client", desc.getChecksumClient());
        }
        if (desc.getChecksumClientTypes() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_types_client", desc.getChecksumClientTypes());
        }
        if (desc.getAllowWeakCrypto() != null) {
            this.userProp.setProperty("oracle.net.allow_weak_crypto", desc.getAllowWeakCrypto());
        }
        if (desc.getTokenAuthentication() != null) {
            this.userProp.setProperty("oracle.jdbc.tokenAuthentication", desc.getTokenAuthentication());
        }
        if (desc.getTokenLocation() != null) {
            this.userProp.setProperty("oracle.jdbc.tokenLocation", desc.getTokenLocation());
        }
        if (desc.getPasswordAuthentication() != null) {
            this.userProp.setProperty("oracle.jdbc.passwordAuthentication", desc.getPasswordAuthentication());
        }
        if (desc.getOciIamUrl() != null) {
            this.userProp.setProperty("oracle.jdbc.ociIamUrl", desc.getOciIamUrl());
        }
        if (desc.getOciTenancy() != null) {
            this.userProp.setProperty("oracle.jdbc.ociTenancy", desc.getOciTenancy());
        }
        if (desc.getOciCompartment() != null) {
            this.userProp.setProperty("oracle.jdbc.ociCompartment", desc.getOciCompartment());
        }
        if (desc.getOciDatabase() != null) {
            this.userProp.setProperty("oracle.jdbc.ociDatabase", desc.getOciDatabase());
        }
        if (desc.getOciConfigFile() != null) {
            this.userProp.setProperty("oracle.jdbc.ociConfigFile", desc.getOciConfigFile());
        }
        if (desc.getOciProfile() != null) {
            this.userProp.setProperty("oracle.jdbc.ociProfile", desc.getOciProfile());
        }
        if (desc.getAzureDbAppIdUri() != null) {
            this.userProp.setProperty("oracle.jdbc.azureDatabaseApplicationIdUri", desc.getAzureDbAppIdUri());
        }
        if (desc.getTenantId() != null) {
            this.userProp.setProperty("oracle.jdbc.tenantId", desc.getTenantId());
        }
        if (desc.getClientId() != null) {
            this.userProp.setProperty("oracle.jdbc.clientId", desc.getClientId());
        }
        if (desc.getClientCertificate() != null) {
            this.userProp.setProperty("oracle.jdbc.clientCertificate", desc.getClientCertificate());
        }
        if (desc.getRedirectUri() != null) {
            this.userProp.setProperty("oracle.jdbc.redirectUri", desc.getRedirectUri());
        }
    }

    private void prepareForExecuteConnOption(ConnOption option) {
        if (option.walletDirectory != null) {
            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(option.walletDirectory, this.userProp));
        }
        if (option.sslServerDNMatch != null) {
            this.socketOptions.put((Object)4, option.sslServerDNMatch);
        }
        if (option.sslServerCertDN == null) {
            option.sslServerCertDN = (String)this.socketOptions.get(28);
        }
        if (option.sslAllowWeakDNMatch == null) {
            option.sslAllowWeakDNMatch = (String)this.socketOptions.get(43);
        }
        if (option.sslServerCertDN != null && this.socketOptions.get(4) == null) {
            this.socketOptions.put((Object)4, "TRUE");
        }
    }

    private void handleExecuteConnOptionCompletion(ConnOption option) {
        option.sdu = this.sdu;
        option.tdu = this.tdu;
        this.optFound = true;
    }

    private void handleExecuteConnOptionFailure(ConnOption option, IOException err) {
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "handleExecuteConnOptionFailure", "option={0}, exception occurred during connect. {0}", (String)null, null, (Object)option, (Object)err.getMessage());
        DownHostsCache.getInstance().markDownHost(option);
    }

    private void executeConnOption(ConnOption option, DMSFactory.DMSNoun dmsParent, int transportConnectTimeout, boolean startNewOCTOInterruptTask, int outboundConnectTimeout) throws IOException, InterruptedIOException {
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "executeConnOption", "Trying connection. option={0}, nextOptToTry={1}, currentOption.addr={2}. ", (String)null, null, (Object)option, (Object)this.nextOptToTry, (Object)this.currentOption.addr);
        if (outboundConnectTimeout > 0 && startNewOCTOInterruptTask) {
            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, outboundConnectTimeout, Thread.currentThread());
        }
        option.connectTimeout = outboundConnectTimeout;
        option.transportConnectTimeout = transportConnectTimeout;
        try {
            option.connect(this.socketOptions, dmsParent, this.sslContext, this.diagnosable);
        }
        catch (InterruptedIOException interruptException) {
            if (outboundConnectTimeout > 0 && !this.cancelOutboundTimeout()) {
                throw this.createOutboundTimeoutException(option);
            }
            throw interruptException;
        }
        catch (IOException connectException) {
            if (outboundConnectTimeout > 0) {
                this.cancelOutboundTimeout();
            }
            throw connectException;
        }
    }

    private NetException createOutboundTimeoutException(ConnOption option) {
        return new NetException(12170, null, false, "Outbound connect", option.connectTimeout + "ms", "host " + option.host + " port " + option.port);
    }

    private boolean cancelOutboundTimeout() {
        TimeoutInterruptHandler.InterruptTask outboundTimeoutTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        return outboundTimeoutTask != null && !outboundTimeoutTask.isInterrupted();
    }

    private final int getOutboundConnectTimeout(ConnectDescription desc) {
        if (desc.getConnectTimeout() >= 0) {
            return desc.getConnectTimeout();
        }
        String timeoutSocketOption = (String)this.socketOptions.get(25);
        if (timeoutSocketOption != null) {
            try {
                return Integer.parseInt(timeoutSocketOption);
            }
            catch (NumberFormatException ne) {
                return 0;
            }
        }
        return 0;
    }

    public CompletionStage<ConnOption> executeAsync(boolean startNewOCTOInterruptTask, DMSFactory.DMSNoun dmsParent, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        this.logDescriptionList("executeAsync");
        if (this.lastRetryConnectDescription >= this.descriptionList.size()) {
            return CompletionStageUtil.completedStage(null);
        }
        return this.executeDescriptionAsync(this.lastRetryConnectDescription, dmsParent, startNewOCTOInterruptTask, outboundTimeoutHandler, asyncExecutor).handle(CompletionStageUtil.completionHandler(option -> {
            if (option != null) {
                return option;
            }
            throw new NetException(17820);
        }, IOException.class, causeException -> {
            throw (NetException)new NetException(17820).initCause(causeException);
        }));
    }

    private final CompletionStage<ConnOption> executeDescriptionAsync(int descriptionIndex, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        ConnectDescription desc = this.descriptionList.get(descriptionIndex);
        ArrayList<ConnOption> cOpts = desc.getConnectOptions();
        this.prepareForExecuteDescription(desc);
        this.outboundConnectTimeout = this.getOutboundConnectTimeout(desc);
        int delay = desc.getDelayInMillis();
        CompletionStage<Object> executeStage = this.lastRetryCounter <= this.retryCount ? this.executeConnOptionListAsync(this.lastRetryCounter, cOpts, delay, desc.getTransportConnectTimeout(), dmsParent, startNewOCTOInterruptTask, this.outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        int nextDescriptionIndex = descriptionIndex + 1;
        return executeStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, causeException -> {
            if (nextDescriptionIndex < this.descriptionList.size()) {
                return null;
            }
            throw causeException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(option -> {
            if (option != null) {
                this.lastRetryConnectDescription = descriptionIndex;
                return CompletionStageUtil.completedStage(option);
            }
            this.lastRetryCounter = 0;
            return nextDescriptionIndex < this.descriptionList.size() ? this.executeDescriptionAsync(nextDescriptionIndex, dmsParent, startNewOCTOInterruptTask, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        }));
    }

    private CompletionStage<ConnOption> executeConnOptionListAsync(int currentRetryCount, List<ConnOption> cOpts, int delay, int transportConnectTimeout, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        CompletionStage<Object> executeStage = this.nextOptToTry < cOpts.size() ? this.executeNextConnOptionAsync(cOpts, dmsParent, transportConnectTimeout, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.completedStage(null);
        return executeStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, causeException -> {
            if (currentRetryCount < this.retryCount) {
                return null;
            }
            throw causeException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(option -> {
            if (option != null) {
                this.lastRetryCounter = currentRetryCount;
                return CompletionStageUtil.completedStage(option);
            }
            this.nextOptToTry = 0;
            DownHostsCache.getInstance().reorderAddresses(cOpts);
            if (currentRetryCount < this.retryCount) {
                CompletableFuture delayedFuture = new CompletableFuture();
                if (delay <= 0) {
                    delayedFuture.complete(null);
                } else {
                    TimeoutInterruptHandler.scheduleTask(() -> delayedFuture.complete(null), delay);
                }
                return delayedFuture.thenCompose(nil -> this.executeConnOptionListAsync(currentRetryCount + 1, cOpts, delay, transportConnectTimeout, dmsParent, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor));
            }
            return CompletionStageUtil.completedStage(null);
        }));
    }

    private final CompletionStage<ConnOption> executeNextConnOptionAsync(List<ConnOption> cOpts, DMSFactory.DMSNoun dmsParent, int transportConnectTimeout, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, Executor asyncExecutor) {
        this.currentOption = cOpts.get(this.nextOptToTry);
        this.prepareForExecuteConnOption(this.currentOption);
        CompletionStage<CompletionStage> executeComposedStage = this.executeConnOptionAsync(this.currentOption, dmsParent, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, transportConnectTimeout, asyncExecutor).handle((nil, throwable) -> {
            CompletionStage<Object> nextStage;
            ++this.nextOptToTry;
            if ((throwable = CompletionStageUtil.unwrapCompletionException(throwable)) == null) {
                this.handleExecuteConnOptionCompletion(this.currentOption);
                nextStage = CompletionStageUtil.completedStage(this.currentOption);
            } else if (throwable instanceof IOException) {
                this.handleExecuteConnOptionFailure(this.currentOption, (IOException)throwable);
                nextStage = this.nextOptToTry < cOpts.size() ? this.executeNextConnOptionAsync(cOpts, dmsParent, transportConnectTimeout, startNewOCTOInterruptTask, outboundConnectTimeout, outboundTimeoutHandler, asyncExecutor) : CompletionStageUtil.failedStage(throwable);
            } else {
                nextStage = CompletionStageUtil.failedStage(throwable);
            }
            return nextStage;
        });
        return executeComposedStage.thenCompose(Function.identity());
    }

    private final CompletionStage<Void> executeConnOptionAsync(ConnOption option, DMSFactory.DMSNoun dmsParent, boolean startNewOCTOInterruptTask, int outboundConnectTimeout, AsyncOutboundTimeoutHandler outboundTimeoutHandler, int transportConnectTimeout, Executor asyncExecutor) {
        option.connectTimeout = outboundConnectTimeout;
        option.transportConnectTimeout = transportConnectTimeout;
        if (outboundConnectTimeout > 0 && startNewOCTOInterruptTask) {
            try {
                outboundTimeoutHandler.scheduleTimeout(Duration.ofMillis(outboundConnectTimeout), this.createOutboundTimeoutException(option));
            }
            catch (IOException timeoutExpired) {
                return CompletionStageUtil.failedStage(timeoutExpired);
            }
        }
        CompletionStage<Void> connectStage = option.connectAsync(this.socketOptions, dmsParent, this.sslContext, outboundTimeoutHandler, asyncExecutor, this.diagnosable);
        if (outboundConnectTimeout > 0) {
            return connectStage.whenComplete((result, connectException) -> {
                if (connectException != null) {
                    outboundTimeoutHandler.cancelTimeout();
                }
            });
        }
        return connectStage;
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public ConnOption getOption() {
        return this.currentOption;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.currentOption.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    public ConnectDescription getConnectedDescription() {
        if (!this.optFound) {
            return null;
        }
        return this.descriptionList.get(this.lastRetryConnectDescription);
    }

    public int getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    public boolean isUsingCustomHostnameResolver() {
        return this.hostnameResolver != null;
    }

    private final void setExpireTimeSocketOption(int expireTimeMinutes, @Blind(value=PropertiesBlinder.class) Properties socketOptions) {
        if (expireTimeMinutes < 0) {
            return;
        }
        int expireTimeSeconds = expireTimeMinutes * 60;
        socketOptions.putIfAbsent((Object)33, Integer.toString(expireTimeSeconds));
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }

    public OracleHostnameResolver getHostnameResolver() {
        return this.hostnameResolver;
    }
}

