/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolFamily;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.InvalidParameterException;
import java.util.Objects;
import java.util.Set;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.net.ns.NetException;

public class SocketChannelFacade
extends SocketChannel
implements Diagnosable {
    private OutputStream underlyingOutStream;
    private InputStream underlyingInStream;

    public SocketChannelFacade(InputStream in, OutputStream out) {
        super(new SelectorProvider(){

            @Override
            public DatagramChannel openDatagramChannel() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public DatagramChannel openDatagramChannel(ProtocolFamily family) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Pipe openPipe() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public AbstractSelector openSelector() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public ServerSocketChannel openServerSocketChannel() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public SocketChannel openSocketChannel() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
        Objects.requireNonNull(out);
        Objects.requireNonNull(in);
        this.underlyingOutStream = out;
        this.underlyingInStream = in;
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket socket() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnectionPending() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (dst == null) {
            throw new InvalidParameterException("cannot be null");
        }
        if (!dst.hasRemaining()) {
            throw new NetException(17801, "no space left in read destination buffer");
        }
        byte[] buffer = new byte[dst.remaining()];
        int byteRead = this.underlyingInStream.read(buffer);
        if (byteRead > 0) {
            ByteBuffer newBytes = ByteBuffer.wrap(buffer, 0, byteRead);
            dst.put(newBytes);
        }
        return byteRead;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported read type of operation");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int _size = src.limit();
        byte[] buffer = new byte[_size];
        src.get(buffer, 0, _size);
        this.underlyingOutStream.write(buffer);
        return _size;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("unsupported write type of operation");
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        throw new UnsupportedOperationException();
    }
}

