/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonBuffer;

public class OsonHeader {
    private static byte[][] UTF8_MAPPING = new byte[256][];
    int version;
    int flags;
    int[] fieldNameOffsets;
    int[] hashIdArray;
    String[] fieldNames;
    int ubHash;
    int ubFieldId;
    int fieldHeapSize;
    int treeSegmentSize;
    int treeSegmentOffset;
    int tinyNodeCount;
    int updateFlags;
    int extendedTreeSegmentOffset;
    Map<Integer, Integer> forwardingAddress;

    public OsonHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f) {
        this.readHeader(b, f);
        if (this.isScalar()) {
            this.treeSegmentOffset = b.position();
            return;
        }
        this.readHashIds(b, f);
        if (this.isSet(2048)) {
            this.ub4int(b, this.fieldNameOffsets);
        } else {
            this.ub2(b, this.fieldNameOffsets);
        }
        int offset = b.position();
        if (this.fieldNameOffsets.length > 0) {
            this.treeSegmentOffset = -1;
            for (int i = 0; i < this.fieldNameOffsets.length; ++i) {
                b.position(this.fieldNameOffsets[i] + offset);
                int len = b.getUB1();
                this.fieldNames[i] = b.readString(len);
                if (b.position() <= this.treeSegmentOffset) continue;
                this.treeSegmentOffset = b.position();
            }
        } else {
            this.treeSegmentOffset = b.position();
        }
        if (!this.isSet(4) || !this.isSet(2)) {
            throw new UnsupportedOperationException();
        }
        int updateHeaderOffset = this.treeSegmentOffset + this.treeSegmentSize;
        if (updateHeaderOffset < b.buffer().limit()) {
            b.position(updateHeaderOffset);
            this.readUpdateHeader(b, f);
        }
    }

    public void readHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f) {
        if (b.buffer().remaining() <= 6) {
            throw OracleJsonExceptions.CORRUPT2.create(f, b.buffer().remaining());
        }
        int magicAndVersion = b.getInt();
        if ((magicAndVersion & 0xFFFFFF00) != -11904512) {
            throw OracleJsonExceptions.CORRUPT.create(f, new Object[0]);
        }
        this.version = magicAndVersion & 0xFF;
        if (this.version < 1 || this.version > 2) {
            throw OracleJsonExceptions.UNSUPPORTED_VERSION.create(f, this.version);
        }
        this.flags = b.getUB2();
        if (!this.isSet(16)) {
            int uniqueFields;
            if (this.isSet(8)) {
                this.ubFieldId = 4;
                uniqueFields = b.getUB4int();
            } else if (this.isSet(1024)) {
                this.ubFieldId = 2;
                uniqueFields = b.getUB2();
            } else {
                this.ubFieldId = 1;
                uniqueFields = b.getUB1();
            }
            this.fieldNameOffsets = new int[uniqueFields];
            this.hashIdArray = new int[uniqueFields];
            this.fieldNames = new String[uniqueFields];
            this.fieldHeapSize = this.isSet(2048) ? b.getUB4int() : b.getUB2();
            this.treeSegmentSize = this.isSet(4096) ? b.getUB4int() : b.getUB2();
            this.tinyNodeCount = b.getUB2();
        } else {
            this.treeSegmentSize = this.isSet(4096) ? b.getUB4int() : b.getUB2();
        }
    }

    private void readUpdateHeader(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f) {
        this.updateFlags = b.getUB2();
        int numOverflowAddrSeg = b.getUB2();
        b.getUB4int();
        int overflowMappingSize = b.getUB4int();
        b.getUB4int();
        this.extendedTreeSegmentOffset = b.position() + overflowMappingSize;
        this.forwardingAddress = new HashMap<Integer, Integer>();
        if (this.isSetUpd(256)) {
            for (int i = 0; i < numOverflowAddrSeg; ++i) {
                this.forwardingAddress.put(b.getUB2(), b.getUB2());
            }
        } else {
            for (int i = 0; i < numOverflowAddrSeg; ++i) {
                this.forwardingAddress.put(b.getUB4int(), b.getUB4int());
            }
        }
    }

    public boolean isScalar() {
        return this.isSet(16);
    }

    public boolean isTinyNodeCount() {
        return this.isSet(8192);
    }

    public void readHashIds(OsonBuffer b, OracleJsonExceptions.ExceptionFactory f) {
        if (this.isSet(256)) {
            this.ubHash = 1;
            this.ub1(b, this.hashIdArray);
        } else {
            if (this.hashIdArray.length != 0) {
                throw OracleJsonExceptions.NOT_IMPLEMENTED.create(f, new Object[0]);
            }
            this.ubHash = 1;
        }
    }

    private void ub1(OsonBuffer s, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s.getUB1();
        }
    }

    private void ub2(OsonBuffer s, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s.getUB2();
        }
    }

    private void ub4int(OsonBuffer s, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = s.getUB4int();
        }
    }

    public int getTreeSegmentOffset() {
        return this.treeSegmentOffset;
    }

    public int getFieldHeapSize() {
        return this.fieldHeapSize;
    }

    public String[] getFields() {
        return this.fieldNames;
    }

    public int[] hashIds() {
        return this.hashIdArray;
    }

    private boolean isSet(int f) {
        return (this.flags & f) != 0;
    }

    private boolean isSetUpd(int f) {
        return (this.updateFlags & f) != 0;
    }

    public boolean fieldsSorted() {
        return !this.isSet(32768);
    }

    public boolean relativeOffsets() {
        return this.isSet(1);
    }

    public int getFieldId(String key) {
        int hash = this.ohash(key);
        int idx = Arrays.binarySearch(this.hashIdArray, hash);
        if (idx < 0) {
            return -1;
        }
        while (idx > 0 && this.hashIdArray[idx - 1] == hash) {
            --idx;
        }
        do {
            if (!this.fieldNames[idx].equals(key)) continue;
            return idx + 1;
        } while (++idx < this.hashIdArray.length && this.hashIdArray[idx] == hash);
        return -1;
    }

    public int ohash(String key) {
        if (this.ubHash == 1) {
            return OsonHeader.ub1hash(key);
        }
        throw new IllegalStateException(OracleJsonExceptions.NOT_IMPLEMENTED.getMessage(new Object[0]));
    }

    public static int ub1hash(String key) {
        long hash = 2166136261L;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c < '\u0080') {
                hash = (hash ^ (long)UTF8_MAPPING[c][0]) * 16777619L;
                continue;
            }
            if (c < '\u0100') {
                hash = (hash ^ (long)UTF8_MAPPING[c][0]) * 16777619L;
                hash = (hash ^ (long)UTF8_MAPPING[c][1]) * 16777619L;
                continue;
            }
            int cp = key.codePointAt(i);
            if (Character.charCount(cp) == 2) {
                ++i;
            }
            String s = new String(Character.toChars(cp));
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                hash = (hash ^ (long)bytes[j]) * 16777619L;
            }
        }
        long ret = hash << 24 & 0xFF000000L | hash << 8 & 0xFF0000L | hash >> 8 & 0xFF00L | hash >> 24 & 0xFFL;
        return (int)((0xFFFFFFFFFF000000L & ret) >> 24);
    }

    public int numFieldIdBytes() {
        return this.ubFieldId;
    }

    static {
        for (int i = 0; i < UTF8_MAPPING.length; ++i) {
            OsonHeader.UTF8_MAPPING[i] = new String(new char[]{(char)i}).getBytes(StandardCharsets.UTF_8);
        }
    }
}

