/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessageI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TypeDescriptor;

final class T4Caqe
extends T4CTTIfun {
    static final int KPD_AQ_BUFMSG = 2;
    static final int KPD_AQ_EITHER = 16;
    static final int OCI_COMMIT_ON_SUCCESS = 32;
    static final int ATTR_TRANSFORMATION = 196;
    static final int AQEVER_DEFAULT = 1;
    T4CTTIaqm aqm;
    T4Ctoh toh;
    private byte[] queueNameBytes = null;
    private AQEnqueueOptions enqueueOptions = null;
    private AQMessagePropertiesI messageProperties = null;
    private byte[] messageData = null;
    private byte[] messageOid = null;
    private int aqever = 1;
    private boolean isRawQueue = false;
    private int nbExtensions = 0;
    private byte[][] extensionTextValues = null;
    private byte[][] extensionBinaryValues = null;
    private int[] extensionKeywords = null;
    private AQAgentI[] attrRecipientList = null;
    private byte[][] recipientTextValues = null;
    private byte[][] recipientBinaryValues = null;
    private int[] recipientKeywords = null;
    private byte[] aqmcorBytes;
    private byte[] aqmeqnBytes;
    private boolean retrieveMessageId = false;
    private byte[] outMsgid = null;
    private byte[] senderAgentName = null;
    private byte[] senderAgentAddress = null;
    private byte senderAgentProtocol = 0;
    private boolean isJsonQueue;

    T4Caqe(T4CConnection _connection) {
        super(_connection, (byte)3);
        this.setFunCode((short)121);
        this.toh = new T4Ctoh(_connection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
    }

    void doOAQEQ(String _queueName, AQEnqueueOptions _enqueueOptions, AQMessagePropertiesI _messageProperties, byte[] _messageData, byte[] _messageOid, int _messageVersion, boolean _isRawQueue) throws SQLException, IOException {
        String transformation;
        this.enqueueOptions = _enqueueOptions;
        this.messageProperties = _messageProperties;
        String aqmcor = this.messageProperties.getCorrelation();
        this.aqmcorBytes = (byte[])(aqmcor != null && aqmcor.length() != 0 ? this.meg.conv.StringToCharBytes(aqmcor) : null);
        String aqmeqn = this.messageProperties.getExceptionQueue();
        this.aqmeqnBytes = (byte[])(aqmeqn != null && aqmeqn.length() != 0 ? this.meg.conv.StringToCharBytes(aqmeqn) : null);
        AQAgentI senderAgent = (AQAgentI)this.messageProperties.getSender();
        if (senderAgent != null) {
            this.senderAgentName = (byte[])(senderAgent.getName() != null ? this.meg.conv.StringToCharBytes(senderAgent.getName()) : null);
            this.senderAgentAddress = (byte[])(senderAgent.getAddress() != null ? this.meg.conv.StringToCharBytes(senderAgent.getAddress()) : null);
            this.senderAgentProtocol = (byte)senderAgent.getProtocol();
        } else {
            this.senderAgentName = null;
            this.senderAgentAddress = null;
            this.senderAgentProtocol = 0;
        }
        this.messageData = _messageData;
        this.messageOid = _messageOid;
        this.aqever = _messageVersion;
        this.isRawQueue = _isRawQueue;
        this.isJsonQueue = AQMessageI.compareToid(this.messageOid, TypeDescriptor.JSONTOID);
        this.queueNameBytes = (byte[])(_queueName != null && _queueName.length() != 0 ? this.meg.conv.StringToCharBytes(_queueName) : null);
        this.attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
        if (this.attrRecipientList != null && this.attrRecipientList.length > 0) {
            this.recipientTextValues = new byte[this.attrRecipientList.length * 3][];
            this.recipientBinaryValues = new byte[this.attrRecipientList.length * 3][];
            this.recipientKeywords = new int[this.attrRecipientList.length * 3];
            for (int i = 0; i < this.attrRecipientList.length; ++i) {
                if (this.attrRecipientList[i].getName() != null) {
                    this.recipientTextValues[3 * i] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getName());
                }
                if (this.attrRecipientList[i].getAddress() != null) {
                    this.recipientTextValues[3 * i + 1] = this.meg.conv.StringToCharBytes(this.attrRecipientList[i].getAddress());
                }
                this.recipientBinaryValues[3 * i + 2] = new byte[1];
                this.recipientBinaryValues[3 * i + 2][0] = (byte)this.attrRecipientList[i].getProtocol();
                this.recipientKeywords[3 * i] = 3 * i;
                this.recipientKeywords[3 * i + 1] = 3 * i + 1;
                this.recipientKeywords[3 * i + 2] = 3 * i + 2;
            }
        }
        if ((transformation = this.enqueueOptions.getTransformation()) != null && transformation.length() > 0) {
            this.nbExtensions = 1;
            this.extensionTextValues = new byte[this.nbExtensions][];
            this.extensionBinaryValues = new byte[this.nbExtensions][];
            this.extensionKeywords = new int[this.nbExtensions];
            this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(transformation);
            this.extensionBinaryValues[0] = null;
            this.extensionKeywords[0] = 196;
        } else {
            this.nbExtensions = 0;
        }
        this.outMsgid = null;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.aqm.initToDefaultValues();
        this.aqm.aqmpri = this.messageProperties.getPriority();
        this.aqm.aqmdel = this.messageProperties.getDelay();
        this.aqm.aqmexp = this.messageProperties.getExpiration();
        this.aqm.aqmcorBytes = this.aqmcorBytes;
        this.aqm.aqmeqnBytes = this.aqmeqnBytes;
        this.aqm.senderAgentName = this.senderAgentName;
        this.aqm.senderAgentAddress = this.senderAgentAddress;
        this.aqm.senderAgentProtocol = this.senderAgentProtocol;
        this.aqm.originalMsgId = this.messageProperties.getPreviousQueueMessageId();
        this.aqm.aqmshardNum = this.messageProperties.getShardNum();
        this.aqm.marshal();
        AQAgentI[] attrRecipientList = (AQAgentI[])this.messageProperties.getRecipientList();
        if (attrRecipientList != null && attrRecipientList.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(attrRecipientList.length * 3);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSB4(this.enqueueOptions.getVisibility().getCode());
        boolean sendRelativeMessageId = false;
        if (this.enqueueOptions.getRelativeMessageId() != null && this.enqueueOptions.getRelativeMessageId().length > 0) {
            sendRelativeMessageId = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.enqueueOptions.getRelativeMessageId().length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSWORD(this.enqueueOptions.getSequenceDeviation().getCode());
        this.meg.marshalPTR();
        this.meg.marshalSWORD(16);
        this.meg.marshalUB2(this.aqever);
        if (!this.isRawQueue) {
            if (this.isJsonQueue) {
                this.meg.marshalNULLPTR();
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            } else {
                this.meg.marshalPTR();
                this.meg.marshalNULLPTR();
                this.meg.marshalUB4(0L);
            }
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.messageData.length);
        }
        if (this.enqueueOptions.getRetrieveMessageId()) {
            this.retrieveMessageId = true;
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.retrieveMessageId = false;
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int aqeflg = 0;
        if (this.connection.autocommit) {
            aqeflg = 32;
        }
        if (this.enqueueOptions.getDeliveryMode() == AQEnqueueOptions.DeliveryMode.BUFFERED) {
            aqeflg |= 2;
        }
        this.meg.marshalUB4(aqeflg);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        if (this.nbExtensions > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.nbExtensions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        this.meg.marshalSWORD(0);
        this.meg.marshalNULLPTR();
        if (this.connection.getTTCVersion() >= 4) {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
            this.meg.marshalNULLPTR();
            this.meg.marshalNULLPTR();
            if (this.connection.getTTCVersion() >= 14) {
                if (this.isJsonQueue) {
                    this.meg.marshalPTR();
                } else {
                    this.meg.marshalNULLPTR();
                }
            }
        }
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalCHR(this.queueNameBytes);
        }
        if (attrRecipientList != null && attrRecipientList.length > 0) {
            this.meg.marshalKPDKV(this.recipientTextValues, this.recipientBinaryValues, this.recipientKeywords);
        }
        if (sendRelativeMessageId) {
            this.meg.marshalB1Array(this.enqueueOptions.getRelativeMessageId());
        }
        this.meg.marshalB1Array(this.messageOid);
        if (!this.isRawQueue) {
            if (!this.isJsonQueue) {
                this.toh.init(this.messageOid, this.messageData.length);
                this.toh.marshal(this.meg);
                this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
            }
        } else {
            this.meg.marshalB1Array(this.messageData);
        }
        if (this.nbExtensions > 0) {
            this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
        }
        if (this.isJsonQueue) {
            byte[] quasiLocator = T4CConnection.setupQuasiLocator(this.messageData.length);
            this.meg.marshalUB4(quasiLocator.length);
            this.meg.marshalB1Array(quasiLocator);
            if (this.connection.isZeroCopyIOEnabled()) {
                this.meg.writeZeroCopyIO(this.messageData, 0, this.messageData.length);
            } else {
                this.meg.marshalCLR(this.messageData, 0, this.messageData.length);
            }
        }
    }

    byte[] getMessageId() {
        return this.outMsgid;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        if (this.retrieveMessageId) {
            this.outMsgid = new byte[16];
            this.meg.unmarshalBuffer(this.outMsgid, 0, 16);
        }
        int ign1 = this.meg.unmarshalUB2();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

