/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;

class T4CTTIrxd
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4CTTIrxd.class.getName();
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    int rowCount = 0;
    static final byte TTICMD_UNAUTHORIZED = 1;
    private int[] indicesOfColumnsToBeCopied = null;
    static int call_count = 0;

    T4CTTIrxd(T4CConnection _conn) {
        super(_conn, (byte)7);
    }

    void init() {
        this.rowCount = 0;
    }

    void setNumberOfColumns(int nbCol) {
        this.nbOfColumns = nbCol;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    void unmarshalBVC(int nbOfColumnSent) throws SQLException, IOException {
        this.bvcColSent.clear();
        int nbOfUB1 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int ub1 = 0; ub1 < nbOfUB1; ++ub1) {
            byte bvc = (byte)(this.meg.unmarshalUB1() & 0xFF);
            int _ub1 = ub1;
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalBVC", "bvc byte: {0} value: {1}", null, null, () -> new Object[]{_ub1, Integer.toHexString(bvc & 0xFF)});
            this.bvcColSent.set(ub1, bvc);
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] bitVec, int length) throws SQLException, IOException {
        this.bvcColSent.clear();
        if (length == 0) {
            this.bvcFound = false;
        } else {
            for (int i = 0; i < length; ++i) {
                byte bvc = bitVec[i];
                this.bvcColSent.set(i, bvc);
            }
            this.bvcFound = true;
        }
    }

    Vector<IOException> marshal(byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, byte[] byteBufferForCharConversion, DBConversion conversion, InputStream[] parameterStream, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators, byte[] ioVector, int rowId, int[] oacmxlArr, boolean isPlsql, int[] returnParamMeta, int[] nbPostPonedColumnsInOut, int[][] indexOfPostPonedColumnInOut, boolean sendFirstPostPonedColumnOnly, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, boolean bindUseDBA) throws IOException {
        if (bindUseDBA) {
            return this.marshalBindDBA(bindIndicators, bindIndicatorSubRange, parameterStream, ibtBindBytes, ibtBindChars, ibtBindIndicators, ioVector, rowId, oacmxlArr, isPlsql, returnParamMeta, nbPostPonedColumnsInOut, indexOfPostPonedColumnInOut, sendFirstPostPonedColumnOnly, bindData, bindDataOffsets, bindDataLengths);
        }
        return this.marshalPrimitive(bindBytes, bindChars, bindIndicators, bindIndicatorSubRange, byteBufferForCharConversion, conversion, parameterStream, ibtBindBytes, ibtBindChars, ibtBindIndicators, ioVector, rowId, oacmxlArr, isPlsql, returnParamMeta, nbPostPonedColumnsInOut, indexOfPostPonedColumnInOut, sendFirstPostPonedColumnOnly);
    }

    Vector<IOException> marshalBindDBA(short[] bindIndicators, int bindIndicatorSubRange, InputStream[] parameterStream, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators, byte[] ioVector, int rowIndex, int[] oacmxlArr, boolean isPlsql, int[] returnParamMeta, int[] nbPostPonedColumnsInOut, int[][] indexOfPostPonedColumnInOut, boolean sendFirstPostPonedColumnOnly, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths) throws IOException {
        Vector<IOException> ioExceptionsFromUserStream = null;
        try {
            int bindDataIndex;
            int nullIndicator;
            int nullOffset;
            int type;
            int subRangeOffset;
            int nbPostPonedColumnsAdjusted;
            this.marshalTTCcode();
            int number_of_bind_positions = bindIndicators[bindIndicatorSubRange + 0] & 0xFFFF;
            int nbOfStreams = 0;
            int nbPostPonedColumns = nbPostPonedColumnsInOut[0];
            int[] indexOfPostPonedColumn = indexOfPostPonedColumnInOut[0];
            int nbOfIbt = 0;
            if (sendFirstPostPonedColumnOnly) {
                nbPostPonedColumnsAdjusted = 1;
                assert (nbPostPonedColumns > 0) : "No postoned columns in RXD";
            } else {
                for (int position = 0; position < number_of_bind_positions; ++position) {
                    byte[] tmp;
                    if (nbOfStreams < nbPostPonedColumns && indexOfPostPonedColumn[nbOfStreams] == position) {
                        ++nbOfStreams;
                        continue;
                    }
                    boolean marshalNullObjectForDmlReturning = false;
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * position;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: position: {0}, type: {1}", (String)null, (Throwable)null, (Object)position, (Object)type);
                    if (ioVector != null && (ioVector[position] & 0x20) == 0) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: OUT ONLY", null, null);
                        if (type != 998) continue;
                        ++nbOfIbt;
                        continue;
                    }
                    int valueLengthOffset = ((bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 8] & 0xFFFF) + rowIndex;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowIndex;
                    int length = bindIndicators[valueLengthOffset] & 0xFFFF;
                    nullIndicator = bindIndicators[nullOffset];
                    if (type == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 102) {
                        bindDataIndex = rowIndex * number_of_bind_positions + position;
                        int payloadLength = bindDataLengths[bindDataIndex];
                        if (payloadLength == 0) {
                            this.meg.marshalUB1((short)1);
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        tmp = new byte[payloadLength];
                        bindData.get(bindDataOffsets[bindDataIndex], tmp, 0, payloadLength);
                        int cursorId = tmp[0] << 24 | tmp[1] << 16 | tmp[2] << 8 | tmp[3];
                        int ub4Len = cursorId == 0 ? 0 : (cursorId <= 255 ? 1 : (cursorId <= 65535 ? 2 : (cursorId <= 0xFFFFFF ? 3 : 4)));
                        this.meg.marshalUB1((short)(ub4Len + 1));
                        this.meg.marshalUB4(cursorId);
                        continue;
                    }
                    if (type == 994) {
                        nullIndicator = -1;
                        int dty = returnParamMeta[3 + position * 4 + 0];
                        if (dty == 109) {
                            marshalNullObjectForDmlReturning = true;
                        }
                    } else if (type == 8 || type == 24 || !isPlsql && oacmxlArr != null && oacmxlArr.length > position && oacmxlArr[position] > this.connection.maxNonStreamBindByteSize) {
                        if (nbPostPonedColumns >= indexOfPostPonedColumn.length) {
                            int[] newindexOfPostPonedColumn = new int[indexOfPostPonedColumn.length << 1];
                            System.arraycopy(indexOfPostPonedColumn, 0, newindexOfPostPonedColumn, 0, indexOfPostPonedColumn.length);
                            indexOfPostPonedColumn = newindexOfPostPonedColumn;
                        }
                        indexOfPostPonedColumn[nbPostPonedColumns++] = position;
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: skipping stream. streamsToBeMarshaled[{0}] = {1}", (String)null, (Throwable)null, (Object)(nbPostPonedColumns - 1), (Object)position);
                        continue;
                    }
                    if (nullIndicator == -1) {
                        if (type == 109 || marshalNullObjectForDmlReturning) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal null NAMED_TYPE", null, null);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (type == 998) {
                            ++nbOfIbt;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type == 112 || type == 113 || type == 114 || type == 119) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type == 252 && this.connection.getTTCVersion() < 17) {
                            this.meg.marshalUB1((short)-3);
                            this.meg.marshalUB1((short)1);
                            continue;
                        }
                        if (type != 8 && type != 24) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal null", null, null);
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (type == 998) {
                        int nbOfElem = (ibtBindIndicators[6 + nbOfIbt * 8 + 4] & 0xFFFF) << 16 & 0xFFFF0000 | ibtBindIndicators[6 + nbOfIbt * 8 + 5] & 0xFFFF;
                        int offsetValue = (ibtBindIndicators[6 + nbOfIbt * 8 + 6] & 0xFFFF) << 16 & 0xFFFF0000 | ibtBindIndicators[6 + nbOfIbt * 8 + 7] & 0xFFFF;
                        int typeElem = ibtBindIndicators[6 + nbOfIbt * 8] & 0xFFFF;
                        int elemMaxLen = ibtBindIndicators[6 + nbOfIbt * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(nbOfElem);
                        byte[] byteBufferForCharConversion = null;
                        for (int i = 0; i < nbOfElem; ++i) {
                            int offsetValueElem = offsetValue + i * elemMaxLen;
                            if (typeElem == 9) {
                                int nbOfChars = ibtBindChars[offsetValueElem] / 2;
                                if (byteBufferForCharConversion == null) {
                                    byteBufferForCharConversion = this.connection.getByteBuffer(nbOfChars * 4);
                                } else if (byteBufferForCharConversion.length < nbOfChars * 4) {
                                    this.connection.cacheBuffer(byteBufferForCharConversion);
                                    byteBufferForCharConversion = this.connection.getByteBuffer(nbOfChars * 4);
                                }
                                int nbOfBytes = this.connection.conversion.javaCharsToCHARBytes(ibtBindChars, offsetValueElem + 1, byteBufferForCharConversion, 0, nbOfChars);
                                this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                                continue;
                            }
                            length = ibtBindBytes[offsetValueElem];
                            if (length < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(ibtBindBytes, offsetValueElem + 1, length);
                        }
                        this.connection.cacheBuffer(byteBufferForCharConversion);
                        ++nbOfIbt;
                        continue;
                    }
                    int bytePitch = bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (bytePitch != 0) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "Marshaling byte data", null, null);
                        if (type == 6) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "Accessor.VARNUM length: {0}", (String)null, (Throwable)null, (Object)length);
                            --length;
                        } else if (type == 9) {
                            length -= 2;
                        } else if (type == 114 || type == 113 || type == 112) {
                            this.meg.marshalUB4(length);
                        }
                        if (type == 109 || type == 111) {
                            bindDataIndex = rowIndex * number_of_bind_positions + position;
                            int imageLength = bindDataLengths[bindDataIndex];
                            if (type == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(imageLength);
                                this.meg.marshalUB2(1);
                            }
                            if (imageLength <= 0) continue;
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "bindDataIndex: {0} rowIndex: {1} number_of_bind_positions: {2} position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)position);
                            this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                            continue;
                        }
                        if (type == 104) {
                            bindDataIndex = rowIndex * number_of_bind_positions + position;
                            int payloadLength = bindDataLengths[bindDataIndex];
                            tmp = new byte[payloadLength];
                            bindData.get(bindDataOffsets[bindDataIndex], tmp, 0, payloadLength);
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal ROWID payloadLength: {0}", (String)null, (Throwable)null, (Object)payloadLength);
                            long[] rowid = T4CRowidAccessor.stringToRowid(tmp, 2, 18);
                            short len = 14;
                            long rba = rowid[0];
                            int partitionID = (int)rowid[1];
                            short tableID = 0;
                            long blockNumber = rowid[2];
                            int slotNumber = (int)rowid[3];
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal rowid : len={0}, rba={1}, partition={2}, tableID={3}, blockNumber={4}, slotNumber={5}", (String)null, (Throwable)null, (Object)len, (Object)rba, (Object)partitionID, (Object)tableID, (Object)blockNumber, (Object)slotNumber);
                            if (rba == 0L && partitionID == 0 && blockNumber == 0L && slotNumber == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1(len);
                            this.meg.marshalUB4(rba);
                            this.meg.marshalUB2(partitionID);
                            this.meg.marshalUB1(tableID);
                            this.meg.marshalUB4(blockNumber);
                            this.meg.marshalUB2(slotNumber);
                            continue;
                        }
                        if (type == 208) {
                            this.meg.marshalUB4(length -= 2);
                            bindDataIndex = rowIndex * number_of_bind_positions + position;
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "bindUseDBA bindDataIndex: {0} rowIndex: {1} number_of_bind_positions: {2} position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)position);
                            this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                            continue;
                        }
                        if (type == 119) {
                            bindDataIndex = rowIndex * number_of_bind_positions + position;
                            byte[] locator = T4CConnection.setupQuasiLocator(bindDataLengths[bindDataIndex]);
                            this.meg.marshalUB4(locator.length);
                            this.meg.marshalCLR(locator, locator.length);
                            if (this.connection.isZeroCopyIOEnabled()) {
                                this.meg.writeZeroCopyIO((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                                continue;
                            }
                            this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                            continue;
                        }
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "length: {0}", (String)null, (Throwable)null, (Object)length);
                        if (length < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        bindDataIndex = rowIndex * number_of_bind_positions + position;
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "bindUseDBA bindDataIndex: {0} rowIndex: {1} number_of_bind_positions: {2} position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)position);
                        if ((type == 112 || type == 113) && bindData.get(bindDataOffsets[bindDataIndex] + 2L + 1L) == 4) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "binding both quasi locator and lob data", null, null);
                            this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], length);
                            if (this.connection.isZeroCopyIOEnabled()) {
                                this.meg.writeZeroCopyIO((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex] + (long)length, bindDataLengths[bindDataIndex] - length);
                                continue;
                            }
                            this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex] + (long)length, bindDataLengths[bindDataIndex] - length);
                            continue;
                        }
                        this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                        continue;
                    }
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "Marshalling char data", null, null);
                    bindDataIndex = rowIndex * number_of_bind_positions + position;
                    int currentPosition = position;
                    if (this.isDebugEnabled()) {
                        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "bindDataIndex: {0}, rowIndex: {1}, number_of_bind_positions: {2}, position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)currentPosition);
                    }
                    this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                }
                nbPostPonedColumnsAdjusted = nbPostPonedColumns;
            }
            if (nbPostPonedColumns > 0) {
                for (int j = 0; j < nbPostPonedColumnsAdjusted; ++j) {
                    int position = indexOfPostPonedColumn[j];
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal postponed colum: {0}", (String)null, (Throwable)null, (Object)j);
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * position;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowIndex;
                    nullIndicator = bindIndicators[nullOffset];
                    if (nullIndicator == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 996) {
                        bindDataIndex = rowIndex * number_of_bind_positions + position;
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "postponed column bindUseDBA bindDataIndex: {0} rowIndex: {1} number_of_bind_positions: {2} position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)position);
                        this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                        continue;
                    }
                    if (type != 8 && type != 24) {
                        bindDataIndex = rowIndex * number_of_bind_positions + position;
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "postponed column bindUseDBA bindDataIndex: {0} rowIndex: {1} number_of_bind_positions: {2} position: {3}", (String)null, (Throwable)null, (Object)bindDataIndex, (Object)rowIndex, (Object)number_of_bind_positions, (Object)position);
                        this.meg.marshalCLR((DynamicByteArray)bindData, bindDataOffsets[bindDataIndex], bindDataLengths[bindDataIndex]);
                        continue;
                    }
                    int positionOfStream = position;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: j = {0} positionOfStream = {1}", (String)null, (Throwable)null, (Object)j, (Object)positionOfStream);
                    if (parameterStream != null) {
                        InputStream currentStream = parameterStream[positionOfStream];
                        if (currentStream != null) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshalling stream {0}", (String)null, (Throwable)null, (Object)currentStream);
                            try {
                                this.meg.marshalCLR(currentStream, 0);
                            }
                            catch (IOException streamIOException) {
                                if (ioExceptionsFromUserStream == null) {
                                    ioExceptionsFromUserStream = new Vector<IOException>();
                                }
                                ioExceptionsFromUserStream.add(streamIOException);
                            }
                            continue;
                        }
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: currentStream = null", null, null);
                        continue;
                    }
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalBindDBA", "marshal: parameterStream = null", null, null);
                }
            }
            nbPostPonedColumnsInOut[0] = nbPostPonedColumns;
            indexOfPostPonedColumnInOut[0] = indexOfPostPonedColumn;
        }
        catch (SQLException sqlex) {
            IOException ioex = new IOException();
            ioex.initCause(sqlex);
            throw ioex;
        }
        return ioExceptionsFromUserStream;
    }

    Vector<IOException> marshalPrimitive(byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, byte[] byteBufferForCharConversion, DBConversion conversion, InputStream[] parameterStream, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators, byte[] ioVector, int rowId, int[] oacmxlArr, boolean isPlsql, int[] returnParamMeta, int[] nbPostPonedColumnsInOut, int[][] indexOfPostPonedColumnInOut, boolean sendFirstPostPonedColumnOnly) throws IOException {
        Vector<IOException> ioExceptionsFromUserStream = null;
        try {
            int offsetCharData;
            int charPitch;
            int formOfUse;
            int nbOfBytes;
            int nbOfChars;
            int nullIndicator;
            int length;
            int nullOffset;
            int valueLengthOffset;
            int type;
            int subRangeOffset;
            int nbPostPonedColumnsAdjusted;
            this.marshalTTCcode();
            int number_of_bind_positions = bindIndicators[bindIndicatorSubRange + 0] & 0xFFFF;
            int nbOfStreams = 0;
            int nbPostPonedColumns = nbPostPonedColumnsInOut[0];
            int[] indexOfPostPonedColumn = indexOfPostPonedColumnInOut[0];
            int nbOfIbt = 0;
            if (sendFirstPostPonedColumnOnly) {
                nbPostPonedColumnsAdjusted = 1;
                assert (nbPostPonedColumns > 0) : "No postoned columns in RXD";
            } else {
                for (int P = 0; P < number_of_bind_positions; ++P) {
                    if (nbOfStreams < nbPostPonedColumns && indexOfPostPonedColumn[nbOfStreams] == P) {
                        ++nbOfStreams;
                        continue;
                    }
                    boolean marshalNullObjectForDmlReturning = false;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: P = {0}", (String)null, (Throwable)null, (Object)P);
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * P;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: type: {0}", (String)null, (Throwable)null, (Object)type);
                    if (ioVector != null && (ioVector[P] & 0x20) == 0) {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: OUT ONLY", null, null);
                        if (type != 998) continue;
                        ++nbOfIbt;
                        continue;
                    }
                    valueLengthOffset = ((bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 8] & 0xFFFF) + rowId;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowId;
                    length = bindIndicators[valueLengthOffset] & 0xFFFF;
                    nullIndicator = bindIndicators[nullOffset];
                    if (type == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 994) {
                        nullIndicator = -1;
                        int dty = returnParamMeta[3 + P * 4 + 0];
                        if (dty == 109) {
                            marshalNullObjectForDmlReturning = true;
                        }
                    } else if (type == 8 || type == 24 || !isPlsql && oacmxlArr != null && oacmxlArr.length > P && oacmxlArr[P] > this.connection.maxNonStreamBindByteSize) {
                        if (nbPostPonedColumns >= indexOfPostPonedColumn.length) {
                            int[] newindexOfPostPonedColumn = new int[indexOfPostPonedColumn.length << 1];
                            System.arraycopy(indexOfPostPonedColumn, 0, newindexOfPostPonedColumn, 0, indexOfPostPonedColumn.length);
                            indexOfPostPonedColumn = newindexOfPostPonedColumn;
                        }
                        indexOfPostPonedColumn[nbPostPonedColumns++] = P;
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "skipping stream. streamsToBeMarshaled[{0}] = {1}", (String)null, (Throwable)null, (Object)(nbPostPonedColumns - 1), (Object)P);
                        continue;
                    }
                    if (nullIndicator == -1) {
                        if (type == 109 || marshalNullObjectForDmlReturning) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal null NAMED_TYPE", null, null);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (type == 998) {
                            ++nbOfIbt;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type == 112 || type == 113 || type == 114 || type == 119) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (type != 8 && type != 24) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal null", null, null);
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (type == 998) {
                        int nbOfElem = (ibtBindIndicators[6 + nbOfIbt * 8 + 4] & 0xFFFF) << 16 & 0xFFFF0000 | ibtBindIndicators[6 + nbOfIbt * 8 + 5] & 0xFFFF;
                        int offsetValue = (ibtBindIndicators[6 + nbOfIbt * 8 + 6] & 0xFFFF) << 16 & 0xFFFF0000 | ibtBindIndicators[6 + nbOfIbt * 8 + 7] & 0xFFFF;
                        int typeElem = ibtBindIndicators[6 + nbOfIbt * 8] & 0xFFFF;
                        int elemMaxLen = ibtBindIndicators[6 + nbOfIbt * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(nbOfElem);
                        for (int i = 0; i < nbOfElem; ++i) {
                            int offsetValueElem = offsetValue + i * elemMaxLen;
                            if (typeElem == 9) {
                                nbOfChars = ibtBindChars[offsetValueElem] / 2;
                                nbOfBytes = 0;
                                nbOfBytes = conversion.javaCharsToCHARBytes(ibtBindChars, offsetValueElem + 1, byteBufferForCharConversion, 0, nbOfChars);
                                this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                                continue;
                            }
                            length = ibtBindBytes[offsetValueElem];
                            if (length < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(ibtBindBytes, offsetValueElem + 1, length);
                        }
                        ++nbOfIbt;
                        continue;
                    }
                    int bytePitch = bindIndicators[subRangeOffset + 1] & 0xFFFF;
                    if (bytePitch != 0) {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "Marshaling byte data", null, null);
                        int offsetByteData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + bytePitch * rowId;
                        if (type == 6) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "Accessor.VARNUM length: {0}", (String)null, (Throwable)null, (Object)length);
                            ++offsetByteData;
                            --length;
                        } else if (type == 9) {
                            offsetByteData += 2;
                            length -= 2;
                        } else if (type == 114 || type == 113 || type == 112) {
                            this.meg.marshalUB4(length);
                        }
                        if (type == 109 || type == 111) {
                            if (type == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(length);
                                this.meg.marshalUB2(1);
                            }
                            if (length <= 0) continue;
                            this.meg.marshalCLR(bindBytes, offsetByteData, length);
                            continue;
                        }
                        if (type == 104) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal ROWID offsetByteData: {0}", (String)null, (Throwable)null, (Object)(offsetByteData += 2));
                            long[] rowid = T4CRowidAccessor.stringToRowid(bindBytes, offsetByteData, 18);
                            short len = 14;
                            long rba = rowid[0];
                            int partitionID = (int)rowid[1];
                            short tableID = 0;
                            long blockNumber = rowid[2];
                            int slotNumber = (int)rowid[3];
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshalOneRow : len={0}, rba={1}, partition={2}, tableID={3}, blockNumber={4}, slotNumber={5}", (String)null, (Throwable)null, (Object)len, (Object)rba, (Object)partitionID, (Object)tableID, (Object)blockNumber, (Object)slotNumber);
                            if (rba == 0L && partitionID == 0 && blockNumber == 0L && slotNumber == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1(len);
                            this.meg.marshalUB4(rba);
                            this.meg.marshalUB2(partitionID);
                            this.meg.marshalUB1(tableID);
                            this.meg.marshalUB4(blockNumber);
                            this.meg.marshalUB2(slotNumber);
                            continue;
                        }
                        if (type == 208) {
                            this.meg.marshalUB4(length -= 2);
                            this.meg.marshalCLR(bindBytes, offsetByteData += 2, length);
                            continue;
                        }
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "length: {0}", (String)null, (Throwable)null, (Object)length);
                        if (length < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(bindBytes, offsetByteData, length);
                        continue;
                    }
                    formOfUse = bindIndicators[subRangeOffset + 9] & 0xFFFF;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "Marshalling char data", null, null);
                    charPitch = bindIndicators[subRangeOffset + 2] & 0xFFFF;
                    offsetCharData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + charPitch * rowId + 1;
                    if (type == 996) {
                        int nbOfCHARBytes = bindChars[offsetCharData - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < nbOfCHARBytes) {
                            this.bufferCHAR = new byte[nbOfCHARBytes];
                        }
                        for (int i = 0; i < nbOfCHARBytes; ++i) {
                            this.bufferCHAR[i] = (byte)((bindChars[offsetCharData + i / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i >= nbOfCHARBytes - '\u0001') continue;
                            this.bufferCHAR[i + 1] = (byte)(bindChars[offsetCharData + i / 2] & 0xFF & 0xFF);
                            ++i;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, nbOfCHARBytes);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal default to regular char case", null, null);
                    if (type == 96) {
                        nbOfChars = length / 2;
                        --offsetCharData;
                    } else {
                        nbOfChars = (length - 2) / 2;
                    }
                    nbOfBytes = 0;
                    nbOfBytes = formOfUse == 2 ? conversion.javaCharsToNCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars) : conversion.javaCharsToCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars);
                    this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                }
                nbPostPonedColumnsAdjusted = nbPostPonedColumns;
            }
            if (nbPostPonedColumns > 0) {
                for (int j = 0; j < nbPostPonedColumnsAdjusted; ++j) {
                    int P = indexOfPostPonedColumn[j];
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal postponed colum: {0}", (String)null, (Throwable)null, (Object)j);
                    subRangeOffset = bindIndicatorSubRange + 5 + 10 * P;
                    type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    valueLengthOffset = ((bindIndicators[subRangeOffset + 7] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 8] & 0xFFFF) + rowId;
                    nullOffset = ((bindIndicators[subRangeOffset + 5] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 6] & 0xFFFF) + rowId;
                    nullIndicator = bindIndicators[nullOffset];
                    length = bindIndicators[valueLengthOffset] & 0xFFFF;
                    charPitch = bindIndicators[subRangeOffset + 2] & 0xFFFF;
                    offsetCharData = ((bindIndicators[subRangeOffset + 3] & 0xFFFF) << 16) + (bindIndicators[subRangeOffset + 4] & 0xFFFF) + charPitch * rowId + 1;
                    if (nullIndicator == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (type == 996) {
                        int nbOfCHARBytes = bindChars[offsetCharData - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < nbOfCHARBytes) {
                            this.bufferCHAR = new byte[nbOfCHARBytes];
                        }
                        for (int i = 0; i < nbOfCHARBytes; ++i) {
                            this.bufferCHAR[i] = (byte)((bindChars[offsetCharData + i / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i >= nbOfCHARBytes - '\u0001') continue;
                            this.bufferCHAR[i + 1] = (byte)(bindChars[offsetCharData + i / 2] & 0xFF & 0xFF);
                            ++i;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, nbOfCHARBytes);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (type != 8 && type != 24) {
                        if (type == 96) {
                            nbOfChars = length / 2;
                            --offsetCharData;
                        } else {
                            nbOfChars = (length - 2) / 2;
                        }
                        formOfUse = bindIndicators[subRangeOffset + 9] & 0xFFFF;
                        nbOfBytes = 0;
                        nbOfBytes = formOfUse == 2 ? conversion.javaCharsToNCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars) : conversion.javaCharsToCHARBytes(bindChars, offsetCharData, byteBufferForCharConversion, 0, nbOfChars);
                        this.meg.marshalCLR(byteBufferForCharConversion, nbOfBytes);
                        continue;
                    }
                    int positionOfStream = P;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: j = {0} positionOfStream = {1}", (String)null, (Throwable)null, (Object)j, (Object)positionOfStream);
                    if (parameterStream != null) {
                        InputStream currentStream = parameterStream[positionOfStream];
                        if (currentStream != null) {
                            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshalling stream {0}", (String)null, (Throwable)null, (Object)currentStream);
                            try {
                                this.meg.marshalCLR(currentStream, 0);
                            }
                            catch (IOException streamIOException) {
                                if (ioExceptionsFromUserStream == null) {
                                    ioExceptionsFromUserStream = new Vector<IOException>();
                                }
                                ioExceptionsFromUserStream.add(streamIOException);
                            }
                            continue;
                        }
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: currentStream = null", null, null);
                        continue;
                    }
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "marshalPrimitive", "marshal: parameterStream = null", null, null);
                }
            }
            nbPostPonedColumnsInOut[0] = nbPostPonedColumns;
            indexOfPostPonedColumnInOut[0] = indexOfPostPonedColumn;
        }
        catch (SQLException sqlex) {
            IOException ioex = new IOException();
            ioex.initCause(sqlex);
            throw ioex;
        }
        return ioExceptionsFromUserStream;
    }

    boolean unmarshal(Accessor[] accessors, int definesLength) throws SQLException, IOException {
        return this.unmarshal(accessors, 0, definesLength);
    }

    void copyRowsAsNeeded(Accessor[] accessors, int definesLength) throws SQLException, IOException {
        if (this.rowCount == 1) {
            this.copyRowsAsNeededByOffset(accessors, definesLength);
        } else {
            int lastIndex = Math.min(definesLength, accessors.length);
            for (int colIndex = 0; colIndex < lastIndex; ++colIndex) {
                Accessor acc = accessors[colIndex];
                if (acc.isUseLess || this.bvcColSent.get(acc.physicalColumnIndex)) continue;
                acc.copyRow();
            }
        }
    }

    void copyRowsAsNeededByOffset(Accessor[] accessors, int definesLength) throws SQLException, IOException {
        int colIndex;
        int lastIndex = Math.min(definesLength, accessors.length);
        for (colIndex = 0; colIndex < lastIndex; ++colIndex) {
            Accessor acc = accessors[colIndex];
            if (!acc.isUseLess && !this.bvcColSent.get(acc.physicalColumnIndex)) break;
        }
        if (colIndex < lastIndex) {
            if (this.indicesOfColumnsToBeCopied == null || this.indicesOfColumnsToBeCopied.length != this.nbOfColumns) {
                this.indicesOfColumnsToBeCopied = new int[this.nbOfColumns];
            }
            int numColumnsToBeCopied = 0;
            while (colIndex < lastIndex) {
                Accessor acc = accessors[colIndex];
                if (!acc.isUseLess && !this.bvcColSent.get(acc.physicalColumnIndex)) {
                    this.indicesOfColumnsToBeCopied[numColumnsToBeCopied++] = colIndex;
                }
                ++colIndex;
            }
            if (this.isLoggable(Level.FINEST)) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "copyRowsAsNeededByOffset", this.dumpIndicesOfColumnsToBeCopied(numColumnsToBeCopied, this.indicesOfColumnsToBeCopied, accessors), null, null);
            }
            MinHeap heap = new MinHeap(accessors, this.indicesOfColumnsToBeCopied, numColumnsToBeCopied);
            while (numColumnsToBeCopied > 0) {
                accessors[heap.removeLeast()].copyRow();
                --numColumnsToBeCopied;
            }
        }
    }

    boolean unmarshal(Accessor[] accessors, int from_col, int definesLength) throws SQLException, IOException {
        int colIndex;
        ++this.rowCount;
        for (colIndex = from_col; colIndex < definesLength && colIndex < accessors.length; ++colIndex) {
            if (accessors[colIndex] == null || accessors[colIndex].physicalColumnIndex >= 0) continue;
            int physicalIndex = 0;
            for (int j = 0; j < definesLength && j < accessors.length; ++j) {
                if (accessors[j] == null) continue;
                accessors[j].physicalColumnIndex = physicalIndex++;
                if (accessors[j].isUseLess) continue;
            }
        }
        if (this.bvcFound && from_col == 0) {
            this.copyRowsAsNeeded(accessors, definesLength);
        }
        colIndex = 0;
        for (colIndex = from_col; colIndex < definesLength && colIndex < accessors.length; ++colIndex) {
            if (accessors[colIndex] == null || this.bvcFound && !accessors[colIndex].isUseLess && !this.bvcColSent.get(accessors[colIndex].physicalColumnIndex)) continue;
            if (accessors[colIndex].statement.statementType == 2 || accessors[colIndex].statement.sqlKind.isPlsqlOrCall()) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshal", "out binds only have one row", null, null);
                accessors[colIndex].setCapacity(1);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshal", "unmarshal call unmarshalOneRow", null, null);
            if (!accessors[colIndex].unmarshalOneRow()) continue;
            return true;
        }
        this.bvcFound = false;
        return false;
    }

    String dumpIndicesOfColumnsToBeCopied(int numColumnsToBeCopied, int[] indicesOfColumnsToBeCopied, Accessor[] accessors) throws SQLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("dump indicesOfColumnsToBeCopied call_count: " + call_count++ + " numColumnsToBeCopied: " + numColumnsToBeCopied);
        for (int kkk = 0; kkk < numColumnsToBeCopied; ++kkk) {
            long o = accessors[indicesOfColumnsToBeCopied[kkk]].getOffset(0);
            pw.println("copy order: " + kkk + " index: " + indicesOfColumnsToBeCopied[kkk] + " offset: " + o);
        }
        pw.println();
        return sw.toString();
    }

    boolean unmarshal(Accessor[] accessors, int row_number, int from_col, int to_col) throws SQLException, IOException {
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static final class BitSet {
        private static final int[] SET_MASK = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        private static final int[] CLEAR_MASK = new int[]{254, 253, 251, 247, 239, 223, 191, 127};
        private final int capacity;
        private final byte[] bits;

        BitSet(int size) {
            this.bits = new byte[(size + 7) / 8];
            this.capacity = this.bits.length * 8;
        }

        final int length() {
            return this.capacity;
        }

        final void set(int bit) {
            int n = bit / 8;
            this.bits[n] = (byte)(this.bits[n] | SET_MASK[bit % 8]);
        }

        final void set(int byteIndex, byte eightBits) {
            this.bits[byteIndex] = eightBits;
        }

        final void clear(int bit) {
            int n = bit / 8;
            this.bits[n] = (byte)(this.bits[n] & CLEAR_MASK[bit % 8]);
        }

        final boolean get(int bit) {
            return (this.bits[bit / 8] & SET_MASK[bit % 8]) > 0;
        }

        final void clear() {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0;
            }
        }
    }

    static class MinHeap {
        private final Accessor[] accessors;
        private final int[] heap;
        private int length;

        MinHeap(Accessor[] acc, int[] indices, int len) {
            this.accessors = acc;
            this.heap = indices;
            this.length = len;
            this.heapify();
        }

        private void heapify() {
            int node;
            for (int i = node = (this.length - 2) / 2; i >= 0; --i) {
                this.heapify(i);
            }
        }

        private void heapify(int start) {
            int current = start;
            while (true) {
                int left = 2 * current + 1;
                int right = 2 * current + 2;
                int min = current;
                if (left < this.length && this.accessors[this.heap[left]].previousOffset() < this.accessors[this.heap[min]].previousOffset()) {
                    min = left;
                }
                if (right < this.length && this.accessors[this.heap[right]].previousOffset() < this.accessors[this.heap[min]].previousOffset()) {
                    min = right;
                }
                if (min == current) break;
                int tmp = this.heap[current];
                this.heap[current] = this.heap[min];
                this.heap[min] = tmp;
                current = min;
            }
        }

        int removeLeast() {
            int least = this.heap[0];
            this.heap[0] = this.heap[--this.length];
            this.heapify(0);
            return least;
        }

        public String toString() {
            String s = "<<" + this.length + ":";
            for (int i = 0; i < this.length; ++i) {
                s = s + this.heap[i] + "|" + this.accessors[this.heap[i]].previousOffset() + ", ";
            }
            return s + ">>";
        }
    }
}

