/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Stack;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterSet;

abstract class ByteArray
implements Diagnosable {
    private static final String CLASS_NAME = ByteArray.class.getName();
    protected long position = 0L;
    final Diagnosable diagnosable;
    private Stack<Long> positions = new Stack();

    ByteArray(Diagnosable diagnosable) {
        this.diagnosable = diagnosable;
    }

    abstract long length();

    abstract long getCapacity();

    final long getPosition() {
        return this.position;
    }

    final void setPosition(long index) {
        assert (index >= 0L) : "index: " + index;
        assert (this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = index;
    }

    final void pushPosition(long newPosition) {
        assert (newPosition >= 0L) : "newPosition: " + newPosition;
        this.positions.push(this.position);
        this.position = newPosition;
    }

    final long popPosition() {
        assert (!this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = this.positions.pop();
        return this.position;
    }

    final void reset() {
        this.setPosition(0L);
    }

    final byte get() {
        assert (this.position < this.length()) : "position: " + this.position + " length: " + this.length();
        return this.get(this.position++);
    }

    final byte[] getBytes(int length) {
        assert (length >= 0 && this.length() >= this.getPosition() + (long)length) : "this.length: " + this.length() + " position: " + this.position + " length: " + length;
        byte[] result = this.get(this.position, length);
        this.position += (long)length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getBytes", "position increased by={0}, to={1}. ", (String)null, (Throwable)null, (Object)length, (Object)this.position);
        return result;
    }

    final void getBytes(byte[] dest, int destOffset, int length) {
        assert (dest != null) : "dest is null";
        assert (destOffset >= 0 && length >= 0 && dest.length >= destOffset + length) : "destOffset: " + destOffset + " length: " + length + " dest.length: " + dest.length;
        assert (this.length() >= this.position + (long)length) : " this.length: " + this.length() + " this.position: " + this.position + " length: " + length;
        this.get(this.position, dest, destOffset, length);
        this.position += (long)length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getBytes", "position increased by={0}, to={1}. ", (String)null, (Throwable)null, (Object)length, (Object)this.position);
    }

    final int getShort() {
        assert (this.position + 1L < this.length()) : "position: " + this.position + " length: " + this.length();
        return (this.get() & 0xFF) << 8 | this.get() & 0xFF;
    }

    final int getInt() {
        assert (this.position + 3L < this.length()) : "position: " + this.position + " length: " + this.length();
        return (this.get() & 0xFF) << 24 | (this.get() & 0xFF) << 16 | (this.get() & 0xFF) << 8 | this.get() & 0xFF;
    }

    final String getString(int lengthInBytes, CharacterSet charSet) throws SQLException {
        String result = this.getString(this.position, lengthInBytes, charSet);
        this.position += (long)lengthInBytes;
        return result;
    }

    final int putString(String val, CharacterSet charSet) throws SQLException {
        int result = this.putString(this.position, val, charSet);
        this.position += (long)result;
        return result;
    }

    final int putStringWithReplacement(String val, CharacterSet charSet) throws SQLException {
        int result = this.putStringWithReplacement(this.position, val, charSet);
        this.position += (long)result;
        return result;
    }

    final int putAsciiString(String asciiString) {
        int result = this.putAsciiString(this.position, asciiString);
        this.position += (long)result;
        return result;
    }

    final void put(byte val) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "put(byte)", "position increased by 1, to={0}. ", (String)null, (Throwable)null, (Object)this.position);
        this.put(this.position++, val);
    }

    final void putShort(short val) {
        this.putShort(this.position, val);
        this.position += 2L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "putShort", "position increased by 2, to={0}. ", (String)null, (Throwable)null, (Object)this.position);
    }

    final void putInt(int val) {
        this.putInt(this.position, val);
        this.position += 4L;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "putInt", "position increased by 4 to={0}. ", (String)null, (Throwable)null, (Object)this.position);
    }

    final void put(byte[] src) {
        this.put(this.position, src);
        this.position += (long)src.length;
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "put", "position increased by {0}, to={1}. ", (String)null, (Throwable)null, (Object)src.length, (Object)this.position);
    }

    final void put(byte[] src, int srcOffset, int length) {
        assert (src != null) : "src is null";
        assert (srcOffset >= 0 && length >= 0) : "srcOffset: " + srcOffset + " length: " + length;
        assert (src.length >= srcOffset + length) : "src.length: " + src.length + " srcOffset: " + srcOffset + " length: " + length;
        this.put(this.position, src, srcOffset, length);
        this.position += (long)length;
    }

    abstract void put(long var1, byte var3);

    abstract byte get(long var1);

    final void putShort(long offset, short val) {
        this.put(offset, (byte)(val >> 8 & 0xFF));
        this.put(offset + 1L, (byte)(val & 0xFF));
    }

    final void putInt(long offset, int val) {
        for (int i = 3; i >= 0; --i) {
            this.put(offset + (long)i, (byte)(val & 0xFF));
            val >>= 8;
        }
    }

    final void put(long offset, byte[] src) {
        assert (offset >= 0L && src != null) : "offset: " + offset + " src: " + src;
        this.put(offset, src, 0, src.length);
    }

    abstract void put(long var1, byte[] var3, int var4, int var5);

    void put(long offset, ByteArray src, long srcOffset, int length) {
        assert (offset >= 0L && src != null && srcOffset >= 0L) : "offset: " + offset + " src: " + src + " srcOffset: " + srcOffset;
        byte[] b = src.get(srcOffset, length);
        this.put(offset, b, 0, length);
    }

    final byte[] get(long offset, int length) {
        assert (offset >= 0L && length >= 0 && this.length() >= offset + (long)length) : "this.length: " + this.length() + " offset: " + offset + " length: " + length;
        byte[] result = new byte[length];
        this.get(offset, result, 0, length);
        return result;
    }

    abstract void get(long var1, byte[] var3, int var4, int var5);

    String getString(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] lengthInChars = new int[1];
        char[] chars = this.getChars(offset, lengthInBytes, charSet, lengthInChars);
        if (lengthInChars[0] == chars.length) {
            return new String(chars);
        }
        return String.valueOf(chars, 0, lengthInChars[0]);
    }

    int putString(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        byte[] srcBytes = charSet.convert(val);
        this.put(offset, srcBytes);
        return srcBytes.length;
    }

    int putStringWithReplacement(long offset, String val, CharacterSet charSet) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0;
        }
        byte[] srcBytes = charSet.convertWithReplacement(val);
        this.put(offset, srcBytes);
        return srcBytes.length;
    }

    int putAsciiString(long offset, String asciiString) {
        if (asciiString == null || asciiString.length() == 0) {
            return 0;
        }
        int length = asciiString.length();
        byte[] asciiBytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            asciiBytes[i] = (byte)asciiString.charAt(i);
        }
        this.put(offset, asciiBytes);
        return length;
    }

    char[] getChars(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] lengthInChars = new int[1];
        char[] result = this.getChars(offset, lengthInBytes, charSet, lengthInChars);
        if (lengthInChars[0] == result.length) {
            return result;
        }
        char[] r = new char[lengthInChars[0]];
        System.arraycopy(result, 0, r, 0, r.length);
        return r;
    }

    abstract char[] getChars(long var1, int var3, CharacterSet var4, int[] var5) throws SQLException;

    int getChars(long offset, int lengthInBytes, CharacterSet charSet, char[] dst, int dstOffset) throws SQLException {
        int[] lengthHolder = new int[1];
        System.arraycopy(this.getChars(offset, lengthInBytes, charSet, lengthHolder), 0, dst, dstOffset, lengthHolder[0]);
        return lengthHolder[0];
    }

    boolean equalBytes(long thisOffset, int length, ByteArray that, long thatOffset) throws SQLException {
        if (thisOffset + (long)length >= this.length() || thatOffset + (long)length >= that.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.get(thisOffset + (long)i) == that.get(thatOffset + (long)i)) continue;
            return false;
        }
        return true;
    }

    abstract long updateChecksum(long var1, int var3, CRC64 var4, long var5);

    abstract void updateDigest(MessageDigest var1, long var2, int var4);

    byte[] getBytesFromHex(long offset, int lengthInBytes, CharacterSet charSet) throws SQLException {
        int[] out_lengthInChars = new int[1];
        char[] chars = this.getChars(offset, lengthInBytes, charSet, out_lengthInChars);
        int len = out_lengthInChars[0];
        byte[] result = new byte[(len + 1) / 2];
        boolean hi = true;
        int i = 0;
        for (char c : chars) {
            if (hi) {
                result[i] = (byte)(this.hexDigit2Nibble(c) << 4);
            } else {
                int n = i++;
                result[n] = (byte)(result[n] + (this.hexDigit2Nibble(c) & 0xF));
            }
            hi = !hi;
        }
        return result;
    }

    final int hexDigit2Nibble(char hex) throws SQLException {
        int result = Character.digit(hex, 16);
        if (result == -1) {
            throw (SQLException)DatabaseError.createSqlException(59, "Invalid hex digit: " + hex).fillInStackTrace();
        }
        return result;
    }

    final void freeSpace(long offset, int length) {
    }

    byte[] getBlockBasic(long offset, int[] initialByteIndex) {
        throw new Error("not implemented");
    }

    abstract void free();

    ByteArray compact() {
        return this;
    }

    int getUtf8Bytes(long dataOffset, int dataLength, byte[] buffer, int bufferOffset, CharacterSet charSet) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosable;
    }
}

