/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerThrottlingInfo;
import java.util.function.BiConsumer;
import reactor.core.publisher.Mono;

public class ResourceManagerThrottlingPolicy
implements HttpPipelinePolicy {
    private final BiConsumer<? super HttpResponse, ? super ResourceManagerThrottlingInfo> callback;

    public ResourceManagerThrottlingPolicy(BiConsumer<? super HttpResponse, ? super ResourceManagerThrottlingInfo> callback) {
        this.callback = callback;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.clone().process().flatMap(response -> {
            HttpResponse bufferedResponse = response.buffer();
            this.callback.accept((HttpResponse)bufferedResponse, ResourceManagerThrottlingInfo.fromHeaders(response.getHeaders()));
            return Mono.just((Object)bufferedResponse);
        });
    }
}

