/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.net.auth.wallet;

import com.dbeaver.db.oracle.net.auth.wallet.OracleAuthModelWalletCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class OracleAuthModelWallet
extends AuthModelDatabaseNative<OracleAuthModelWalletCredentials> {
    private static final String ORACLE_WALLET_LOCATION = "oracle.net.wallet_location";
    private static final String ORACLE_WALLET_PASS = "oracle.net.wallet_password";

    @NotNull
    public OracleAuthModelWalletCredentials createCredentials() {
        return new OracleAuthModelWalletCredentials();
    }

    @NotNull
    public OracleAuthModelWalletCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        OracleAuthModelWalletCredentials credentials = (OracleAuthModelWalletCredentials)super.loadCredentials(dataSource, configuration);
        String walletArchive = configuration.getAuthProperty("walletArchive");
        if (walletArchive == null) {
            walletArchive = configuration.getAuthProperty("oracle.wallet.archive");
        }
        credentials.setWalletArchive(CommonUtils.toString((Object)walletArchive));
        credentials.setWalletDir(CommonUtils.toString((Object)configuration.getAuthProperty("oracle.wallet.dir")));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull OracleAuthModelWalletCredentials credentials) {
        configuration.setAuthProperty("oracle.wallet.archive", credentials.getWalletArchive());
        configuration.setAuthProperty("oracle.wallet.dir", credentials.getWalletDir());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull OracleAuthModelWalletCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        if (!CommonUtils.isEmpty((String)credentials.getWalletDir())) {
            connProperties.setProperty(ORACLE_WALLET_LOCATION, "file:" + credentials.getWalletDir());
        } else if (!CommonUtils.isEmpty((String)credentials.getWalletArchive())) {
            String walletDir = (String)dataSource.getContextAttribute(ORACLE_WALLET_LOCATION);
            if (walletDir == null) {
                try {
                    byte[] walletArchive = Base64.getDecoder().decode(credentials.getWalletArchive());
                    Path storageFolder = DBWorkbench.getPlatform().getCertificateStorage().getStorageFolder();
                    Path tempDirectory = Files.createTempDirectory(storageFolder, "oracle-wallet-" + dataSource.getContainer().getId(), new FileAttribute[0]);
                    ((JDBCDataSource)dataSource).trackTempFile(tempDirectory);
                    IOUtils.extractZipArchive((InputStream)new ByteArrayInputStream(walletArchive), (Path)tempDirectory);
                    walletDir = tempDirectory.toAbsolutePath().toString();
                    dataSource.setContextAttribute(ORACLE_WALLET_LOCATION, (Object)walletDir);
                }
                catch (IOException e) {
                    throw new DBException("Can not extract wallet archive", (Throwable)e);
                }
            }
            connProperties.setProperty(ORACLE_WALLET_LOCATION, "file:" + walletDir);
        }
        if (CommonUtils.isNotEmpty((String)configuration.getAuthProperty("oracle.wallet.password"))) {
            connProperties.setProperty(ORACLE_WALLET_PASS, configuration.getAuthProperty("oracle.wallet.password"));
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

