/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.security.user;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;

public abstract class SMSubject
implements DBPNamedObject {
    @NotNull
    protected final String subjectId;
    private final boolean secretStorage;
    @NotNull
    private final Map<String, String> metaParameters = new LinkedHashMap<String, String>();

    public SMSubject(@NotNull String subjectId, @Nullable Map<String, String> metaParameters, boolean secretStorage) {
        this.subjectId = subjectId;
        this.secretStorage = secretStorage;
        if (metaParameters != null) {
            this.metaParameters.putAll(metaParameters);
        }
    }

    @NotNull
    public String getSubjectId() {
        return this.subjectId;
    }

    @NotNull
    public Map<String, String> getMetaParameters() {
        return this.metaParameters;
    }

    public void setMetaParameter(String name, String value) {
        this.metaParameters.put(name, value);
    }

    public void setMetaParameters(@NotNull Map<String, String> parameters) {
        this.metaParameters.clear();
        this.metaParameters.putAll(parameters);
    }

    public boolean isSecretStorage() {
        return this.secretStorage;
    }
}

